/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc;

import com.mojang.brigadier.CommandDispatcher;
import igentuman.nc.content.particles.CapabilityParticleStackHandler;
import igentuman.nc.handler.command.DebugCommand;
import igentuman.nc.handler.command.PatronsCommand;
import igentuman.nc.handler.command.RadiationCommand;
import igentuman.nc.handler.command.StructureCommand;
import igentuman.nc.handler.command.VeinCheckCommand;
import igentuman.nc.handler.config.AcceleratorConfig;
import igentuman.nc.handler.config.ClientConfig;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.handler.config.FusionConfig;
import igentuman.nc.handler.config.KugelblitzConfig;
import igentuman.nc.handler.config.MaterialsConfig;
import igentuman.nc.handler.config.OreGenConfig;
import igentuman.nc.handler.config.ProcessorsConfig;
import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.handler.config.TurbineConfig;
import igentuman.nc.handler.config.WorldConfig;
import igentuman.nc.handler.event.server.WorldEvents;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.network.PacketHandler;
import igentuman.nc.radiation.data.PlayerRadiation;
import igentuman.nc.radiation.data.RadiationEvents;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.radiation.data.WorldRadiation;
import igentuman.nc.setup.ClientSetup;
import igentuman.nc.setup.ModSetup;
import igentuman.nc.setup.Registration;
import igentuman.nc.util.FileExtractor;
import igentuman.nc.util.insitu_leaching.WorldVeinOres;
import igentuman.nc.util.insitu_leaching.WorldVeinsProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nuclearcraft")
public class NuclearCraft {
    public static final Logger LOGGER = LogManager.getLogger();
    public boolean isNcBeStopped = false;
    public static final WorldEvents worldTickHandler = new WorldEvents();
    public static final String MODID = "nuclearcraft";
    public static NuclearCraft instance;
    private final PacketHandler packetHandler;
    private static boolean isBetaBuild;
    public static long currentTick;

    public static void registerConfigs(FMLJavaModLoadingContext context) {
        FileExtractor.preFetchProcessorsConfig();
        FileExtractor.unpackFilesFromFolderToConfig("data/nuclearcraft/fission_fuel", "NuclearCraft/fission_fuel");
        FileExtractor.unpackFilesFromFolderToConfig("data/nuclearcraft/heat_sinks", "NuclearCraft/heat_sinks");
        FileExtractor.unpackFilesFromFolderToConfig("data/nuclearcraft/accelerator_coolers", "NuclearCraft/accelerator_coolers");
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        container.addConfig(new ModConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.spec, container, "NuclearCraft/client.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)MaterialsConfig.spec, container, "NuclearCraft/materials.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)OreGenConfig.spec, container, "NuclearCraft/ore_generation.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.spec, container, "NuclearCraft/common.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)KugelblitzConfig.spec, container, "NuclearCraft/kugelblitz.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)AcceleratorConfig.spec, container, "NuclearCraft/accelerator.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)ProcessorsConfig.spec, container, "NuclearCraft/processors.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)FissionConfig.spec, container, "NuclearCraft/fission.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)FusionConfig.spec, container, "NuclearCraft/fusion.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)TurbineConfig.spec, container, "NuclearCraft/turbine.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)RadiationConfig.spec, container, "NuclearCraft/radiation.toml"));
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)WorldConfig.spec, container, "NuclearCraft/world.toml"));
    }

    @Deprecated
    public NuclearCraft() {
        this(FMLJavaModLoadingContext.get());
    }

    public NuclearCraft(FMLJavaModLoadingContext context) {
        instance = this;
        IEventBus modbus = context.getModEventBus();
        NuclearCraft.registerConfigs(context);
        this.packetHandler = new PacketHandler();
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::gameShuttingDownEvent);
        ModSetup.setup();
        Registration.init(context);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        modbus.addListener(ModSetup::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modbus.addListener(ClientSetup::init));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modbus.addListener(this::registerClientEventHandlers));
        try {
            isBetaBuild = ((IModInfo)ModList.get().getModFileById(MODID).getMods().get(0)).getVersion().getQualifier().contains("beta");
        }
        catch (Exception e) {
            isBetaBuild = false;
        }
    }

    public static PacketHandler packetHandler() {
        return NuclearCraft.instance.packetHandler;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            CommonConfig.setLoaded();
        }
    }

    private void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(VeinCheckCommand.register());
        event.getDispatcher().register(PatronsCommand.register());
        StructureCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        RadiationCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DebugCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void registerClientEventHandlers(FMLClientSetupEvent event) {
        ClientSetup.registerEventHandlers(event);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.m_214293_((String)MODID, (String)path);
    }

    public static ResourceLocation forgeRl(String path) {
        return ResourceLocation.m_214293_((String)"forge", (String)path);
    }

    public static ResourceLocation resourceLoc(String path) {
        return ResourceLocation.m_214293_((String)"c", (String)path);
    }

    private void serverStopped(ServerStoppedEvent event) {
        NuclearCraft.instance.isNcBeStopped = true;
        RadiationEvents.stopTracking();
        WorldVeinsProvider.stopTracking();
        for (ServerLevel level : event.getServer().m_129785_()) {
            MultiblockHandler.get((ResourceKey<Level>)level.m_46472_()).clear();
            RadiationManager.clear((Level)level);
        }
    }

    private void gameShuttingDownEvent(GameShuttingDownEvent event) {
        NuclearCraft.instance.isNcBeStopped = true;
    }

    private void serverStarted(ServerStartedEvent event) {
        NuclearCraft.instance.isNcBeStopped = false;
        currentTick = 0L;
        RadiationEvents.startTracking();
        WorldVeinsProvider.startTracking();
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(WorldRadiation.class);
        event.register(PlayerRadiation.class);
        event.register(WorldVeinOres.class);
        event.register(CapabilityParticleStackHandler.class);
    }

    public static void debugLog(String message) {
        if (((Boolean)CommonConfig.MISC_CONFIG.DEBUG_LOG.get()).booleanValue() || isBetaBuild) {
            LOGGER.info(message);
        }
    }

    static {
        isBetaBuild = false;
        currentTick = 0L;
    }
}

