/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.accelerator;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.MultiblockBlock;
import igentuman.nc.handler.event.client.InputEvents;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.accelerator.CoolerDef;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class CoolerBlock
extends MultiblockBlock {
    public double heat = 0.0;
    public String type = "";
    public CoolerDef def;
    public Component placementRule;

    public CoolerBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(2.0f).m_60999_());
    }

    public CoolerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56743_));
        this.initParams();
    }

    public CoolerBlock(BlockBehaviour.Properties reactorBlocksProperties, CoolerDef def) {
        super(reactorBlocksProperties);
        this.type = def.name;
        this.def = def;
        this.heat = def.getHeat();
    }

    public Component getPlacementRule() {
        if (this.placementRule == null) {
            ArrayList<String> lines = new ArrayList<String>();
            int i = 0;
            if (this.def.getValidator() instanceof CoolerDef.Validator) {
                for (String[] condition : this.def.getValidator().blockLines().keySet()) {
                    if (i > 0) {
                        lines.add(TextUtils.__("heat_sink.and", new Object[0]).getString());
                    }
                    String blocksLine = String.join((CharSequence)(" " + TextUtils.__("heat_sink.or", new Object[0]).getString() + " "), this.getBlockNames(condition[2]));
                    switch (condition[0]) {
                        case ">": {
                            lines.add(TextUtils.__("heat_sink.atleast" + (condition[1].equals("1") ? "" : "s"), condition[1], blocksLine).getString());
                            break;
                        }
                        case "-": {
                            lines.add(TextUtils.__("heat_sink.between", condition[1], blocksLine).getString());
                            break;
                        }
                        case "=": {
                            lines.add(TextUtils.__("heat_sink.exact" + (condition[1].equals("1") ? "" : "s"), condition[1], blocksLine).getString());
                            break;
                        }
                        case "<": {
                            lines.add(TextUtils.__("heat_sink.less_than", condition[1], blocksLine).getString());
                            break;
                        }
                        case "^": {
                            lines.add(TextUtils.__("heat_sink.in_corner", condition[1], blocksLine).getString());
                        }
                    }
                    ++i;
                }
                this.placementRule = TextUtils.__("heat_sink.placement.rule", String.join((CharSequence)" ", lines));
            } else {
                this.placementRule = TextUtils.__("heat_sink.placement.error", new Object[0]);
            }
        }
        return this.placementRule;
    }

    private List<String> getBlockNames(String rawLine) {
        String[] blocks;
        ArrayList<String> names = new ArrayList<String>();
        String[] conditionParts = rawLine.split("=|-|>|<|\\^");
        for (String code : blocks = conditionParts[0].split("\\|")) {
            String id = code;
            if (!id.contains(":")) {
                ResourceLocation res = NuclearCraft.rl(id);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(res);
                names.add(block.m_49954_().getString());
                continue;
            }
            names.add(TextUtils.convertToName(id.split(":")[1]));
        }
        return names;
    }

    private void initParams() {
        Item item = Item.m_41439_((Block)this);
        if (item.toString().isEmpty()) {
            return;
        }
        if (item.toString().contains("empty")) {
            return;
        }
        this.type = item.toString().replace("_cooler", "");
        this.def = AcceleratorRegistration.COOLERS.get(this.type);
        this.heat = this.def.getHeat();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Block block;
        if (!player.m_21120_(hand).m_41619_()) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_() && (block = level.m_8055_(pos).m_60734_()) instanceof CoolerBlock) {
            int id = level.f_46441_.m_188503_(10);
            if (this.isValid(level, pos, null)) {
                player.m_213846_((Component)TextUtils.__("message.heat_sink.valid" + id, new Object[0]));
            } else {
                player.m_213846_((Component)TextUtils.__("message.heat_sink.invalid" + id, new Object[0]));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        if (this.m_5456_().toString().contains("empty")) {
            return;
        }
        this.initParams();
        list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("heat_sink.heat.descr", TextUtils.numberFormat(this.heat)), ChatFormatting.GOLD));
        if (InputEvents.DESCRIPTIONS_SHOW) {
            list.add((Component)TextUtils.applyFormat(this.getPlacementRule(), ChatFormatting.AQUA));
        } else {
            list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.toggle_description_keys", new Object[0]), ChatFormatting.GRAY));
        }
    }

    public boolean isValid(Level level, BlockPos pos, AbstractMultiblock multiblock) {
        return this.def.getValidator().isValid(level, pos, multiblock);
    }
}

