/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.accelerator;

import igentuman.nc.block.MultiblockControllerBlock;
import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.container.LinearAcceleratorContainer;
import igentuman.nc.handler.config.AcceleratorConfig;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearAcceleratorControllerBlock
extends MultiblockControllerBlock
implements EntityBlock {
    public static final String NAME = "linear_accelerator_controller";

    public LinearAcceleratorControllerBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(8.0f, 3600000.0f).m_60999_());
    }

    public LinearAcceleratorControllerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return ((BlockEntityType)AcceleratorRegistration.ACCELERATOR_BE.get(NAME).get()).m_155264_(pPos, pState);
    }

    public InteractionResult m_6227_(@NotNull BlockState state, Level level, final @NotNull BlockPos pos, @NotNull Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity be;
        if (!level.m_5776_() && (be = level.getExistingBlockEntity(pos)) instanceof LinearAcceleratorControllerBE) {
            MenuProvider containerProvider = new MenuProvider(){

                public Component m_5446_() {
                    return TextUtils.__(LinearAcceleratorControllerBlock.NAME, new Object[0]);
                }

                public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new LinearAcceleratorContainer(windowId, pos, playerInventory);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)be.m_58899_());
        }
        return InteractionResult.SUCCESS;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof LinearAcceleratorControllerBE) {
                    LinearAcceleratorControllerBE tile = (LinearAcceleratorControllerBE)t;
                    tile.tickClient();
                    level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(tile.controllerEnabled)), 3);
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof LinearAcceleratorControllerBE) {
                LinearAcceleratorControllerBE tile = (LinearAcceleratorControllerBE)t;
                tile.tickServer();
            }
        };
    }

    public int maxDepth() {
        return switch ((Integer)AcceleratorConfig.ACCELERATOR_CONFIG.SCALE.get()) {
            case 2 -> 1000;
            case 3 -> 10000;
            default -> 100;
        };
    }

    public int minDepth() {
        return switch ((Integer)AcceleratorConfig.ACCELERATOR_CONFIG.SCALE.get()) {
            case 2 -> 60;
            case 3 -> 600;
            default -> 6;
        };
    }

    public void m_5871_(ItemStack pStack, @javax.annotation.Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
            list.add((Component)TextUtils.__("tooltip.nc.energy_eu_tier", new Object[]{this.getTier(pStack)}).m_130940_(ChatFormatting.GOLD));
        }
        list.add((Component)TextUtils.__("tooltip.structure.sizes", "5x5x" + this.minDepth(), "5x5x" + this.maxDepth()).m_130940_(ChatFormatting.ITALIC));
    }

    private CommonConfig.GTCEUCompatibilityConfig.GTCEUTier getTier(ItemStack pStack) {
        return CommonConfig.GTCEUCompatibilityConfig.GTCEUTier.byId(((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.ACCELERATORS_ENERGY_TIER.get())).ordinal() + pStack.m_41784_().m_128451_("upgrade_tier"));
    }
}

