/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.accelerator.entity;

import dan200.computercraft.shared.Capabilities;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.accelerator.AcceleratorPortBlock;
import igentuman.nc.block.accelerator.entity.AbstractAcceleratorControllerBE;
import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import igentuman.nc.compat.cc.RingAcceleratorPeripheral;
import igentuman.nc.compat.oc2.RingAcceleratorDevice;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.accelerator.ThoroidalAcceleratorMultiblock;
import igentuman.nc.util.Equations;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RingAcceleratorControllerBE
extends AbstractAcceleratorControllerBE {
    public static String NAME = "ring_accelerator_controller";
    private LazyOptional<RingAcceleratorPeripheral> peripheralCap;
    protected Direction facing;
    public LinearAcceleratorControllerBE.Recipe recipe;
    protected int reValidateCounter = 0;

    public RingAcceleratorControllerBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)AcceleratorRegistration.ACCELERATOR_BE.get(NAME).get(), pPos, pBlockState);
    }

    @Override
    public List<ItemStack> getAllowedInputItems() {
        return List.of();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new RingAcceleratorPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.contentHandler().getFluidCapability(null);
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.getEnergy().cast();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        if (ModUtil.isOC2Loaded() && cap == RingAcceleratorDevice.DEVICE_CAPABILITY) {
            return this.getOCDevice(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isCasingValid || !this.isInternalValid) {
            this.stopSound();
        }
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        this.changed = false;
        super.tickServer();
        boolean wasEnabled = this.controllerEnabled;
        this.handleValidation();
        if (this.redstoneLevel < 1.0) {
            this.redstoneLevel = this.getRedstoneSignal();
        }
        boolean bl = this.controllerEnabled = this.getMultiblock().isFormed() && this.redstoneLevel > 0.0;
        if (this.controllerEnabled) {
            this.trackChanges(this.contentHandler().tick());
            this.handleMeltdown();
            this.trackChanges(this.accelerateParticle());
        }
        this.heat -= this.coolingRate;
        this.heat = Math.max(0, this.heat);
        this.coolantCoolDown();
        boolean bl2 = this.refreshCacheFlag = !this.getMultiblock().isFormed();
        if (wasEnabled != this.controllerEnabled) {
            this.m_6596_();
        }
        if (this.refreshCacheFlag || this.changed || NuclearCraft.currentTick % 20L == 0L) {
            try {
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)AcceleratorPortBlock.POWERED, (Comparable)Boolean.valueOf(this.controllerEnabled)), 1);
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)AcceleratorPortBlock.POWERED, (Comparable)Boolean.valueOf(this.controllerEnabled)));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private boolean accelerateParticle() {
        this.hasParticle = false;
        if (this.energyStorage().getEnergyStored() < this.energyRequired) {
            return false;
        }
        if (this.particleStorage.getParticle() == null) {
            return false;
        }
        if (!this.drainEnergy()) {
            return false;
        }
        ParticleStack particleStack = this.particleStorage.getParticle();
        particleStack.addFocus(Equations.focusGain(this.focus, particleStack) - Equations.focusLoss(this.beamLength, particleStack));
        particleStack.setMeanEnergy((long)((double)Equations.linacEnergyGain(this.acceleratingVoltage, particleStack) * (this.redstoneLevel / 15.0)));
        this.particleStorage.setParticleStack(particleStack);
        this.heat += this.heatRate;
        this.hasParticle = true;
        this.getMultiblock().extractParticle(particleStack);
        return true;
    }

    @Override
    public ThoroidalAcceleratorMultiblock getMultiblock() {
        if (this.m_58904_().m_5776_()) {
            NuclearCraft.debugLog("Trying to access multiblock from client");
            return null;
        }
        if (this.multiblock == null) {
            this.multiblock = new ThoroidalAcceleratorMultiblock(this);
        }
        return (ThoroidalAcceleratorMultiblock)this.multiblock;
    }

    private void handleMeltdown() {
    }

    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return this.facing;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler().itemHandler;
    }

    @Override
    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    @Override
    public <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.of(() -> RingAcceleratorDevice.createDevice(this)).cast();
    }

    @Override
    public FluidTank getFluidTank(int i) {
        return (FluidTank)this.contentHandler().fluidHandler.tanks.get(i);
    }
}

