/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity;

import igentuman.nc.block.RedstoneDimmerBlock;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.handler.event.client.BlockOverlayHandler;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.builder.MultiblockRenderer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class MultiblockBuilderBE
extends NuclearCraftBE {
    @NBTField
    public int output = 0;
    public HashMap<BlockPos, Block> blockMap = new HashMap();
    private Direction facing;

    public MultiblockBuilderBE(BlockPos pos, BlockState pBlockState) {
        super((BlockEntityType)NCBlocks.MULTIBLOCK_BUILDER_BE.get(), pos, pBlockState);
    }

    @Override
    public void tickClient() {
        if (this.m_58901_() || this.blockMap.isEmpty()) {
            return;
        }
        Vec3i size = MultiblockRenderer.getSize(this.blockMap);
        AABB boundingBox = new AABB(0.0, 0.0, 0.0, (double)(size.m_123341_() + 2), (double)(size.m_123342_() + 2), (double)(size.m_123343_() + 2));
        int offset = switch (this.getFacing()) {
            case Direction.NORTH -> 1;
            case Direction.SOUTH -> size.m_123343_() + 2;
            case Direction.EAST -> size.m_123341_() + 2;
            case Direction.WEST -> 1;
            default -> 0;
        };
        BlockOverlayHandler.addBoxToOutline(boundingBox, 0.5f, 0.9f, 0.9f, 0.8f, this.m_58899_().m_5484_(this.getFacing().m_122424_(), offset));
    }

    public void setBlockMap(HashMap<BlockPos, Block> blockMap) {
        if (this.m_58904_().m_5776_()) {
            this.removeOverlayBox();
        }
        this.blockMap = blockMap;
    }

    private int getRightSignal() {
        return this.m_58904_().m_277185_(this.m_58899_().m_121945_(this.facing.m_122428_()), this.facing);
    }

    private int getLeftSignal() {
        return this.m_58904_().m_277185_(this.m_58899_().m_121945_(this.facing.m_122427_()), this.facing);
    }

    public static Vec3i getSize(HashMap<BlockPos, Block> blockMap) {
        if (blockMap.isEmpty()) {
            return new Vec3i(1, 1, 1);
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : blockMap.keySet()) {
            maxX = Math.max(maxX, pos.m_123341_());
            maxY = Math.max(maxY, pos.m_123342_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        return new Vec3i(maxX, maxY, maxZ);
    }

    public void build(HashMap<BlockPos, Block> blockMap) {
        Vec3i size = MultiblockBuilderBE.getSize(blockMap);
        for (int x = 0; x <= size.m_123341_() + 1; ++x) {
            for (int y = 0; y <= size.m_123342_() + 1; ++y) {
                for (int z = 0; z <= size.m_123343_() + 1; ++z) {
                    if (x != 0 && x != size.m_123341_() + 1 && y != 0 && y != size.m_123342_() + 1 && z != 0 && z != size.m_123343_() + 1) continue;
                    if (x == 0 && z == 0 && y == 0) {
                        blockMap.put(new BlockPos(x, y, z), (Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_controller").get());
                        continue;
                    }
                    if (this.isCorner(x, y, z, size.m_123341_() + 1, size.m_123342_() + 1, size.m_123343_() + 1)) {
                        blockMap.put(new BlockPos(x, y, z), (Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_casing").get());
                        continue;
                    }
                    blockMap.put(new BlockPos(x, y, z), (Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_glass").get());
                }
            }
        }
        int offset = switch (this.getFacing()) {
            case Direction.NORTH -> 1;
            case Direction.SOUTH -> size.m_123343_() + 2;
            case Direction.EAST -> size.m_123341_() + 2;
            case Direction.WEST -> 1;
            default -> 0;
        };
        BlockPos globalPos = this.m_58899_().m_5484_(this.getFacing().m_122424_(), offset);
        for (Map.Entry<BlockPos, Block> entry : blockMap.entrySet()) {
            BlockPos localPos = entry.getKey();
            BlockPos placementPos = globalPos.m_5484_(Direction.UP, localPos.m_123342_());
            switch (this.getFacing()) {
                case NORTH: {
                    placementPos = placementPos.m_5484_(Direction.SOUTH, localPos.m_123343_()).m_5484_(Direction.WEST, -localPos.m_123341_());
                    break;
                }
                case SOUTH: {
                    placementPos = placementPos.m_5484_(Direction.NORTH, -localPos.m_123343_()).m_5484_(Direction.WEST, -localPos.m_123341_());
                    break;
                }
                case EAST: {
                    placementPos = placementPos.m_5484_(Direction.WEST, -localPos.m_123341_()).m_5484_(Direction.NORTH, -localPos.m_123343_());
                    break;
                }
                case WEST: {
                    placementPos = placementPos.m_5484_(Direction.EAST, localPos.m_123341_()).m_5484_(Direction.SOUTH, localPos.m_123343_());
                }
            }
            if (localPos.equals((Object)BlockPos.f_121853_)) {
                Direction controllerFacing = switch (this.getFacing()) {
                    case Direction.NORTH -> Direction.NORTH;
                    case Direction.SOUTH -> Direction.NORTH;
                    case Direction.EAST -> Direction.WEST;
                    case Direction.WEST -> Direction.WEST;
                    default -> Direction.UP;
                };
                this.m_58904_().m_7731_(placementPos, (BlockState)entry.getValue().m_49966_().m_61124_((Property)RedstoneDimmerBlock.HORIZONTAL_FACING, (Comparable)controllerFacing), 3);
                continue;
            }
            this.m_58904_().m_7731_(placementPos, entry.getValue().m_49966_(), 3);
        }
    }

    public void removeOverlayBox() {
        Vec3i size = MultiblockRenderer.getSize(this.blockMap);
        int offset = switch (this.getFacing()) {
            case Direction.NORTH -> 1;
            case Direction.SOUTH -> size.m_123343_() + 2;
            case Direction.EAST -> size.m_123341_() + 2;
            case Direction.WEST -> 1;
            default -> 0;
        };
        BlockOverlayHandler.removeBoxFromOutline(this.m_58899_().m_5484_(this.getFacing().m_122424_(), offset));
    }

    @Override
    public void m_7651_() {
        if (this.m_58904_().m_5776_()) {
            this.removeOverlayBox();
        }
        super.m_7651_();
    }

    private boolean isCorner(int x, int y, int z, int maxX, int maxY, int maxZ) {
        return !((x != 0 && x != maxX || y != 0 && y != maxY) && (x != 0 && x != maxX || z != 0 && z != maxZ) && (y != 0 && y != maxY || z != 0 && z != maxZ));
    }

    private Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.m_58900_().m_61143_((Property)RedstoneDimmerBlock.HORIZONTAL_FACING);
        }
        return this.facing;
    }
}

