/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.fission.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.block.fission.FissionControllerBlock;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.cc.SolidFissionReactorPeripheral;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.compat.oc2.FissionReactorDevice;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.handler.event.client.BlockOverlayHandler;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.handler.sided.capability.NcFluidTank;
import igentuman.nc.item.ItemFuel;
import igentuman.nc.multiblock.fission.FissionReactorMultiblock;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.radiation.ItemRadiation;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.setup.registration.NcParticleTypes;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.lang.invoke.StringConcatFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FissionControllerBE
extends MultiblockControllerBE {
    public static final String NAME = "fission_reactor_controller";
    public final SidedContentHandler contentHandler;
    public final CustomEnergyStorage energyStorage;
    protected final LazyOptional<IEnergyStorage> energy;
    @NBTField
    public double maxHeat;
    @NBTField
    public boolean isSteamMode;
    @NBTField
    public double heat;
    @NBTField
    public int maxSteamOutput;
    @NBTField
    public int fuelCellsCount;
    @NBTField
    public int reactivityLevel;
    @NBTField
    public int irradiationHeat;
    @NBTField
    public int moderatorsCount;
    @NBTField
    public int heatSinksCount;
    @NBTField
    public int moderatorAttachments;
    @NBTField
    public int toggleModeTimer;
    @NBTField
    public boolean enabledByController;
    @NBTField
    public double heatSinkCooling;
    @NBTField
    public double activeCooling;
    @NBTField
    public double heatPerTick;
    @NBTField
    public int energyPerTick;
    @NBTField
    public double heatMultiplier;
    @NBTField
    public int irradiationLines;
    @NBTField
    public double efficiency;
    @NBTField
    public double moderationLevel;
    @NBTField
    public boolean powered;
    @NBTField
    public double steamRate;
    @NBTField
    public int steamPerTick;
    @NBTField
    public int extraFuelCells;
    protected boolean forceShutdown;
    public int fuelCellMultiplier;
    public int moderatorCellMultiplier;
    public boolean controllerEnabled;
    private Direction facing;
    protected List<FissionBoilingRecipe> coolantRecipes;
    protected FissionBoilingRecipe boilingRecipe;
    private List<ItemStack> allowedInputs;
    @NBTField
    public boolean hasRedstoneSignal;
    private double envCooling;
    @NBTField
    public double boilingPenalty;
    @NBTField
    public int connectedPorts;
    @NBTField
    public int allModerators;
    @NBTField
    public int allHeatSinks;
    @NBTField
    public int activeCoolingHeatsinks;
    @NBTField
    public int validIrradiators;
    @NBTField
    public int allIrradiators;
    @NBTField
    public double cellsHeatMult;
    @NBTField
    public double moderatorsHeatMult;
    @NBTField
    public double cellsEnergyMult;
    @NBTField
    public double moderatorsEnergyMult;
    private List<FluidStack> allowedCoolants;
    private List<FluidStack> allowedCoolantOutputs;
    @NBTField
    public boolean canAcceptFluids;
    private LazyOptional<SolidFissionReactorPeripheral> peripheralCap;
    public float speed;
    private double targetModerationLevel;

    public FissionControllerBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FissionReactorRegistration.FISSION_BE.get(NAME).get(), pPos, pBlockState);
        this.maxHeat = (Double)FissionConfig.FISSION_CONFIG.HEAT_CAPACITY.getDefault();
        this.isSteamMode = false;
        this.heat = 0.0;
        this.maxSteamOutput = 0;
        this.fuelCellsCount = 0;
        this.reactivityLevel = 0;
        this.irradiationHeat = 0;
        this.moderatorsCount = 0;
        this.heatSinksCount = 0;
        this.moderatorAttachments = 0;
        this.toggleModeTimer = 2000;
        this.enabledByController = false;
        this.heatSinkCooling = 0.0;
        this.activeCooling = 0.0;
        this.heatPerTick = 0.0;
        this.energyPerTick = 0;
        this.heatMultiplier = 0.0;
        this.irradiationLines = 0;
        this.efficiency = 0.0;
        this.moderationLevel = 1.0;
        this.powered = false;
        this.steamPerTick = 0;
        this.extraFuelCells = 0;
        this.forceShutdown = false;
        this.fuelCellMultiplier = 1;
        this.moderatorCellMultiplier = 1;
        this.controllerEnabled = false;
        this.hasRedstoneSignal = false;
        this.envCooling = 0.0;
        this.boilingPenalty = 0.0;
        this.connectedPorts = 0;
        this.allModerators = 0;
        this.allHeatSinks = 0;
        this.activeCoolingHeatsinks = 0;
        this.validIrradiators = 0;
        this.allIrradiators = 0;
        this.cellsHeatMult = 0.0;
        this.moderatorsHeatMult = 0.0;
        this.cellsEnergyMult = 0.0;
        this.moderatorsEnergyMult = 0.0;
        this.canAcceptFluids = false;
        this.speed = 0.001f;
        this.targetModerationLevel = 1.0;
        this.contentHandler = new SidedContentHandler(1, 1, 1 + this.activeCoolersTypes().size(), 1, new int[0]);
        this.contentHandler().setBlockEntity(this);
        this.contentHandler().fluidHandler.setGlobalMode(0, SlotModePair.SlotMode.PULL);
        this.contentHandler().fluidHandler.setGlobalMode(1, SlotModePair.SlotMode.PUSH);
        this.contentHandler().itemHandler.setGlobalMode(0, SlotModePair.SlotMode.PULL);
        this.contentHandler().itemHandler.setGlobalMode(1, SlotModePair.SlotMode.PUSH);
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(0))).setCapacity(10000);
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(1))).setCapacity(10000);
        this.contentHandler().setAllowedInputFluids(0, this::getAllowedCoolants);
        this.contentHandler().setAllowedInputFluids(1, this::getAllowedCoolantsOutput);
        for (String type : this.activeCoolersTypes()) {
            this.contentHandler().setAllowedInputFluids(2 + this.activeCoolersTypes().indexOf(type), () -> FissionReactorRegistration.heatsinks.get(type).getAllowedFluids());
            this.contentHandler().fluidHandler.setGlobalMode(2 + this.activeCoolersTypes().indexOf(type), SlotModePair.SlotMode.PULL);
        }
        this.contentHandler().setAllowedInputItems(this::getAllowedInputItems);
        this.energyStorage = this.createEnergy();
        this.energyStorage.setInputEnergyTier(0L).setOutputEnergyTier(this.getBaseGTEnergyTier()).setInputAmperage(0L).setOutputAmperage(16L);
        this.energy = LazyOptional.of(() -> this.energyStorage);
    }

    @Override
    public int getBaseGTEnergyTier() {
        return ((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.FISSION_REACTOR_TIER.get())).ordinal();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public List<ItemStack> getAllowedInputItems() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<ItemStack>();
            for (NcRecipe recipe : NcRecipeType.getAllRecipesFor(this.getName(), this.m_58904_())) {
                for (Ingredient ingredient : recipe.getItemIngredients()) {
                    this.allowedInputs.addAll(List.of(ingredient.m_43908_()));
                }
            }
        }
        return this.allowedInputs;
    }

    private List<String> activeCoolersTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (String name : FissionReactorRegistration.heatsinks.keySet()) {
            if (!name.contains("active") || name.contains("empty")) continue;
            types.add(name.replace("active_", ""));
        }
        return types;
    }

    protected List<FluidStack> getAllowedCoolantsOutput() {
        if (this.allowedCoolantOutputs == null) {
            this.allowedCoolantOutputs = new ArrayList<FluidStack>();
            for (FissionBoilingRecipe recipe : this.getBoilingRecipes()) {
                this.allowedCoolantOutputs.addAll(recipe.getOutputFluids(0));
            }
        }
        return this.allowedCoolantOutputs;
    }

    protected List<FluidStack> getAllowedCoolants() {
        if (!this.isSteamMode) {
            return List.of();
        }
        if (this.allowedCoolants == null) {
            this.allowedCoolants = new ArrayList<FluidStack>();
            for (FissionBoilingRecipe recipe : this.getBoilingRecipes()) {
                this.allowedCoolants.addAll(recipe.getInputFluids(0));
            }
        }
        return this.allowedCoolants;
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler().itemHandler;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(100000000, 0, 100000000){

            @Override
            protected void onEnergyChanged() {
                FissionControllerBE.this.m_6596_();
            }
        };
    }

    @Override
    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    public double getSteamRate() {
        return Math.max(0.0, this.steamRate);
    }

    public void boil() {
        this.steamPerTick = 0;
        this.boilingPenalty = 0.0;
        if (!this.isProcessing()) {
            return;
        }
        double cooling = this.coolingPerTick();
        if (this.getNetHeat() < 0.0) {
            cooling = this.heatPerTick;
        }
        double heatEff = cooling * (Double)FissionConfig.FISSION_CONFIG.BOILING_MULTIPLIER.get() / 100.0 * this.heatMultiplier;
        if (this.hasCoolant()) {
            FluidStack steam = this.boilingRecipe.getOutputFluids().get(0);
            FluidStack coolant = this.boilingRecipe.getInputFluids(0).get(0);
            double conversion = heatEff / this.boilingRecipe.conversionRate();
            FluidStack currentCoolant = this.contentHandler().fluidHandler.getFluidInSlot(0);
            FluidStack currentOutput = this.contentHandler().fluidHandler.getFluidInSlot(1);
            if (!steam.isFluidEqual(currentOutput) && !currentOutput.isEmpty()) {
                this.boilingPenalty = this.coolingPerTick();
                return;
            }
            double capacity = ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(1))).getCapacity() - currentOutput.getAmount();
            this.maxSteamOutput = (int)((double)steam.getAmount() * conversion);
            int ops = (int)(capacity / (double)steam.getAmount());
            capacity = ops * steam.getAmount();
            int canGetAmount = (int)Math.min((double)this.maxSteamOutput, capacity);
            ops = canGetAmount / steam.getAmount();
            ops = Math.min(currentCoolant.getAmount() / coolant.getAmount(), ops);
            this.steamPerTick = Math.max(ops * steam.getAmount(), 0);
            if (this.steamPerTick == 0) {
                this.heat += this.heatPerTick;
                this.boilingPenalty = this.coolingPerTick() * 0.75;
                return;
            }
            ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(0))).drain(ops * coolant.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            FluidStack out = steam.copy();
            out.setAmount(ops * steam.getAmount());
            ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(1))).fill(out, IFluidHandler.FluidAction.EXECUTE);
            this.changed = true;
            if ((double)ops < Math.floor(conversion)) {
                this.boilingPenalty = this.coolingPerTick() * (conversion / (double)ops) - this.coolingPerTick();
            }
        } else {
            this.boilingPenalty = this.coolingPerTick() * 0.75;
        }
    }

    public void toggleMode() {
        if (!((Boolean)FissionConfig.FISSION_CONFIG.BOILING_ENABLED.get()).booleanValue()) {
            this.isSteamMode = false;
            return;
        }
        this.toggleModeTimer = 200;
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new SolidFissionReactorPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    public <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.of(() -> FissionReactorDevice.createDevice(this)).cast();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.contentHandler().getItemCapability(side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.canAcceptFluid()) {
            return this.contentHandler().getFluidCapability(side);
        }
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && FissionControllerBE.isGTEUCapEnabled() && !this.isSteamMode && side == null) {
            return GTUtils.getGTEnergy(this, side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY && !this.isSteamMode && side == null) {
            if (!GTUtils.isOnlyGTCEUCapEnabled()) {
                return this.getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        if (ModUtil.isOC2Loaded() && cap == FissionReactorDevice.DEVICE_CAPABILITY) {
            return this.getOCDevice(cap, side);
        }
        if (ModUtil.isMekanismLoaded() && this.isSteamMode) {
            if (cap == Capabilities.GAS_HANDLER) {
                if (this.contentHandler().hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler().gasConverter(side));
                }
                return LazyOptional.empty();
            }
            if (cap == Capabilities.SLURRY_HANDLER) {
                if (this.contentHandler().hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler().getSlurryConverter(side));
                }
                return LazyOptional.empty();
            }
        }
        if (ModUtil.isCcLoaded() && cap == dan200.computercraft.shared.Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isCasingValid || !this.isInternalValid) {
            BlockOverlayHandler.reactors.remove(this);
            this.stopSound();
            return;
        }
        if (this.efficiency > 0.0) {
            if (!BlockOverlayHandler.reactors.contains(this)) {
                BlockOverlayHandler.reactors.add(this);
            }
            this.spawnParticles();
            this.playSound(NCSounds.FISSION_REACTOR, 0.2f);
        } else {
            this.stopSound();
        }
    }

    @Override
    public void tickServer() {
        this.heatMultiplier = 0.0;
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            this.irradiationHeat = 0;
            this.controllerEnabled = false;
            return;
        }
        this.changed = false;
        super.tickServer();
        this.boilingPenalty = 0.0;
        this.hopToggleMode();
        boolean wasFormed = this.getMultiblock().isFormed();
        boolean wasEnabled = this.controllerEnabled;
        boolean wasPowered = this.powered;
        this.handleValidation();
        this.controllerEnabled = this.hasRedstoneSignal() && this.getMultiblock().isFormed();
        boolean bl = this.controllerEnabled = !this.forceShutdown && this.controllerEnabled;
        if (this.controllerEnabled != wasEnabled && this.reactivityLevel > 10 && this.reactivityLevel < 99) {
            this.controllerEnabled = wasEnabled;
        }
        if (this.getMultiblock().isFormed()) {
            this.trackChanges(this.updateModerationLevel());
            this.trackChanges(this.contentHandler().tick());
            this.powered = this.controllerEnabled || this.reactivityLevel > 0 ? this.processReaction() : false;
            this.trackChanges(this.coolDown());
            this.handleMeltdown();
        } else if (this.isProcessing() && wasFormed) {
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), 10000 * this.fuelCellsCount, this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
        }
        this.changed = this.powered != wasPowered || this.changed;
        this.refreshCacheFlag = !this.getMultiblock().isFormed();
        boolean bl2 = this.canAcceptFluids = this.getMultiblock().coolantPerTick.size() > 0;
        if (this.refreshCacheFlag || this.changed || NuclearCraft.currentTick % 40L == 0L) {
            try {
                assert (this.f_58857_ != null);
                this.m_6596_();
                if (this.powered != wasPowered) {
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
                }
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)), 3);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.irradiationHeat = 0;
    }

    @Override
    public HashMap<String, String> getAnalyzeReport() {
        HashMap<String, String> report = new HashMap<String, String>();
        report.put("report.nc.1.reactor_all_moderators", String.valueOf(this.allModerators));
        report.put("report.nc.2.reactor_moderators", String.valueOf(this.moderatorsCount));
        report.put("report.nc.3.reactor_moderator_attachments", String.valueOf(this.moderatorAttachments));
        report.put("report.nc.4.reactor_all_heat_sinks", String.valueOf(this.allHeatSinks));
        report.put("report.nc.5.reactor_heat_sinks", String.valueOf(this.heatSinksCount));
        report.put("report.nc.6.active_cooling_heatsinks", String.valueOf(this.activeCoolingHeatsinks));
        report.put("report.nc.7.all_irradiators", String.valueOf(this.allIrradiators));
        report.put("report.nc.8.irradiators", String.valueOf(this.validIrradiators));
        report.put("report.nc.9.ports", String.valueOf(this.connectedPorts));
        report.put("report.nc.10.reactor_fuel_cells", String.valueOf(this.fuelCellsCount));
        report.put("report.nc.11.has_recipe", String.valueOf(this.recipeInfo().recipe != null));
        return report;
    }

    private void hopToggleMode() {
        if (!((Boolean)FissionConfig.FISSION_CONFIG.BOILING_ENABLED.get()).booleanValue()) {
            this.isSteamMode = false;
            return;
        }
        if (this.toggleModeTimer < 201) {
            --this.toggleModeTimer;
            this.changed = true;
            if (this.toggleModeTimer < 1) {
                this.toggleModeTimer = 2000;
                this.isSteamMode = !this.isSteamMode;
            }
        }
    }

    @Override
    public FissionReactorMultiblock getMultiblock() {
        if (this.m_58904_().m_5776_()) {
            NuclearCraft.debugLog("Trying to access multiblock from client");
            return null;
        }
        if (this.multiblock == null) {
            this.multiblock = new FissionReactorMultiblock(this);
        }
        return (FissionReactorMultiblock)this.multiblock;
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    private void handleMeltdown() {
        if (this.heat > this.getMaxHeat()) {
            BlockPos explosionPos = this.m_58899_().m_5484_(this.getFacing(), 2);
            ArrayList<Long> fuelCells = new ArrayList<Long>(this.getMultiblock().fuelCells);
            if ((Double)FissionConfig.FISSION_CONFIG.EXPLOSION_RADIUS.get() == 0.0) {
                this.m_58904_().m_254849_(null, (double)explosionPos.m_123341_(), (double)explosionPos.m_123342_(), (double)explosionPos.m_123343_(), 2.0f, Level.ExplosionInteraction.NONE);
            } else {
                this.m_58904_().m_254849_(null, (double)explosionPos.m_123341_(), (double)explosionPos.m_123342_(), (double)explosionPos.m_123343_(), ((Double)FissionConfig.FISSION_CONFIG.EXPLOSION_RADIUS.get()).floatValue(), Level.ExplosionInteraction.TNT);
                this.m_58904_().m_7731_(explosionPos, NCFluids.getBlock("corium"), 1);
                Iterator iterator = fuelCells.iterator();
                while (iterator.hasNext()) {
                    long packedPos = (Long)iterator.next();
                    BlockPos pos = BlockPos.m_122022_((long)packedPos);
                    this.m_58904_().m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2.0f, Level.ExplosionInteraction.TNT);
                    this.m_58904_().m_7731_(pos, NCFluids.getBlock("corium"), 1);
                }
            }
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), 100000 * this.fuelCellsCount, this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
            this.m_7651_();
        }
    }

    private void tickActiveHeatSinks() {
        double calculatedCooling = 0.0;
        for (String coolant : this.getMultiblock().coolantPerTick.keySet()) {
            int amount = this.getMultiblock().coolantPerTick.get(coolant);
            if (amount == 0) continue;
            if (!this.hasEnoughCoolant(coolant, amount)) {
                calculatedCooling -= this.getCoolingByCoolant(coolant, amount);
                continue;
            }
            if (!(this.heat > 0.0) && !this.isProcessing()) continue;
            this.drainCoolant(coolant, amount);
        }
        if (calculatedCooling != this.activeCooling) {
            this.activeCooling = calculatedCooling;
            this.m_6596_();
        }
    }

    private double getCoolingByCoolant(String coolant, int amount) {
        if (!FissionReactorRegistration.heatsinks.containsKey("active_" + coolant)) {
            return 0.0;
        }
        int mbPerTick = (Integer)FissionConfig.FISSION_CONFIG.ACTIVE_HEATSINK_COOLANT_PER_TICK.get();
        FissionReactorRegistration.heatsinks.get("active_" + coolant);
        return (double)amount / (double)mbPerTick * FissionReactorRegistration.heatsinks.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"active_\u0001"}, (String)coolant)).heat;
    }

    private boolean coolDown() {
        this.tickActiveHeatSinks();
        double wasHeat = this.heat;
        this.heat -= this.coolingPerTick();
        if (this.isSteamMode) {
            this.boil();
        }
        this.heat = Math.max(0.0, this.heat);
        return wasHeat != this.heat;
    }

    private boolean processReaction() {
        if (this.recipeInfo().recipe != null && this.recipeInfo().isCompleted() && this.contentHandler().itemHandler.getStackInSlot(0).equals(ItemStack.f_41583_)) {
            this.recipeInfo().clear();
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (this.hasRecipe()) {
            return this.process();
        }
        return false;
    }

    private void spawnParticles() {
        if (!this.isCasingValid || !this.isInternalValid || this.efficiency <= 0.0) {
            return;
        }
        if (NuclearCraft.currentTick % (long)(this.f_58857_.f_46441_.m_188503_(5) + 1) != 0L) {
            return;
        }
        BlockPos topRightInner = this.topRight.m_5484_(this.getFacing(), -1).m_7495_().m_5484_(this.getFacing().m_122427_(), 1);
        BlockPos bottomLeftInner = this.bottomLeft.m_5484_(this.getFacing(), 1).m_7494_().m_5484_(this.getFacing().m_122428_(), 1);
        int minX = Math.min(topRightInner.m_123341_(), bottomLeftInner.m_123341_());
        int minY = Math.min(topRightInner.m_123342_(), bottomLeftInner.m_123342_());
        int minZ = Math.min(topRightInner.m_123343_(), bottomLeftInner.m_123343_());
        int maxX = Math.max(topRightInner.m_123341_(), bottomLeftInner.m_123341_());
        int maxY = Math.max(topRightInner.m_123342_(), bottomLeftInner.m_123342_());
        int maxZ = Math.max(topRightInner.m_123343_(), bottomLeftInner.m_123343_());
        for (BlockPos blockPos : BlockPos.m_235641_((RandomSource)this.f_58857_.f_46441_, (int)(this.width + this.height + this.depth), (int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            this.f_58857_.m_6493_((ParticleOptions)NcParticleTypes.RADIATION.get(), true, (double)((float)blockPos.m_123341_() + this.f_58857_.f_46441_.m_188501_()), (double)((float)blockPos.m_123342_() + this.f_58857_.f_46441_.m_188501_()), (double)((float)blockPos.m_123343_() + this.f_58857_.f_46441_.m_188501_()), 0.0, (double)-0.05f, 0.0);
        }
    }

    private boolean process() {
        this.reactivityLevel += this.controllerEnabled ? 1 : -1;
        this.reactivityLevel = Math.max(0, Math.min(this.reactivityLevel, 100));
        if (this.recipeInfo().be == null) {
            this.recipeInfo().be = this;
        }
        double processAmount = (double)this.fuelCellsCount * (this.heatMultiplier() + this.collectedHeatMultiplier() - 1.0) * (double)this.reactivityLevel / 100.0;
        this.recipeInfo().process(processAmount);
        if (this.recipeInfo().radiation != 1.0) {
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), this.recipeInfo().radiation / 10000.0, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        }
        if (!this.recipeInfo().isCompleted()) {
            if (!this.isSteamMode) {
                int energyGenerated = this.calculateEnergy();
                this.energyStorage.addEnergy(energyGenerated);
            }
            double heatGenerated = this.calculateHeat();
            this.heat += heatGenerated;
        }
        this.handleRecipeOutput();
        this.efficiency = this.calculateEfficiency();
        return true;
    }

    private void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo().isCompleted()) {
            if (this.recipe == null) {
                this.recipe = this.recipeInfo().recipe();
            }
            if (this.recipe.handleOutputs(this.contentHandler)) {
                this.updateRecipe();
            } else {
                this.recipeInfo().stuck = true;
            }
            this.m_6596_();
        }
    }

    public double heatMultiplier() {
        if (this.heatMultiplier == 0.0) {
            double h = this.heatPerTick();
            double c = Math.max(1.0, this.coolingPerTick());
            this.heatMultiplier = Math.log10(h / c) / (1.0 + Math.exp(h / c * (Double)FissionConfig.FISSION_CONFIG.HEAT_MULTIPLIER.get())) + 1.0;
            this.heatMultiplier = (double)Math.round(this.heatMultiplier * 100.0) / 100.0;
        }
        return this.heatMultiplier;
    }

    public double collectedHeatMultiplier() {
        return Math.min((Double)FissionConfig.FISSION_CONFIG.HEAT_MULTIPLIER_CAP.get(), Math.pow((this.heat + this.getMaxHeat() / 8.0) / this.getMaxHeat(), 5.0) + 0.9999694824);
    }

    public double coolingPerTick() {
        return this.heatSinksCooling() + this.environmentCooling() - this.boilingPenalty;
    }

    public double environmentCooling() {
        if (this.envCooling == 0.0) {
            this.envCooling = 1.0 / Math.max((double)((Biome)this.m_58904_().m_204166_(this.m_58899_()).get()).m_47554_(), 0.01);
        }
        return this.envCooling;
    }

    public double heatSinksCooling() {
        this.heatSinkCooling = this.getMultiblock().countCooling(this.refreshCacheFlag);
        return this.heatSinkCooling + this.activeCooling;
    }

    public double heatPerTick() {
        this.heatPerTick = this.recipeInfo().heat * (this.cellsHeatMult + this.moderatorsHeat()) + (double)this.irradiationHeat;
        return this.heatPerTick;
    }

    private double calculateHeat() {
        return this.heatPerTick() * Math.max(0.5, (double)this.reactivityLevel / 100.0);
    }

    private int calculateEnergy() {
        this.energyPerTick = (int)(this.recipeInfo().energy * (this.cellsEnergyMult + this.moderatorsFE()) * (this.heatMultiplier() + this.collectedHeatMultiplier() - 1.0) * (Double)FissionConfig.FISSION_CONFIG.FE_GENERATION_MULTIPLIER.get() / 10.0 * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get() * (double)this.reactivityLevel / 100.0);
        return this.energyPerTick;
    }

    public double moderatorsHeat() {
        return Math.max(0.1, this.getModerationLevel()) * this.moderatorsHeatMult;
    }

    public double moderatorsFE() {
        return this.getModerationLevel() * this.moderatorsEnergyMult;
    }

    @Override
    public Recipe getRecipe() {
        if (this.contentHandler().itemHandler.getStackInSlot(0).equals(ItemStack.f_41583_)) {
            return null;
        }
        return (Recipe)super.getRecipe();
    }

    protected void updateRecipe() {
        if (this.recipe != null) {
            if (this.recipe.test(this.contentHandler())) {
                this.recipeInfo().ticksProcessed = 0.0;
                if (this.recipeInfo().consumeInputs(this.contentHandler())) {
                    return;
                }
                this.recipe = null;
                this.recipeInfo().clear();
            } else {
                this.recipeInfo().clear();
            }
        }
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo().setRecipe(this.recipe);
            this.recipeInfo().ticks = ((Recipe)this.recipeInfo().recipe()).getDepletionTime();
            this.recipeInfo().energy = this.recipeInfo().recipe().getEnergy();
            this.recipeInfo().heat = ((Recipe)this.recipeInfo().recipe()).getHeat();
            this.recipeInfo().radiation = this.recipeInfo().recipe().getRadiation();
            this.recipeInfo().be = this;
            if (!this.recipe.consumeInputs(this.contentHandler, 1)) {
                this.recipe = null;
                this.recipeInfo().clear();
            }
        } else {
            this.recipeInfo().clear();
        }
    }

    public boolean recipeIsStuck() {
        return this.recipeInfo().isStuck();
    }

    public boolean hasRecipe() {
        return this.recipeInfo().recipe() != null;
    }

    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return this.facing;
    }

    public double getDepletionProgress() {
        return this.recipeInfo().getProgress();
    }

    public double getMaxHeat() {
        return this.maxHeat;
    }

    public double boilingEfficiency() {
        double mult = this.fuelCellsCount;
        if (this.fuelCellMultiplier > this.fuelCellsCount) {
            mult = (double)this.fuelCellMultiplier / (double)this.fuelCellsCount;
        }
        return this.heatPerTick / (this.recipeInfo.heat * mult / 100.0);
    }

    public double calculateEfficiency() {
        double mult = this.fuelCellsCount;
        if (this.extraFuelCells > this.fuelCellsCount) {
            mult = (double)this.extraFuelCells / (double)this.fuelCellsCount;
        }
        return (double)this.energyPerTick / (this.recipeInfo.energy * mult / 100.0);
    }

    public double getNetHeat() {
        return this.heatPerTick - this.heatSinksCooling();
    }

    public boolean hasRedstoneSignal() {
        if (NuclearCraft.currentTick % 10L == 0L) {
            this.hasRedstoneSignal = this.m_58904_().m_276867_(this.m_58899_());
        }
        return this.enabledByController || this.hasRedstoneSignal;
    }

    public Object[] getFuel() {
        return this.contentHandler().itemHandler.getSlotContent(0);
    }

    public void voidFuel() {
        this.contentHandler().voidSlot(0);
        this.contentHandler().itemHandler.holdedInputs.clear();
    }

    public void forceShutdown() {
        this.forceShutdown = true;
    }

    public void disableForceShutdown() {
        this.forceShutdown = false;
    }

    public ItemStack getCurrentFuel() {
        if (!this.hasRecipe()) {
            return ItemStack.f_41583_;
        }
        return this.recipeInfo().recipe().getFirstItemStackIngredient(0);
    }

    public List<FissionBoilingRecipe> getBoilingRecipes() {
        if (this.coolantRecipes == null) {
            this.coolantRecipes = NcRecipeType.getAllRecipesFor("fission_boiling", this.m_58904_());
        }
        return this.coolantRecipes;
    }

    public boolean hasCoolant() {
        FluidStack coolant = this.contentHandler().fluidHandler.getFluidInSlot(0);
        if (coolant.isEmpty()) {
            this.boilingRecipe = null;
            return false;
        }
        if (this.boilingRecipe == null) {
            for (FissionBoilingRecipe recipe : this.getBoilingRecipes()) {
                if (!recipe.getInputFluids()[0].test(coolant)) continue;
                this.boilingRecipe = recipe;
                return true;
            }
        } else if (!this.boilingRecipe.getInputFluids()[0].test(coolant)) {
            this.boilingRecipe = null;
            return false;
        }
        return this.boilingRecipe instanceof FissionBoilingRecipe;
    }

    public boolean isProcessing() {
        return this.hasRecipe() && this.recipeInfo().ticksProcessed > 0.0 && !this.recipeInfo().isCompleted();
    }

    public void addIrradiationHeat() {
        this.irradiationHeat += this.irradiationLines * 15;
    }

    public void enableReactor() {
        this.toggleReactor(true);
    }

    public void toggleReactor(boolean mode) {
        this.controllerEnabled = mode || this.getRedstoneSignal() > 0;
        this.enabledByController = mode;
    }

    @Override
    public int getRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_277086_(this.f_58858_);
    }

    public void adjustModerator(int redstoneSignal) {
        BigDecimal bd = BigDecimal.valueOf((double)redstoneSignal / 15.0);
        bd = bd.setScale(1, RoundingMode.HALF_UP);
        this.targetModerationLevel = bd.doubleValue();
    }

    public boolean updateModerationLevel() {
        if (Math.abs(this.moderationLevel - this.targetModerationLevel) > 0.005) {
            this.moderationLevel = this.moderationLevel < this.targetModerationLevel ? (this.moderationLevel += 0.0025) : (this.moderationLevel -= 0.0025);
            return true;
        }
        return false;
    }

    public double getModerationLevel() {
        if (this.moderatorsCount == 0) {
            return 1.0;
        }
        return (double)Math.round(this.moderationLevel * 100.0) / 100.0;
    }

    public void adjustModerationLevel(int level) {
        String formatted = String.format(Locale.US, "%.2f", (double)Math.max(1, level) / 100.0);
        this.targetModerationLevel = Double.parseDouble(formatted);
    }

    public boolean canAcceptFluid() {
        return this.isSteamMode || this.canAcceptFluids;
    }

    public boolean hasEnoughCoolant(String coolant, int amount) {
        for (int i = 2; i < this.contentHandler().fluidHandler.tanks.size(); ++i) {
            FluidStack stack = ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(i))).getFluid();
            if (!ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).m_135815_().equals(coolant) || stack.getAmount() < amount) continue;
            return true;
        }
        return false;
    }

    public void drainCoolant(String coolant, int amount) {
        for (int i = 2; i < this.contentHandler().fluidHandler.tanks.size(); ++i) {
            FluidStack stack = ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(i))).getFluid();
            if (!ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).m_135815_().equals(coolant) || stack.getAmount() < amount) continue;
            ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(i))).drain(amount, IFluidHandler.FluidAction.EXECUTE);
            return;
        }
    }

    public AABB getGlowAABB() {
        if (this.bottomLeft.equals((Object)BlockPos.f_121853_) || this.topRight.equals((Object)BlockPos.f_121853_)) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        Vec3 topRightInner = new Vec3((double)this.topRight.m_123341_(), (double)this.topRight.m_123342_(), (double)this.topRight.m_123343_());
        topRightInner = topRightInner.m_231075_(this.getFacing(), 0.05).m_231075_(Direction.UP, 0.05).m_231075_(this.getFacing().m_122427_(), -0.05);
        Vec3 bottomLeftInner = new Vec3((double)this.bottomLeft.m_123341_(), (double)this.bottomLeft.m_123342_(), (double)this.bottomLeft.m_123343_());
        bottomLeftInner = bottomLeftInner.m_231075_(this.getFacing(), 0.95).m_231075_(Direction.UP, 0.95).m_231075_(this.getFacing().m_122428_(), 0.95);
        return new AABB(bottomLeftInner, topRightInner);
    }

    public void refresh() {
        double multiplier = Math.max(1.0, (double)Math.round(Math.log(this.height * this.width * this.depth) * 10.0) / 10.0 - 1.0);
        this.maxHeat = (Double)FissionConfig.FISSION_CONFIG.HEAT_CAPACITY.get() * multiplier;
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(0))).setCapacity((int)(Math.pow(multiplier, 2.0) * 1000000.0));
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(1))).setCapacity((int)(Math.pow(multiplier, 2.0) * 1000000.0));
        this.m_6596_();
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(false)), 3);
    }

    public static class FissionBoilingRecipe
    extends NcRecipe {
        protected double conversionRate;

        public FissionBoilingRecipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double conversionRate, double powerModifier, double radiation, double rar) {
            super(id, input, output, inputFluids, outputFluids, conversionRate, powerModifier, radiation, rar);
            this.conversionRate = conversionRate;
        }

        @Override
        @NotNull
        public String m_6076_() {
            return "fission_boiling";
        }

        @Override
        public String getCodeId() {
            return "fission_boiling";
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)FissionReactorRegistration.FISSION_BLOCKS.get(FissionControllerBE.NAME).get());
        }

        public double conversionRate() {
            return Math.max(this.conversionRate, 1.0);
        }
    }

    public static class Recipe
    extends NcRecipe {
        protected ItemFuel fuelItem;

        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, timeModifier, powerModifier, heatModifier, rarity);
            GlobalVars.CATALYSTS.put(this.codeId, List.of(this.m_8042_()));
        }

        @Override
        public String getCodeId() {
            return FissionControllerBE.NAME;
        }

        public ItemFuel getFuelItem() {
            if (this.fuelItem == null) {
                Item item = this.getFirstItemStackIngredient(0).m_41720_();
                if (!(item instanceof ItemFuel) && !item.equals(Items.f_41852_)) {
                    this.fuelItem = new ItemFuel(FissionFuel.ITEM_PROPERTIES, item.toString(), "", "");
                    return this.fuelItem;
                }
                Item item1 = this.getFirstItemStackIngredient(0).m_41720_();
                if (item1 instanceof ItemFuel) {
                    this.fuelItem = (ItemFuel)item1;
                }
            }
            if (this.fuelItem.def == null) {
                this.fuelItem.initDefinition();
            }
            return this.fuelItem;
        }

        @Override
        @NotNull
        public String m_6076_() {
            return ((Block)FissionReactorRegistration.FISSION_BLOCKS.get(this.codeId).get()).m_49954_().getString();
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)FissionReactorRegistration.FISSION_BLOCKS.get(this.codeId).get());
        }

        public int getDepletionTime() {
            if (this.getFuelItem() == null) {
                return 0;
            }
            return (int)((double)(this.getFuelItem().depletion() * 20) * this.timeModifier);
        }

        @Override
        public double getEnergy() {
            if (this.getFuelItem() == null) {
                return 0.0;
            }
            return this.getFuelItem().forge_energy;
        }

        public double getHeat() {
            if (this.getFuelItem() == null) {
                return 0.0;
            }
            return this.getFuelItem().heat;
        }

        @Override
        public double getRadiation() {
            return ItemRadiation.byItem(this.getFuelItem()) / 20.0;
        }
    }
}

