/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.fusion.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import dan200.computercraft.shared.Capabilities;
import igentuman.api.nc.multiblock.MultiblockAttachable;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.fusion.entity.FusionCoreBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.compat.oc2.FusionReactorDevice;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.fusion.FusionReactorMultiblock;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class FusionCoreProxyBE
extends NuclearCraftBE
implements MultiblockAttachable<FusionReactorMultiblock, FusionCoreBE> {
    @NBTField
    protected BlockPos corePos;
    protected FusionCoreBE core;
    protected FusionReactorMultiblock multiblock;
    protected byte wasSignal = 0;

    public FusionCoreProxyBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FusionReactorRegistration.FUSION_CORE_PROXY_BE.get(), pPos, pBlockState);
    }

    @Override
    public void setMultiblock(FusionReactorMultiblock multiblock) {
        this.multiblock = multiblock;
    }

    @Override
    public FusionReactorMultiblock getMultiblock() {
        return this.multiblock;
    }

    public void setController(FusionCoreBE controllerBE) {
        this.core = controllerBE;
        this.corePos = controllerBE.m_58899_();
    }

    protected void validateCore() {
        if (this.core != null) {
            if (!this.f_58857_.m_46749_(this.core.m_58899_())) {
                return;
            }
            this.core = (FusionCoreBE)this.f_58857_.getExistingBlockEntity(this.core.m_58899_());
            if (this.core == null) {
                this.core = (FusionCoreBE)this.f_58857_.m_7702_(this.core.m_58899_());
            }
            this.corePos = this.core.m_58899_();
        } else {
            if (this.corePos == null) {
                return;
            }
            this.core = (FusionCoreBE)this.f_58857_.getExistingBlockEntity(this.corePos);
            if (this.core == null) {
                this.core = (FusionCoreBE)this.f_58857_.m_7702_(this.corePos);
            }
        }
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.currentTick % 20L == 0L) {
            this.validateCore();
        }
        if (!(this.core instanceof FusionCoreBE)) {
            this.f_58857_.m_7471_(this.f_58858_, false);
            return;
        }
        if (NuclearCraft.currentTick % 5L == 0L && !this.core.hasRecipe()) {
            return;
        }
        if (this.wasSignal != this.core.analogSignal) {
            this.wasSignal = this.core.analogSignal;
            MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            this.m_6596_();
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    @Override
    public FusionCoreBE controller() {
        if (NuclearCraft.instance.isNcBeStopped || !this.m_58904_().m_5776_() && Objects.requireNonNull(this.m_58904_()).m_7654_() != null && !this.m_58904_().m_7654_().m_130010_()) {
            return null;
        }
        if (this.m_58904_().m_5776_() && this.corePos != null) {
            return (FusionCoreBE)this.m_58904_().getExistingBlockEntity(this.corePos);
        }
        if (this.core == null && this.corePos != null) {
            this.core = (FusionCoreBE)this.m_58904_().getExistingBlockEntity(this.corePos);
        }
        return this.core;
    }

    @Override
    public void m_7651_() {
        if (this.canInvalidateCache() && !this.m_58904_().m_5776_() && this.controller() != null) {
            this.controller().invalidateCache();
        }
        super.m_7651_();
    }

    public void setCore(FusionCoreBE core) {
        FusionCoreBE wasCore = this.core;
        this.core = core;
        this.corePos = core.m_58899_();
        if (wasCore != core) {
            MultiblockHandler.get((ResourceKey<Level>)this.m_58904_().m_46472_()).addIgnoreToUpdate(this.m_58899_());
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void destroyCore() {
        if (this.corePos != null) {
            BlockState st = this.f_58857_.m_8055_(this.corePos);
            if (st.equals(Blocks.f_50016_.m_49966_())) {
                return;
            }
            ItemStack core = new ItemStack((ItemLike)st.m_60734_().m_5456_());
            core.m_41784_().m_128405_("upgrade_tier", this.getCoreBE().upgrade_tier);
            this.f_58857_.m_7471_(this.corePos, false);
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.corePos, (ItemStack)core);
        }
    }

    public FusionCoreBE getCoreBE() {
        return this.core;
    }

    public BlockPos getCorePos() {
        return this.corePos;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.controller() == null) {
            return super.getCapability(cap, side);
        }
        if (side == null || side.m_122434_().m_122479_()) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.controller().getCapability(cap, side);
        }
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && FusionCoreProxyBE.isGTEUCapEnabled()) {
            return GTUtils.getGTEnergy(this.controller(), side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (ModUtil.isGtLoaded() && GTUtils.isOnlyGTCEUCapEnabled()) {
                return LazyOptional.empty();
            }
            return this.controller().getCapability(cap, side);
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.controller().getPeripheral(cap, side);
        }
        if (ModUtil.isOC2Loaded() && cap == FusionReactorDevice.DEVICE_CAPABILITY) {
            return this.controller().getOCDevice(cap, side);
        }
        if (ModUtil.isMekanismLoaded()) {
            if (cap == mekanism.common.capabilities.Capabilities.GAS_HANDLER) {
                if (this.controller().contentHandler().hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.controller().contentHandler().gasConverter(side));
                }
                return LazyOptional.empty();
            }
            if (cap == mekanism.common.capabilities.Capabilities.SLURRY_HANDLER) {
                if (this.controller().contentHandler().hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.controller().contentHandler().getSlurryConverter(side));
                }
                return LazyOptional.empty();
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    public void sendOutEnergy() {
        int required = this.getCoreBE().rfAmplifiersPower + this.getCoreBE().magnetsPower;
        for (Direction side : List.of(Direction.UP, Direction.DOWN)) {
            BlockEntity be;
            if (this.getCoreBE().energyStorage().getEnergyStored() <= required || !((be = this.m_58904_().getExistingBlockEntity(this.m_58899_().m_121945_(side))) instanceof BlockEntity) || be instanceof FusionCoreProxyBE || be instanceof FusionCoreBE) continue;
            int wasEnergy = this.getCoreBE().energyStorage().getEnergyStored();
            if (ModUtil.isGtLoaded() && FusionCoreProxyBE.isGTEUCapEnabled()) {
                GTUtils.transferEU(this.controller(), be, this.controller().energyStorage(), side);
            }
            if (ModUtil.isGtLoaded() && GTUtils.isOnlyGTCEUCapEnabled()) {
                return;
            }
            IEnergyStorage r = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, side.m_122424_()).orElse(null);
            if (r == null || this.getCoreBE() == null) continue;
            int extracted = wasEnergy - this.getCoreBE().energyStorage().getEnergyStored();
            if (extracted >= this.controller().energyStorage().getMaxExtract()) {
                return;
            }
            int canExtract = Math.min(this.controller().energyStorage().getMaxExtract() - extracted, this.controller().energyStorage().getEnergyStored());
            if (!r.canReceive()) continue;
            int available = this.getCoreBE().energyStorage().getEnergyStored() - required - canExtract;
            if (available < 0) {
                return;
            }
            int recieved = 0;
            try {
                recieved = r.receiveEnergy(Math.min(available, this.getCoreBE().energyStorage().getMaxExtract()), false);
            }
            catch (Exception e) {
                NuclearCraft.debugLog("Entity failed to receive FE at: " + be.m_58899_().m_123344_());
                return;
            }
            this.getCoreBE().energyStorage().consumeEnergy(recieved);
            this.controller().m_6596_();
        }
    }

    public void forceTickServer(FusionCoreBE core) {
        this.core = core;
        core.inputRedstoneSignal = Math.max(this.m_58904_().m_277086_(this.m_58899_()), core.inputRedstoneSignal);
        core.rfAmplificationRatio = (int)((double)core.inputRedstoneSignal / 0.15);
    }

    public void toggleRedstoneMode() {
        this.getCoreBE().toggleRedstoneMode();
    }

    public int getAnalogSignal() {
        return this.getCoreBE() == null ? 0 : (int)this.getCoreBE().analogSignal;
    }
}

