/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.kugelblitz.entity;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.kugelblitz.BlackHoleBlock;
import igentuman.nc.client.renderer.DistortShader;
import igentuman.nc.compat.kubejs.NCKubeJsEvents;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlackHoleBE
extends NuclearCraftBE {
    public static String NAME = "black_hole";
    public float scale = 0.3f;
    public static long MIN_MASS = 100000000L;
    public static long MAX_MASS = 10000000000L;
    @NBTField
    public boolean isInitialized = false;
    @NBTField
    public int initDelay = 0;
    public int spawnDelay = 0;
    private boolean hasEntities = false;

    public BlackHoleBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)KugelblitzRegistration.KUGELBLITZ_BE.get(NAME).get(), pPos, pBlockState);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
    }

    @Override
    public void tickClient() {
        float z;
        float y;
        float x;
        int i;
        if (this.m_58901_()) {
            DistortShader.blackhole.remove(this.m_58899_());
        }
        if (!DistortShader.blackhole.contains(this.m_58899_())) {
            DistortShader.blackhole.add(this.m_58899_());
        }
        this.scale = 0.3f + (float)this.spawnDelay / 100.0f;
        if (this.spawnDelay < 1) {
            this.playSound(NCSounds.BLACKHOLE_IDLE, 0.7f);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        if (this.m_58904_().f_46441_.m_188499_()) {
            for (i = 0; i < this.m_58904_().f_46441_.m_188503_(3); ++i) {
                x = (float)this.m_58899_().m_123341_() + 0.5f + this.randomDistance();
                y = (float)this.m_58899_().m_123342_() + 0.5f + this.randomDistance();
                z = (float)this.m_58899_().m_123343_() + 0.5f + this.randomDistance();
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
            }
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.spawnDelay = 18;
            this.m_58904_().m_7785_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)NCSounds.BLACKHOLE_SPAWN.get(), SoundSource.BLOCKS, 0.9f, 1.0f, false);
            for (i = 0; i < 80; ++i) {
                x = (float)this.m_58899_().m_123341_() + 0.5f + this.randomDistance();
                y = (float)this.m_58899_().m_123342_() + 0.5f + this.randomDistance();
                z = (float)this.m_58899_().m_123343_() + 0.5f + this.randomDistance();
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
            }
        }
    }

    private float randomDistance() {
        return this.f_58857_.f_46441_.m_188501_() + (float)this.f_58857_.f_46441_.m_188503_(8) - 4.0f;
    }

    @Override
    public void tickServer() {
        if (this.m_58901_()) {
            return;
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.m_6596_();
            this.initDelay = 5;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlackHoleBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)BlackHoleBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 1);
        }
        int wasDelay = this.initDelay;
        if (this.initDelay > 0) {
            --this.initDelay;
            if (this.initDelay == 1) {
                this.m_6596_();
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlackHoleBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)BlackHoleBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 1);
            }
        }
        if (wasDelay != this.initDelay) {
            this.m_6596_();
        }
        this.handleClosestEntities();
        this.evaporateClosestBlocks();
        this.evaporateIfNotInsideChamber();
    }

    private void evaporateIfNotInsideChamber() {
        for (Direction dir : Direction.values()) {
            BlockPos pos = this.f_58858_.m_5484_(dir, 5);
            BlockState state = this.f_58857_.m_8055_(pos);
            if (state.m_60713_((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("photon_concentrator").get())) continue;
            this.evaporate();
            return;
        }
    }

    private void evaporateClosestBlocks() {
        if ((NuclearCraft.currentTick & 5L) == 0L) {
            for (Direction direction : Direction.values()) {
                if (this.f_58857_.m_8055_(this.f_58858_.m_121945_(direction)).m_60795_()) continue;
                this.f_58857_.m_7731_(this.f_58858_.m_121945_(direction), Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    private void handleClosestEntities() {
        double centerZ;
        double centerY;
        if (!this.hasEntities && NuclearCraft.currentTick % 10L != 0L) {
            return;
        }
        double radius = 5.0;
        double consumeRadius = 1.1;
        double centerX = (double)this.f_58858_.m_123341_() + 0.5;
        AABB boundingBox = new AABB(centerX - radius, (centerY = (double)this.f_58858_.m_123342_() + 0.5) - radius, (centerZ = (double)this.f_58858_.m_123343_() + 0.5) - radius, centerX + radius, centerY + radius, centerZ + radius);
        List entities = this.f_58857_.m_45976_(Entity.class, boundingBox);
        this.hasEntities = !entities.isEmpty();
        for (Entity entity : entities) {
            double dz;
            double dy;
            double dx = centerX - entity.m_20185_();
            double distance = Math.sqrt(dx * dx + (dy = centerY - entity.m_20186_()) * dy + (dz = centerZ - entity.m_20189_()) * dz);
            if (distance < 1.1) {
                this.consumeEntity(entity);
                continue;
            }
            double factor = 1.0 / distance;
            dx *= factor;
            dy *= factor;
            dz *= factor;
            double pullStrength = Math.min(3.0, 0.8 * (1.0 - Math.pow(distance / radius, 2.0)));
            if (entity instanceof ItemEntity) {
                pullStrength *= 1.5;
            }
            entity.m_20334_(entity.m_20184_().f_82479_ + dx * pullStrength, entity.m_20184_().f_82480_ + dy * pullStrength, entity.m_20184_().f_82481_ + dz * pullStrength);
            double maxSpeed = 1.0;
            double currentSpeed = entity.m_20184_().m_82553_();
            if (currentSpeed > maxSpeed) {
                entity.m_20256_(entity.m_20184_().m_82490_(maxSpeed / currentSpeed));
            }
            if (!(distance < consumeRadius)) continue;
            this.consumeEntity(entity);
        }
    }

    private void consumeEntity(Entity entity) {
        if (entity instanceof ItemEntity) {
            entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        } else if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof ServerPlayer) {
                PlayerEnterBlackholeEvent event = new PlayerEnterBlackholeEvent((ServerPlayer)livingEntity, this.m_58899_(), this.m_58904_());
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (ModUtil.isKubeJsLoaded()) {
                    NCKubeJsEvents.onPlayerEnterBlackhole(event);
                }
                if (event.isCanceled()) {
                    return;
                }
                entity.m_6074_();
            } else {
                entity.m_6074_();
            }
        }
    }

    public float getBlackholeScale() {
        return this.scale;
    }

    public void meltdown() {
        this.m_58904_().m_254849_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 10.0f, Level.ExplosionInteraction.TNT);
        this.m_7651_();
        this.m_58904_().m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
    }

    public void evaporate() {
        this.m_7651_();
        this.m_58904_().m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
    }

    public class PlayerEnterBlackholeEvent
    extends Event {
        private final ServerPlayer player;
        private final BlockPos blackholePos;
        private final Level level;

        public boolean isCancelable() {
            return true;
        }

        public ServerPlayer getPlayer() {
            return this.player;
        }

        public BlockPos getBlackholePos() {
            return this.blackholePos;
        }

        public Level getLevel() {
            return this.level;
        }

        public PlayerEnterBlackholeEvent(ServerPlayer player, BlockPos blackholePos, Level level) {
            this.player = player;
            this.blackholePos = blackholePos;
            this.level = level;
        }
    }
}

