/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.kugelblitz.entity;

import igentuman.bfr.common.tile.fusion.TileEntityLaserFocusMatrix;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.kugelblitz.entity.EXPLProxyBE;
import igentuman.nc.block.kugelblitz.entity.PhotonConcentratorBE;
import igentuman.nc.client.particle.FusionBeamParticleData;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.KugelblitzConfig;
import igentuman.nc.multiblock.kugelblitz.KugelblitzMultiblock;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import mekanism.api.math.FloatingLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EXPLBE
extends NuclearCraftBE {
    @NBTField
    public int inputRedstoneSignal = 0;
    @NBTField
    public boolean activated = false;
    @NBTField
    public int pulseTime = 0;
    @NBTField
    public long aggregatedEnergy = 0L;
    public boolean activatedByOther = false;
    KugelblitzMultiblock chamber = null;
    protected final LazyOptional<IEnergyStorage> energy;
    public final CustomEnergyStorage energyStorage = this.createEnergy();
    private EXPLProxyBE[] proxyBES;
    private boolean energyTransfered = false;
    private boolean allLasersBurst = false;

    public EXPLBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)KugelblitzRegistration.EXPL_BE.get(), pPos, pBlockState);
        this.energyStorage.setInputEnergyTier(((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.KUGELBLITZ_ENERGY_TIER.get())).ordinal());
        this.energyStorage.setOutputEnergyTier(((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.KUGELBLITZ_ENERGY_TIER.get())).ordinal());
        this.energy = LazyOptional.of(() -> this.energyStorage);
    }

    public EXPLBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        this(pPos, pBlockState);
    }

    protected void sendBeamData(FusionBeamParticleData data, BlockPos from) {
        Object object;
        Vec3 vec = Vec3.m_82512_((Vec3i)from);
        if (!this.m_58904_().m_5776_() && (object = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)object;
            for (ServerPlayer player : serverWorld.m_6907_()) {
                serverWorld.m_8624_(player, (ParticleOptions)data, true, vec.f_82479_, vec.f_82480_, vec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void renderBeam() {
        this.sendBeamData(new FusionBeamParticleData(this.getFacing(), this.getActualLaserDistance() + 1, (float)((double)this.aggregatedEnergy / (double)((Long)KugelblitzConfig.KUGELBLITZ_CONFIG.EXPL_CHARGE.get()).longValue()) * 0.5f), this.m_58899_().m_121945_(this.getFacing()));
    }

    private Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
    }

    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(2048000000, 10000000, 0, true){

            @Override
            protected void onEnergyChanged() {
                EXPLBE.this.m_6596_();
            }
        };
    }

    protected EXPLProxyBE[] getProxies() {
        if (this.proxyBES == null) {
            Direction facing = this.getFacing();
            int minX = -1;
            int maxX = 0;
            int minY = -1;
            int minZ = 2;
            int maxY = 4;
            int maxZ = 2;
            switch (facing) {
                case UP: {
                    minX = -1;
                    minY = 0;
                    minZ = -1;
                    maxX = 2;
                    maxY = 4;
                    maxZ = 2;
                    break;
                }
                case DOWN: {
                    minX = -1;
                    minY = -3;
                    minZ = -1;
                    maxX = 2;
                    maxY = 1;
                    maxZ = 2;
                    break;
                }
                case NORTH: {
                    minX = -1;
                    minY = -1;
                    minZ = -3;
                    maxX = 2;
                    maxY = 2;
                    maxZ = 1;
                    break;
                }
                case SOUTH: {
                    minX = -1;
                    minY = -1;
                    minZ = 0;
                    maxX = 2;
                    maxY = 2;
                    maxZ = 4;
                    break;
                }
                case WEST: {
                    minX = -3;
                    minY = -1;
                    minZ = -1;
                    maxX = 1;
                    maxY = 2;
                    maxZ = 2;
                    break;
                }
                case EAST: {
                    minX = 0;
                    minY = -1;
                    minZ = -1;
                    maxX = 4;
                    maxY = 2;
                    maxZ = 2;
                }
            }
            this.proxyBES = new EXPLProxyBE[35];
            int i = 0;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    for (int y = minY; y < maxY; ++y) {
                        EXPLProxyBE explProxy;
                        BlockEntity be = this.blockEntity(this.m_58899_().m_7918_(x, y, z));
                        if (!(be instanceof EXPLProxyBE)) continue;
                        this.proxyBES[i] = explProxy = (EXPLProxyBE)be;
                        ++i;
                    }
                }
            }
        }
        return this.proxyBES;
    }

    private void tickProxyBlocks() {
        for (EXPLProxyBE proxy : this.getProxies()) {
            if (proxy == null) continue;
            proxy.forceTickServer(this);
        }
    }

    @Override
    public void tickServer() {
        this.energyStorage().tick();
        long wasCharge = this.aggregatedEnergy;
        if (!this.hasEnoughEnergy()) {
            this.aggregatedEnergy += (long)this.energyStorage().getEnergyStored();
            this.aggregatedEnergy = Math.min(this.aggregatedEnergy, (Long)KugelblitzConfig.KUGELBLITZ_CONFIG.EXPL_CHARGE.get());
            this.energyStorage().setEnergy(0);
        }
        this.inputRedstoneSignal = 0;
        this.tickProxyBlocks();
        boolean bl = this.activated = this.activated || this.inputRedstoneSignal > 0;
        if (this.activated && this.hasEnoughEnergy() && this.pulseTime == 0) {
            this.pulseTime = 90;
            if (this.activated && this.inputRedstoneSignal == 0 && !this.activatedByOther) {
                this.findAndPulseOtherLasers();
            }
        }
        if (this.pulseTime > 0) {
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 1);
            --this.pulseTime;
            this.m_6596_();
            if (this.pulseTime < 35) {
                this.renderBeam();
                this.aggregatedEnergy /= 2L;
            }
            if (this.pulseTime < 33 && this.pulseTime > 30) {
                this.transferEnergy();
                this.activatedByOther = false;
            }
            if (this.pulseTime < 10) {
                this.aggregatedEnergy = 0L;
                this.energyTransfered = false;
            }
        }
        if (this.activated && this.pulseTime < 1 || wasCharge != this.aggregatedEnergy) {
            this.activated = false;
            this.m_6596_();
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 1);
        }
    }

    private void findAndPulseOtherLasers() {
        int activatedLasers = 1;
        for (int i = 4; i <= (Integer)KugelblitzConfig.KUGELBLITZ_CONFIG.LASER_DISTANCE.get() + 4; ++i) {
            KugelblitzMultiblock kugelblitzMultiblock;
            BlockPos pos = this.m_58899_().m_5484_(this.getFacing(), i);
            BlockEntity be = this.f_58857_.getExistingBlockEntity(pos);
            if (!(be instanceof PhotonConcentratorBE)) continue;
            PhotonConcentratorBE photonConcentrator = (PhotonConcentratorBE)be;
            KugelblitzMultiblock multiblock = photonConcentrator.getMultiblock();
            if (!(multiblock instanceof KugelblitzMultiblock)) break;
            this.chamber = kugelblitzMultiblock = multiblock;
            BlockPos center = kugelblitzMultiblock.getCenter();
            if (center == null) {
                center = pos.m_5484_(this.getFacing(), 5);
            }
            block1: for (Direction direction : Direction.values()) {
                if (direction == this.getFacing().m_122424_()) continue;
                for (int j = 10; j < (Integer)KugelblitzConfig.KUGELBLITZ_CONFIG.LASER_DISTANCE.get() + 20; ++j) {
                    BlockEntity be2 = this.f_58857_.getExistingBlockEntity(center.m_5484_(direction, j));
                    if (!(be2 instanceof EXPLBE)) continue;
                    EXPLBE expl = (EXPLBE)be2;
                    expl.activate(true);
                    ++activatedLasers;
                    continue block1;
                }
            }
            break;
        }
        this.allLasersBurst = activatedLasers == 6 && this.chamber != null;
    }

    public void activate(boolean activatedByOther) {
        if (this.hasEnoughEnergy() && this.pulseTime == 0) {
            this.pulseTime = 90;
            this.activatedByOther = true;
            this.activated = true;
            this.m_6596_();
        }
    }

    private int getActualLaserDistance() {
        for (int i = 4; i <= (Integer)KugelblitzConfig.KUGELBLITZ_CONFIG.LASER_DISTANCE.get() + 4; ++i) {
            BlockPos pos = this.m_58899_().m_5484_(this.getFacing(), i);
            BlockEntity be = this.f_58857_.getExistingBlockEntity(pos);
            if (be instanceof PhotonConcentratorBE) {
                return i;
            }
            if (ModUtil.isMekanismGeneratorsLoaded() && be instanceof mekanism.generators.common.tile.fusion.TileEntityLaserFocusMatrix) {
                return i;
            }
            if (!ModUtil.isBfrLoaded() || !(be instanceof TileEntityLaserFocusMatrix)) continue;
            return i;
        }
        return (Integer)KugelblitzConfig.KUGELBLITZ_CONFIG.LASER_DISTANCE.get();
    }

    private void transferEnergy() {
        mekanism.generators.common.tile.fusion.TileEntityLaserFocusMatrix matrixBe;
        if (this.energyTransfered) {
            return;
        }
        this.killEntitiesInBeam();
        this.energyTransfered = true;
        BlockPos pos = this.m_58899_().m_5484_(this.getFacing(), this.getActualLaserDistance());
        BlockEntity be = this.f_58857_.getExistingBlockEntity(pos);
        if (this.allLasersBurst) {
            this.chamber.gotLaserBurst();
            this.allLasersBurst = false;
        }
        if (be instanceof PhotonConcentratorBE) {
            PhotonConcentratorBE photonConcentratorBE = (PhotonConcentratorBE)be;
            photonConcentratorBE.gotEnergy(this.getFacing());
        }
        if (ModUtil.isMekanismGeneratorsLoaded() && be instanceof mekanism.generators.common.tile.fusion.TileEntityLaserFocusMatrix) {
            matrixBe = (mekanism.generators.common.tile.fusion.TileEntityLaserFocusMatrix)be;
            matrixBe.receiveLaserEnergy(FloatingLong.create((long)(this.aggregatedEnergy * 5L)));
        }
        if (ModUtil.isBfrLoaded() && be instanceof TileEntityLaserFocusMatrix) {
            matrixBe = (TileEntityLaserFocusMatrix)be;
            matrixBe.receiveLaserEnergy(FloatingLong.create((long)(this.aggregatedEnergy * 5L)));
        }
    }

    private void killEntitiesInBeam() {
        Direction facing = this.getFacing();
        int distance = this.getActualLaserDistance();
        for (int i = 1; i < distance; ++i) {
            BlockPos pos = this.m_58899_().m_5484_(facing, i);
            this.f_58857_.m_6443_(LivingEntity.class, new AABB(pos), entity -> entity != null && entity.m_6084_()).forEach(entity -> entity.m_6469_(this.f_58857_.m_269111_().m_269425_(), 1000.0f));
        }
    }

    @Override
    public void tickClient() {
        if (this.aggregatedEnergy > 0L && this.pulseTime > 88) {
            this.playSound(NCSounds.LASER_SHOOT, 0.2f);
        }
        if (this.pulseTime < 20) {
            this.stopSound();
        }
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    public boolean hasEnoughEnergy() {
        return this.aggregatedEnergy >= (Long)KugelblitzConfig.KUGELBLITZ_CONFIG.EXPL_CHARGE.get();
    }
}

