/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.turbine.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import dan200.computercraft.shared.Capabilities;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.turbine.entity.TurbineBE;
import igentuman.nc.block.turbine.entity.TurbineControllerBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TurbinePortBE
extends TurbineBE {
    public static String NAME = "turbine_port";
    @NBTField
    public byte analogSignal = 0;
    @NBTField
    public byte comparatorMode = (byte)2;
    @NBTField
    public BlockPos controllerPos;

    public TurbinePortBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, NAME);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped) {
            return;
        }
        super.tickServer();
        byte wasSignal = this.analogSignal;
        if (this.getMultiblock() != null || this.controller() != null) {
            this.sendOutPower();
        }
        boolean updated = this.updateController();
        if (this.hasRedstoneSignal()) {
            this.controller().controllerEnabled = true;
        }
        this.updateAnalogSignal();
        updated = wasSignal != this.analogSignal || updated;
        Direction dir = this.getFacing();
        if (this.controller() != null && this.fluidHandler() != null) {
            updated = this.fluidHandler().pushFluids(dir, false, this.f_58858_) || updated;
            boolean bl = updated = this.fluidHandler().pullFluids(dir, false, this.f_58858_) || updated;
        }
        if (updated || NuclearCraft.currentTick % 40L == 0L && this.controller() != null && this.controller().controllerEnabled) {
            MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    private boolean updateController() {
        boolean result = false;
        if (this.controller != this.controller()) {
            this.controller = this.controller();
            this.controllerPos = BlockPos.f_121853_;
            result = true;
        }
        if (this.controller != null) {
            this.controllerPos = new BlockPos((Vec3i)this.controller.m_58899_());
            result = true;
        }
        return result;
    }

    @Override
    protected void transferEnergyToSide(Direction direction) {
        if (this.getEnergyStored() <= 0) {
            return;
        }
        int wasEnergy = this.getEnergyStored();
        BlockEntity be = this.f_58857_.getExistingBlockEntity(this.f_58858_.m_121945_(direction));
        if (be == null || be instanceof TurbinePortBE || be instanceof TurbineControllerBE) {
            return;
        }
        if (ModUtil.isGtLoaded() && TurbinePortBE.isGTEUCapEnabled()) {
            GTUtils.transferEU(this.controller(), be, this.controller().energyStorage(), direction);
        }
        if (ModUtil.isGtLoaded() && GTUtils.isOnlyGTCEUCapEnabled()) {
            return;
        }
        if (wasEnergy - this.getEnergyStored() >= this.controller().energyStorage().getMaxExtract()) {
            return;
        }
        int extracted = wasEnergy - this.controller().energyStorage().getEnergyStored();
        if (extracted >= this.controller().energyStorage().getMaxExtract()) {
            return;
        }
        int canExtract = Math.min(this.controller().energyStorage().getMaxExtract() - extracted, this.getEnergyStored());
        be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).map(handler -> {
            if (handler.canReceive()) {
                int received = handler.receiveEnergy(canExtract, false);
                this.controller().energyStorage().consumeEnergy(received);
                this.controller().m_6596_();
                return this.getEnergyStored() > 0;
            }
            return true;
        });
    }

    private void updateAnalogSignal() {
        if (this.controller() == null) {
            this.analogSignal = 0;
            return;
        }
        switch (this.comparatorMode) {
            case 0: {
                this.analogSignal = (byte)(this.controller().energyStorage().getEnergyStored() * 15 / this.controller().energyStorage().getMaxEnergyStored());
                break;
            }
            case 2: {
                this.analogSignal = this.controller().getFlow() == 0 ? (byte)0 : (byte)(this.controller().realFlow * 15 / this.controller().getFlow());
            }
        }
    }

    public void voidFluidSlot(int slotId) {
        if (this.controller() != null) {
            this.controller().voidFluidSlot(slotId);
            this.m_6596_();
        }
    }

    protected FluidCapabilityHandler fluidHandler() {
        return this.controller().contentHandler().fluidHandler;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.controller() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.controller().getCapability(cap, side);
        }
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && TurbinePortBE.isGTEUCapEnabled()) {
            return GTUtils.getGTEnergy(this.controller(), side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (!GTUtils.isOnlyGTCEUCapEnabled()) {
                return this.controller().getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.controller().getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    @Override
    public TurbineControllerBE controller() {
        if (NuclearCraft.instance.isNcBeStopped || !this.m_58904_().m_5776_() && this.m_58904_().m_7654_() != null && !this.m_58904_().m_7654_().m_130010_()) {
            return null;
        }
        if (this.m_58904_().f_46443_ && this.controller == null && this.controllerPos != null) {
            BlockEntity be = this.m_58904_().getExistingBlockEntity(this.controllerPos);
            if (be instanceof TurbineControllerBE) {
                TurbineControllerBE controllerBE;
                this.controller = controllerBE = (TurbineControllerBE)be;
                return this.controller;
            }
            return this.controller;
        }
        try {
            return this.getMultiblock().controller().controllerBE();
        }
        catch (NullPointerException e) {
            if (this.controllerPos != null) {
                return (TurbineControllerBE)this.m_58904_().getExistingBlockEntity(this.controllerPos);
            }
            return null;
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        this.saveFullTagData(infoTag);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Info", (Tag)infoTag);
        this.saveFullTagData(infoTag);
    }

    public int getEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage.getMaxEnergyStored();
    }

    public int energyPerTick() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyPerTick;
    }

    @Override
    public FluidTank getFluidTank(int i) {
        if (this.controller() == null) {
            return null;
        }
        return this.controller().getFluidTank(i);
    }

    public void toggleRedstoneMode() {
        this.comparatorMode = this.comparatorMode == 0 ? (byte)2 : (byte)0;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public static class SignalSource {
        public static final byte ENERGY = 0;
        public static final byte OVERFLOW = 2;
    }
}

