/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.NuclearCraft;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.button.Button;
import igentuman.nc.container.StorageContainerItemContainer;
import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

@NothingNullByDefault
public class StorageContainerItemScreen
extends AbstractContainerScreen<StorageContainerItemContainer<?>> {
    private final ResourceLocation GUI;
    private Button.Magnet magnetBtn;
    public List<NCGuiElement> widgets = new ArrayList<NCGuiElement>();
    protected int relX;
    protected int relY;

    public StorageContainerItemScreen(StorageContainerItemContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.GUI = NuclearCraft.rl("textures/gui/storage/" + container.getTier() + ".png");
        this.f_97726_ = this.getColls() * 18 + 20;
        this.f_97727_ = (this.getRows() + 4) * 18 + 20;
        this.updateRelativeCords();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateRelativeCords();
        this.widgets.clear();
        this.magnetBtn = new Button.Magnet(this.f_97726_ - 34, this.f_97727_ - 83, this);
        this.magnetBtn.refreshPosition();
        this.magnetBtn.visible = true;
        this.magnetBtn.active = true;
        this.addWidget(this.magnetBtn);
    }

    protected void addWidget(NCGuiElement widget) {
        widget.setScreen(this);
        this.widgets.add(widget);
    }

    private void renderWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        if (this.magnetBtn != null) {
            this.magnetBtn.setEnabled(((StorageContainerItemContainer)this.m_6262_()).isMagnetModeEnabled());
            this.magnetBtn.refreshPosition();
        }
        for (NCGuiElement widget : this.widgets) {
            widget.draw(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void updateRelativeCords() {
        this.relX = (this.f_96543_ - this.f_97726_) / 2;
        this.relY = (this.f_96544_ - this.f_97727_) / 2;
        NCGuiElement.RELATIVE_X = this.relX;
        NCGuiElement.RELATIVE_Y = this.relY;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_6375_(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private void renderTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_5953_(pMouseX, pMouseY)) continue;
            graphics.m_280677_(this.f_96547_, widget.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
    }

    private int getRows() {
        return ((StorageContainerItemContainer)this.f_97732_).getRows();
    }

    private int getColls() {
        return ((StorageContainerItemContainer)this.f_97732_).getColls();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        this.renderTooltips(matrixStack, mouseX - this.relX, mouseY - this.relY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        this.updateRelativeCords();
        graphics.m_280218_(this.GUI, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        this.renderWidgets(graphics, partialTicks, mouseX, mouseY);
    }
}

