/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.element.bar;

import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.client.gui.FusionCoreScreen;
import igentuman.nc.client.gui.IVerticalBarScreen;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class VerticalBar
extends NCGuiElement {
    protected double barValue;
    protected double maxValue;
    protected String hintKey = "";
    protected int xOffset;
    protected int backgroundXoffset = 120;
    IVerticalBarScreen screen;

    public VerticalBar(int x, int y, IVerticalBarScreen screen, long max) {
        super(x, y, 8, 88, (Component)Component.m_237119_());
        this.x = x;
        this.y = y;
        this.xOffset = 96;
        this.barValue = 0.0;
        this.maxValue = max;
        this.screen = screen;
        this.width = 8;
        this.height = 88;
    }

    @Override
    public List<Component> getTooltips() {
        if (this.hintKey.isEmpty()) {
            return this.tooltips;
        }
        this.tooltips.add(TextUtils.__(this.hintKey, TextUtils.scaledFormat(this.barValue), TextUtils.scaledFormat(this.maxValue)));
        return this.tooltips;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY, float pTicks) {
        super.draw(graphics, mX, mY, pTicks);
        int internal = this.height - 2;
        int stored = (int)Math.min((double)internal, (double)internal * (this.barValue / this.maxValue));
        graphics.m_280218_(TEXTURE, this.X(), this.Y(), this.backgroundXoffset, 0, this.width, this.height);
        graphics.m_280218_(TEXTURE, this.X() + 1, this.Y() + 1 + internal - stored, this.xOffset, internal - stored, this.width - 2, stored);
    }

    public void setTooltipKey(String s) {
        this.hintKey = s;
    }

    public static class HotCoolant
    extends VerticalBar {
        public HotCoolant(int x, int y, IVerticalBarScreen screen, int maxEnergy) {
            super(x, y, screen, maxEnergy);
            this.xOffset = 114;
            this.hintKey = "";
        }

        @Override
        public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
            this.barValue = this.screen.getHotCoolant();
            super.draw(transform, mX, mY, pTicks);
        }
    }

    public static class CoolantLong
    extends VerticalBar {
        public CoolantLong(int x, int y, IVerticalBarScreen screen, int capacity) {
            super(x, y, screen, capacity);
            this.xOffset = 140;
            this.height = 97;
            this.backgroundXoffset = 146;
            this.hintKey = "";
        }

        @Override
        public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
            this.barValue = this.screen.getCoolant();
            super.draw(transform, mX, mY, pTicks);
        }
    }

    public static class Coolant
    extends VerticalBar {
        public Coolant(int x, int y, IVerticalBarScreen screen, int capacity) {
            super(x, y, screen, capacity);
            this.xOffset = 108;
            this.hintKey = "coolant.bar.amount";
        }

        @Override
        public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
            this.barValue = this.screen.getCoolant();
            super.draw(transform, mX, mY, pTicks);
        }
    }

    public static class EnergyLong
    extends VerticalBar {
        public EnergyLong(int x, int y, IVerticalBarScreen screen, int maxEnergy) {
            super(x, y, screen, maxEnergy);
            this.xOffset = 128;
            this.height = 97;
            this.backgroundXoffset = 146;
            this.hintKey = ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled() ? "tooltip.eu.bar.amount" : "energy.bar.amount";
        }

        @Override
        public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
            this.barValue = this.screen.getEnergy();
            super.draw(transform, mX, mY, pTicks);
        }
    }

    public static class Energy
    extends VerticalBar {
        public Energy(int x, int y, IVerticalBarScreen screen, int maxEnergy) {
            super(x, y, screen, maxEnergy);
            this.xOffset = 96;
            this.hintKey = ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled() ? "tooltip.eu.bar.amount" : "energy.bar.amount";
        }

        @Override
        public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
            this.barValue = this.screen.getEnergy();
            super.draw(transform, mX, mY, pTicks);
        }
    }

    public static class HeatLong
    extends VerticalBar {
        Supplier<Double> heat;

        public HeatLong(int x, int y, IVerticalBarScreen screen, long maxHeat) {
            super(x, y, screen, maxHeat);
            this.xOffset = 134;
            this.height = 97;
            this.backgroundXoffset = 146;
            this.hintKey = "heat.bar.amount";
        }

        public HeatLong(int x, int y, FusionCoreScreen screen, long maxHeat, Supplier<Double> o) {
            this(x, y, screen, maxHeat);
            this.heat = o;
        }

        @Override
        public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
            this.barValue = this.heat != null ? this.heat.get().doubleValue() : this.screen.getHeat();
            super.draw(transform, mX, mY, pTicks);
        }
    }

    public static class Heat
    extends VerticalBar {
        public Heat(int x, int y, IVerticalBarScreen screen, int maxHeat) {
            super(x, y, screen, maxHeat);
            this.xOffset = 102;
            this.hintKey = "heat.bar.amount";
        }

        @Override
        public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
            this.barValue = this.screen.getHeat();
            super.draw(transform, mX, mY, pTicks);
        }
    }
}

