/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.element.button;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.NuclearCraft;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.processor.side.SideConfigScreen;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.network.toServer.PacketSideConfigToggle;
import igentuman.nc.util.TextUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SideConfig
extends NCGuiElement {
    protected SideConfigScreen screen;
    private int color;
    protected SideBtn btn;
    private int slotId;
    private int direction;

    public SideConfig(int xPos, int yPos, int slotId, SideConfigScreen screen, int direction, ResourceLocation btnTexture) {
        super(xPos, yPos, 16, 16, (Component)Component.m_237119_());
        this.x = xPos;
        this.y = yPos;
        this.width = 16;
        this.height = 16;
        this.screen = screen;
        this.slotId = slotId;
        this.btn = new SideBtn(this.X(), this.Y(), btnTexture, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketSideConfigToggle(screen.getPosition(), slotId, direction)));
        this.direction = direction;
    }

    @Override
    public boolean onPress() {
        this.btn.m_5691_();
        return true;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY, float pTicks) {
        super.draw(graphics, mX, mY, pTicks);
        this.renderButton(graphics, mX, mY, pTicks);
    }

    public String getDirectionName() {
        return SidedContentHandler.RelativeDirection.getDirectionName(this.direction).toLowerCase();
    }

    @Override
    public List<Component> getTooltips() {
        this.tooltips.clear();
        this.tooltips.add(TextUtils.applyFormat((Component)TextUtils.__("side_config." + this.getDirectionName(), new Object[0]), ChatFormatting.AQUA).m_7220_((Component)TextUtils.applyFormat((Component)TextUtils.__("side_config." + this.screen.getSlotMode(this.direction, this.slotId).name().toLowerCase(), new Object[0]), ChatFormatting.GOLD)));
        return this.tooltips;
    }

    public void getColorOverlay() {
        this.color = this.screen.getSlotMode(this.direction, this.slotId).getColor();
    }

    @Override
    public void renderButton(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.enableDepthTest();
        this.getColorOverlay();
        this.btn.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.m_280509_(this.X(), this.Y(), this.X() + this.width, this.Y() + this.height, this.color);
        if (this.isHovered) {
            this.renderToolTip(graphics, pMouseX, pMouseY);
        }
    }

    public static class SideBtn
    extends ImageButton {
        public SideBtn(int x, int y, ResourceLocation btnTexture, Button.OnPress onPress) {
            super(x, y, 16, 16, 0, 0, 0, btnTexture, 16, 16, onPress);
        }
    }
}

