/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.element.button;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.NuclearCraft;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.button.NCImageButton;
import igentuman.nc.network.toServer.PacketSliderChanged;
import igentuman.nc.util.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SliderHorizontal
extends NCGuiElement {
    protected AbstractContainerScreen screen;
    private int xTexStart;
    private int yTexStart;
    private int textureWidth = 256;
    private int textureHeight = 256;
    protected NCImageButton btn;
    private int yDiffTex;
    private boolean isPressed = false;
    private BlockPos pos;
    private int startX;
    private int buttonId = 0;

    public SliderHorizontal(int xPos, int yPos, int width, AbstractContainerScreen<?> screen, BlockPos pos) {
        super(xPos, yPos, width, 12, (Component)Component.m_237119_());
        this.x = xPos;
        this.y = yPos;
        this.startX = this.x;
        this.pos = pos;
        this.width = width;
        this.height = 12;
        this.screen = screen;
        this.xTexStart = 0;
        this.btn = new NCImageButton(this.X(), this.Y(), 4, 8, 0, 169, -9, TEXTURE, pButton -> {});
    }

    public SliderHorizontal(int xPos, int yPos, int width, AbstractContainerScreen<?> screen, BlockPos pos, int btnId) {
        this(xPos, yPos, width, screen, pos);
        this.buttonId = btnId;
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if ((double)(this.X() - 1) <= pMouseX && pMouseX < (double)(this.X() + this.width + 1) && (double)(this.Y() - 2) <= pMouseY && pMouseY < (double)(this.Y() + this.height + 2)) {
            this.isPressed = true;
            return this.isPressed;
        }
        this.m_6348_(pMouseX, pMouseY, pButton);
        return false;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.isPressed = false;
        return false;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.mouseMove((int)pMouseX, (int)pMouseY);
        return false;
    }

    public void mouseMove(int x, int y) {
        if (this.isPressed) {
            int maxX = this.startX + this.screen.getGuiLeft() + this.width - 3;
            int minX = this.startX + this.screen.getGuiLeft();
            x = Math.min(maxX, x);
            x = Math.max(minX, x);
            this.btn.m_252865_(x);
            int xpos = maxX - x;
            int ratio = 100;
            if (xpos > 0) {
                ratio = 100 - xpos * 100 / (this.width - 3);
            }
            NuclearCraft.packetHandler().sendToServer(new PacketSliderChanged(this.pos, ratio, this.buttonId));
        }
    }

    public void drawSlide(GuiGraphics graphics) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        graphics.m_280163_(TEXTURE, this.x + this.screen.getGuiLeft(), this.y + 2 + this.screen.getGuiTop(), 5.0f, 175.0f, this.width, 3, this.textureWidth, this.textureHeight);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY, float pTicks) {
        super.draw(graphics, mX, mY, pTicks);
        this.btn.xTexStart = this.xTexStart;
        this.drawSlide(graphics);
        this.btn.m_88315_(graphics, mX, mY, pTicks);
    }

    @Override
    public void renderButton(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int i = this.yTexStart;
        if (!this.m_142518_()) {
            i += this.yDiffTex * 2;
        } else if (this.m_198029_()) {
            i += this.yDiffTex;
        }
        RenderSystem.enableDepthTest();
        graphics.m_280163_(TEXTURE, this.x, this.y, (float)this.xTexStart, (float)i, this.width, this.height, this.textureWidth, this.textureHeight);
        if (this.isHovered) {
            this.renderToolTip(graphics, pMouseX, pMouseY);
        }
    }

    public NCGuiElement setTooltipKey(String key) {
        this.tooltips.clear();
        this.tooltips.add(TextUtils.__(key, new Object[0]));
        return this;
    }

    public void slideTo(int ratio) {
        this.btn.m_252865_(this.startX + this.screen.getGuiLeft() + this.width * ratio / 100);
    }
}

