/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.model.animation;

import igentuman.nc.client.model.ModelWastelandBoss;
import igentuman.nc.client.model.animation.BossAnimation;
import net.minecraft.util.Mth;

public class SlamAnimation
implements BossAnimation {
    public static SlamAnimation instance = new SlamAnimation();

    @Override
    public void playAnimation(ModelWastelandBoss<?> boss, float deltaTime) {
        float normalizedTime = deltaTime / this.getAnimationDuration();
        float raiseArmsPhase = 0.3f;
        float windupPhase = 0.4f;
        float slamPhase = 0.5f;
        float groundImpactPhase = 0.9f;
        float recoveryPhase = 1.0f;
        if (normalizedTime < raiseArmsPhase) {
            float armRotation;
            float raisingProgress = normalizedTime / raiseArmsPhase;
            boss.f_102811_.f_104203_ = armRotation = Mth.m_14179_((float)raisingProgress, (float)0.0f, (float)-2.0f);
            boss.f_102812_.f_104203_ = armRotation;
            boss.f_102810_.f_104203_ = Mth.m_14179_((float)raisingProgress, (float)0.0f, (float)-0.2f);
            boss.f_102808_.f_104203_ = Mth.m_14179_((float)raisingProgress, (float)0.0f, (float)0.3f);
        } else if (normalizedTime < windupPhase) {
            float pauseProgress = (normalizedTime - raiseArmsPhase) / (windupPhase - raiseArmsPhase);
            float armPauseMovement = Mth.m_14031_((float)(pauseProgress * 6.28f)) * 0.1f;
            boss.f_102811_.f_104203_ = -2.0f + armPauseMovement;
            boss.f_102812_.f_104203_ = -2.0f + armPauseMovement;
            float bodyAnticipation = Mth.m_14031_((float)(pauseProgress * 3.14f)) * 0.05f;
            boss.f_102810_.f_104203_ = -0.2f - bodyAnticipation;
            boss.f_102808_.f_104203_ = 0.3f + bodyAnticipation;
        } else if (normalizedTime < slamPhase) {
            float armRotation;
            float slamProgress = (normalizedTime - windupPhase) / (slamPhase - windupPhase);
            boss.f_102811_.f_104203_ = armRotation = Mth.m_14179_((float)slamProgress, (float)-2.0f, (float)-1.5f);
            boss.f_102812_.f_104203_ = armRotation;
            boss.f_102811_.f_104201_ = Mth.m_14179_((float)slamProgress, (float)0.0f, (float)6.5f);
            boss.f_102811_.f_104202_ = Mth.m_14179_((float)slamProgress, (float)0.0f, (float)-7.0f);
            boss.f_102812_.f_104201_ = Mth.m_14179_((float)slamProgress, (float)0.0f, (float)6.5f);
            boss.f_102812_.f_104202_ = Mth.m_14179_((float)slamProgress, (float)0.0f, (float)-7.0f);
            boss.f_102810_.f_104203_ = Mth.m_14179_((float)slamProgress, (float)-0.2f, (float)1.7f);
            boss.f_102808_.f_104203_ = Mth.m_14179_((float)slamProgress, (float)0.3f, (float)1.7f);
            boss.f_102808_.f_104202_ = Mth.m_14179_((float)slamProgress, (float)0.0f, (float)-4.5f);
            boss.f_102808_.f_104201_ = Mth.m_14179_((float)slamProgress, (float)0.0f, (float)6.0f);
        } else if (normalizedTime < groundImpactPhase) {
            float impactProgress = (normalizedTime - slamPhase) / (groundImpactPhase - slamPhase);
            float impactShake = Mth.m_14031_((float)(impactProgress * 25.0f)) * (1.0f - impactProgress) * 0.1f;
            boss.f_102811_.f_104203_ = -0.8f + impactShake;
            boss.f_102811_.f_104201_ = 8.5f;
            boss.f_102811_.f_104202_ = -8.5f;
            boss.f_102812_.f_104203_ = -0.8f + impactShake;
            boss.f_102812_.f_104201_ = 8.5f;
            boss.f_102812_.f_104202_ = -8.5f;
            boss.f_102810_.f_104203_ = 1.7f + impactShake * 0.5f;
            boss.f_102808_.f_104203_ = 1.7f + impactShake * 0.3f;
            boss.f_102808_.f_104202_ = -10.5f;
            boss.f_102808_.f_104201_ = 12.5f;
        } else {
            float armRotation;
            float recoveryProgress = (normalizedTime - groundImpactPhase) / (recoveryPhase - groundImpactPhase);
            boss.f_102811_.f_104203_ = armRotation = Mth.m_14179_((float)recoveryProgress, (float)-0.8f, (float)0.0f);
            boss.f_102812_.f_104203_ = armRotation;
            boss.f_102811_.f_104201_ = Mth.m_14179_((float)recoveryProgress, (float)8.5f, (float)2.0f);
            boss.f_102811_.f_104202_ = Mth.m_14179_((float)recoveryProgress, (float)-8.5f, (float)0.0f);
            boss.f_102812_.f_104201_ = Mth.m_14179_((float)recoveryProgress, (float)8.5f, (float)2.0f);
            boss.f_102812_.f_104202_ = Mth.m_14179_((float)recoveryProgress, (float)-8.5f, (float)0.0f);
            boss.f_102810_.f_104203_ = Mth.m_14179_((float)recoveryProgress, (float)1.7f, (float)0.0f);
            boss.f_102808_.f_104203_ = Mth.m_14179_((float)recoveryProgress, (float)1.7f, (float)0.0f);
            boss.f_102808_.f_104202_ = Mth.m_14179_((float)recoveryProgress, (float)-11.5f, (float)0.0f);
            boss.f_102808_.f_104201_ = Mth.m_14179_((float)recoveryProgress, (float)13.5f, (float)0.0f);
        }
    }

    @Override
    public float getAnimationDuration() {
        return 10.5f;
    }
}

