/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import igentuman.nc.client.renderer.NCRenderType;
import igentuman.nc.handler.event.client.TickHandler;
import igentuman.nc.util.CustomEffect;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BillboardingEffectRenderer {
    private BillboardingEffectRenderer() {
    }

    public static void render(CustomEffect effect, String profilerSection) {
        BillboardingEffectRenderer.render(effect.getTexture(), profilerSection, () -> effect);
    }

    public static void render(ResourceLocation texture, final String profilerSection, final Supplier<CustomEffect> lazyEffect) {
        TickHandler.addTransparentRenderer(NCRenderType.BLACKHOLE.apply(texture), new TickHandler.LazyRender(){

            @Override
            public void render(Camera camera, VertexConsumer renderer, PoseStack poseStack, int renderTick, float partialTick, ProfilerFiller profiler) {
                BillboardingEffectRenderer.render(camera, renderer, poseStack, renderTick, partialTick, (CustomEffect)lazyEffect.get());
            }

            @Override
            public Vec3 getCenterPos(float partialTick) {
                return ((CustomEffect)lazyEffect.get()).getPos(partialTick);
            }

            @Override
            public String getProfilerSection() {
                return profilerSection;
            }
        });
    }

    private static void render(Camera camera, VertexConsumer buffer, PoseStack poseStack, int renderTick, float partialTick, CustomEffect effect) {
        int gridSize = effect.getTextureGridSize();
        int tick = renderTick % (gridSize * gridSize);
        int yIndex = tick % gridSize;
        int xIndex = tick / gridSize;
        float spriteSize = 1.0f / (float)gridSize;
        Quaternionf quaternion = camera.m_253121_();
        Vector3f[] vertexPos = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        Vec3 pos = effect.getPos(partialTick);
        for (Vector3f vector3f : vertexPos) {
            quaternion.transform(vector3f);
            vector3f.mul(effect.getScale());
            vector3f.add((float)pos.m_7096_(), (float)pos.m_7098_(), (float)pos.m_7094_());
        }
        int[] color = effect.getColor().rgbaArray();
        float minU = (float)xIndex * spriteSize;
        float maxU = minU + spriteSize;
        float minV = (float)yIndex * spriteSize;
        float maxV = minV + spriteSize;
        poseStack.m_85836_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(matrix, vertexPos[0].x(), vertexPos[0].y(), vertexPos[0].z()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(minU, maxV).m_5752_();
        buffer.m_252986_(matrix, vertexPos[1].x(), vertexPos[1].y(), vertexPos[1].z()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(maxU, maxV).m_5752_();
        buffer.m_252986_(matrix, vertexPos[2].x(), vertexPos[2].y(), vertexPos[2].z()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(maxU, minV).m_5752_();
        buffer.m_252986_(matrix, vertexPos[3].x(), vertexPos[3].y(), vertexPos[3].z()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(minU, minV).m_5752_();
        poseStack.m_85849_();
    }
}

