/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.sound;

import java.lang.ref.WeakReference;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerSound
extends AbstractTickableSoundInstance {
    @NotNull
    private final WeakReference<Player> playerReference;
    private float lastX;
    private float lastY;
    private float lastZ;
    private float fadeUpStep = 0.1f;
    private float fadeDownStep = 0.1f;

    public PlayerSound(@NotNull Player player, @NotNull SoundEvent sound) {
        super(sound, SoundSource.PLAYERS, player.m_9236_().m_213780_());
        this.playerReference = new WeakReference<Player>(player);
        this.lastX = (float)player.m_20185_();
        this.lastY = (float)player.m_20186_();
        this.lastZ = (float)player.m_20189_();
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 0.1f;
    }

    @Nullable
    private Player getPlayer() {
        return (Player)this.playerReference.get();
    }

    protected void setFade(float fadeUpStep, float fadeDownStep) {
        this.fadeUpStep = fadeUpStep;
        this.fadeDownStep = fadeDownStep;
    }

    public double m_7772_() {
        Player player = this.getPlayer();
        if (player != null) {
            this.lastX = (float)player.m_20185_();
        }
        return this.lastX;
    }

    public double m_7780_() {
        Player player = this.getPlayer();
        if (player != null) {
            this.lastY = (float)player.m_20186_();
        }
        return this.lastY;
    }

    public double m_7778_() {
        Player player = this.getPlayer();
        if (player != null) {
            this.lastZ = (float)player.m_20189_();
        }
        return this.lastZ;
    }

    public void m_7788_() {
        Player player = this.getPlayer();
        if (player == null || !player.m_6084_()) {
            this.m_119609_();
            this.f_119573_ = 0.0f;
            return;
        }
        if (this.shouldPlaySound(player)) {
            if (this.f_119573_ < 1.0f) {
                this.f_119573_ = Math.min(1.0f, this.f_119573_ + this.fadeUpStep);
            }
        } else if (this.f_119573_ > 0.0f) {
            this.f_119573_ = Math.max(0.0f, this.f_119573_ - this.fadeDownStep);
        }
    }

    public abstract boolean shouldPlaySound(@NotNull Player var1);

    public float m_7769_() {
        return super.m_7769_() * 1.0f;
    }

    public boolean m_7784_() {
        return true;
    }

    public boolean m_7767_() {
        Player player = this.getPlayer();
        if (player == null) {
            return super.m_7767_();
        }
        return !player.m_20067_();
    }
}

