/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import igentuman.nc.NuclearCraft;
import igentuman.nc.compat.emi.CoolerPlacementEmiRecipe;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.util.TextUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CoolerPlacementEmiCategory
extends BasicEmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(NuclearCraft.rl("cooler_placement"), (EmiRenderable)EmiStack.of((ItemStack)new ItemStack((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("empty_cooler").get())));
    private final CoolerPlacementEmiRecipe recipe;

    public CoolerPlacementEmiCategory(CoolerPlacementEmiRecipe recipe) {
        super(CATEGORY, recipe.getId(), 176, CoolerPlacementEmiCategory.calculateHeight(recipe));
        this.recipe = recipe;
        this.inputs.add(EmiStack.of((ItemStack)recipe.getCoolerItem()));
        for (CoolerPlacementEmiRecipe.PlacementConditionGroup group : recipe.getConditionGroups()) {
            for (ItemStack blockItem : group.getRequiredBlocks()) {
                this.outputs.add(EmiStack.of((ItemStack)blockItem));
            }
        }
    }

    private static int calculateHeight(CoolerPlacementEmiRecipe recipe) {
        int height = 60;
        int maxSlotsPerRow = 9;
        for (CoolerPlacementEmiRecipe.PlacementConditionGroup group : recipe.getConditionGroups()) {
            int rowsUsed = (group.getRequiredBlocks().size() + maxSlotsPerRow - 1) / maxSlotsPerRow;
            height += rowsUsed * 18 + 20;
        }
        return Math.max(height, 120);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 8, 8).recipeContext((EmiRecipe)this);
        String heatText = TextUtils.__("heat_sink.heat.descr", String.valueOf((int)this.recipe.getCoolerDef().getHeat())).getString();
        widgets.addText((Component)Component.m_237113_((String)heatText), 30, 8, Color.CYAN.getRGB(), false);
        List<CoolerPlacementEmiRecipe.PlacementConditionGroup> groups = this.recipe.getConditionGroups();
        int currentY = 40;
        int maxSlotsPerRow = 9;
        int outputIndex = 0;
        for (int groupIndex = 0; groupIndex < groups.size(); ++groupIndex) {
            CoolerPlacementEmiRecipe.PlacementConditionGroup group = groups.get(groupIndex);
            List<ItemStack> requiredBlocks = group.getRequiredBlocks();
            String conditionText = group.getConditionText();
            widgets.addText((Component)Component.m_237113_((String)conditionText), 10, currentY - 12, Color.DARK_GRAY.getRGB(), false);
            for (int i = 0; i < requiredBlocks.size(); ++i) {
                int slotX = 8 + i % maxSlotsPerRow * 18;
                int slotY = currentY + i / maxSlotsPerRow * 18;
                widgets.addSlot((EmiIngredient)this.outputs.get(outputIndex), slotX, slotY).recipeContext((EmiRecipe)this);
                ++outputIndex;
            }
            int rowsUsed = (requiredBlocks.size() + maxSlotsPerRow - 1) / maxSlotsPerRow;
            currentY += rowsUsed * 18 + 20;
        }
    }

    public static Component getTitle() {
        return Component.m_237115_((String)"emi.category.nuclearcraft.cooler_placement");
    }
}

