/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.NuclearCraft;
import igentuman.nc.compat.jei.CoolerPlacementRecipe;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.util.TextUtils;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CoolerPlacementCategory
implements IRecipeCategory<CoolerPlacementRecipe> {
    public static final ResourceLocation UID = NuclearCraft.rl("cooler_placement");
    public static final RecipeType<CoolerPlacementRecipe> TYPE = RecipeType.create((String)"nuclearcraft", (String)"cooler_placement", CoolerPlacementRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public CoolerPlacementCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(176, 120);
        ItemStack emptyCooler = new ItemStack((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("empty_cooler").get());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)emptyCooler);
        this.title = Component.m_237115_((String)"jei.category.nuclearcraft.cooler_placement");
    }

    public RecipeType<CoolerPlacementRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CoolerPlacementRecipe recipe, IFocusGroup focuses) {
        builder.addInputSlot(8, 8).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getCoolerItem());
        List<CoolerPlacementRecipe.PlacementConditionGroup> groups = recipe.getConditionGroups();
        int currentY = 40;
        int maxSlotsPerRow = 9;
        for (int groupIndex = 0; groupIndex < groups.size(); ++groupIndex) {
            CoolerPlacementRecipe.PlacementConditionGroup group = groups.get(groupIndex);
            List<ItemStack> requiredBlocks = group.getRequiredBlocks();
            for (int i = 0; i < requiredBlocks.size(); ++i) {
                int slotX = 8 + i % maxSlotsPerRow * 18;
                int slotY = currentY + i / maxSlotsPerRow * 18;
                builder.addOutputSlot(slotX, slotY).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)requiredBlocks.get(i));
            }
            int rowsUsed = (requiredBlocks.size() + maxSlotsPerRow - 1) / maxSlotsPerRow;
            currentY += rowsUsed * 18 + 20;
        }
    }

    public void draw(CoolerPlacementRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        String heatText = TextUtils.__("heat_sink.heat.descr", String.valueOf((int)recipe.getCoolerDef().getHeat())).getString();
        graphics.m_280488_(font, heatText, 30, 8, Color.CYAN.getRGB());
        List<CoolerPlacementRecipe.PlacementConditionGroup> groups = recipe.getConditionGroups();
        int currentY = 30;
        int maxSlotsPerRow = 8;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.8f, 0.8f, 1.0f);
        for (int groupIndex = 0; groupIndex < groups.size(); ++groupIndex) {
            CoolerPlacementRecipe.PlacementConditionGroup group = groups.get(groupIndex);
            String conditionText = group.getConditionText();
            graphics.m_280056_(font, conditionText, 10, (int)((float)(currentY + 2) / 0.8f), Color.DARK_GRAY.getRGB(), false);
            int rowsUsed = (group.getRequiredBlocks().size() + maxSlotsPerRow - 1) / maxSlotsPerRow;
            currentY += rowsUsed * 18 + 20;
        }
        graphics.m_280168_().m_85849_();
    }
}

