/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.NuclearCraft;
import igentuman.nc.multiblock.fission.HeatSinkDef;
import igentuman.nc.util.NcUtils;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class HeatSinkPlacementRecipe {
    private final ResourceLocation id;
    private final HeatSinkDef heatSinkDef;
    private final ItemStack heatSinkItem;
    private final List<PlacementConditionGroup> conditionGroups;

    public HeatSinkPlacementRecipe(ResourceLocation id, HeatSinkDef heatSinkDef, ItemStack heatSinkItem) {
        this.id = id;
        this.heatSinkDef = heatSinkDef;
        this.heatSinkItem = heatSinkItem;
        this.conditionGroups = this.parseConditionGroups();
    }

    /*
     * WARNING - void declaration
     */
    private List<PlacementConditionGroup> parseConditionGroups() {
        ArrayList<PlacementConditionGroup> groups = new ArrayList<PlacementConditionGroup>();
        if (this.heatSinkDef.getValidator() != null) {
            HashMap<String[], List<String>> blockLines = this.heatSinkDef.getValidator().blockLines();
            for (Map.Entry<String[], List<String>> entry : blockLines.entrySet()) {
                String[] condition = entry.getKey();
                List<String> blockNames = entry.getValue();
                ArrayList<ItemStack> blockItems = new ArrayList<ItemStack>();
                for (String string : blockNames) {
                    void var9_9;
                    Block block;
                    if (!string.contains(":")) {
                        String string2 = "nuclearcraft:" + string;
                    }
                    if ((block = (Block)ForgeRegistries.BLOCKS.getValue(NcUtils.rlFromString((String)var9_9))) == null) continue;
                    blockItems.add(new ItemStack((ItemLike)block));
                }
                String conditionText = this.formatConditionText(condition, blockNames);
                groups.add(new PlacementConditionGroup(blockItems, conditionText));
            }
        }
        return groups;
    }

    private String formatConditionText(String[] condition, List<String> blockNames) {
        String operator = condition[0];
        String count = condition[1];
        ArrayList<String> displayNames = new ArrayList<String>();
        for (String blockName : blockNames) {
            if (!blockName.contains(":")) {
                ResourceLocation res = NuclearCraft.rl(blockName);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(res);
                if (block == null) continue;
                displayNames.add(block.m_49954_().getString());
                continue;
            }
            displayNames.add(TextUtils.convertToName(blockName.split(":")[1]));
        }
        String blocksLine = String.join((CharSequence)(" " + TextUtils.__("heat_sink.or", new Object[0]).getString() + " "), displayNames);
        return switch (operator) {
            case ">" -> TextUtils.__("heat_sink.atleast" + (count.equals("1") ? "" : "s"), count, "").getString();
            case "<" -> TextUtils.__("heat_sink.less_than", count, "").getString();
            case "=" -> TextUtils.__("heat_sink.exact" + (count.equals("1") ? "" : "s"), count, "").getString();
            case "-" -> TextUtils.__("heat_sink.between", count, "").getString();
            case "^" -> TextUtils.__("heat_sink.in_corner", count, "").getString();
            default -> blocksLine;
        };
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public HeatSinkDef getHeatSinkDef() {
        return this.heatSinkDef;
    }

    public ItemStack getHeatSinkItem() {
        return this.heatSinkItem;
    }

    public List<PlacementConditionGroup> getConditionGroups() {
        return this.conditionGroups;
    }

    public static class PlacementConditionGroup {
        private final List<ItemStack> requiredBlocks;
        private final String conditionText;

        public PlacementConditionGroup(List<ItemStack> requiredBlocks, String conditionText) {
            this.requiredBlocks = requiredBlocks;
            this.conditionText = conditionText;
        }

        public List<ItemStack> getRequiredBlocks() {
            return this.requiredBlocks;
        }

        public String getConditionText() {
            return this.conditionText;
        }
    }
}

