/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.util.NcUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class MultiblockStructure {
    private final Map<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;

    public MultiblockStructure(CompoundTag nbt) {
        if (nbt.m_128425_("blocks", 9)) {
            ListTag blocksList = nbt.m_128437_("blocks", 10);
            ListTag palette = nbt.m_128437_("palette", 10);
            for (int i = 0; i < blocksList.size(); ++i) {
                CompoundTag blockTag = blocksList.m_128728_(i);
                CompoundTag state = palette.m_128728_(blockTag.m_128451_("state"));
                Tag tag = blockTag.m_128423_("pos");
                if (!(tag instanceof ListTag)) continue;
                ListTag posList = (ListTag)tag;
                if (state.m_128461_("Name") == null || posList.size() != 3) continue;
                int x = posList.m_128763_(0);
                int y = posList.m_128763_(1);
                int z = posList.m_128763_(2);
                BlockPos pos = new BlockPos(x, y, z);
                String blockId = state.m_128461_("Name");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(NcUtils.rlFromString(blockId));
                if (block == null) continue;
                BlockState bs = block.m_49966_();
                if (state.m_128425_("Properties", 10)) {
                    CompoundTag properties = state.m_128469_("Properties");
                    block1: for (String pKey : state.m_128469_("Properties").m_128431_()) {
                        for (Property property : bs.m_61147_()) {
                            if (!property.m_61708_().equals(pKey)) continue;
                            String valueStr = properties.m_128461_(pKey);
                            Optional value = property.m_6215_(valueStr);
                            if (!value.isPresent()) continue block1;
                            bs = MultiblockStructure.setPropertyValue(bs, property, value.get());
                            continue block1;
                        }
                    }
                }
                this.blocks.put(pos, bs);
                this.minX = Math.min(this.minX, x);
                this.minY = Math.min(this.minY, y);
                this.minZ = Math.min(this.minZ, z);
                this.maxX = Math.max(this.maxX, x);
                this.maxY = Math.max(this.maxY, y);
                this.maxZ = Math.max(this.maxZ, z);
            }
        }
    }

    private static <S extends BlockState, T extends Comparable<T>> S setPropertyValue(S blockState, Property<T> property, Object value) {
        return (S)((BlockState)blockState.m_61124_(property, (Comparable)value));
    }

    public BlockState getBlockAt(BlockPos pos) {
        return this.blocks.get(pos);
    }

    public Map<BlockPos, BlockState> getBlocks() {
        return this.blocks;
    }

    public int getWidth() {
        return this.maxX - this.minX + 1;
    }

    public int getHeight() {
        return this.maxY - this.minY + 1;
    }

    public int getDepth() {
        return this.maxZ - this.minZ + 1;
    }

    public BlockPos getCenter() {
        return new BlockPos((this.minX + this.maxX) / 2, (this.minY + this.maxY) / 2, (this.minZ + this.maxZ) / 2);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }
}

