/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.refined_storage;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.network.grid.GridProcessingTransferMessage;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import igentuman.nc.compat.emi.ProcessorEmiCategory;
import igentuman.nc.container.NCProcessorContainer;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProcessorEmiRecipeHandlerRS<T extends AbstractContainerMenu>
implements StandardRecipeHandler<T> {
    public List<Slot> getInputSources(T handler) {
        ArrayList<Slot> inputs = new ArrayList<Slot>();
        if (handler instanceof NCProcessorContainer) {
            int processorSlots;
            NCProcessorContainer processorContainer = (NCProcessorContainer)((Object)handler);
            for (int i = processorSlots = processorContainer.getProcessor().getSlotsConfig().slotsCount() + 2; i < processorSlots + 36 && i < ((AbstractContainerMenu)handler).f_38839_.size(); ++i) {
                inputs.add(handler.m_38853_(i));
            }
            return inputs;
        }
        for (int i = 0; i < ((AbstractContainerMenu)handler).f_38839_.size(); ++i) {
            inputs.add(handler.m_38853_(i));
        }
        return inputs;
    }

    public List<Slot> getCraftingSlots(T handler) {
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        if (handler instanceof NCProcessorContainer) {
            NCProcessorContainer processorContainer = (NCProcessorContainer)((Object)handler);
            int processorSlots = processorContainer.getProcessor().getSlotsConfig().getInputItems();
            for (int i = 0; i < processorSlots && i < ((AbstractContainerMenu)handler).f_38839_.size(); ++i) {
                craftingSlots.add(handler.m_38853_(i));
            }
        }
        return craftingSlots;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe instanceof ProcessorEmiCategory;
    }

    public boolean canCraft(EmiRecipe emiRecipe, EmiCraftContext<T> emiCraftContext) {
        return true;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        GridScreen gridScreen;
        AbstractContainerScreen abstractContainerScreen = context.getScreen();
        if (abstractContainerScreen instanceof GridScreen && (gridScreen = (GridScreen)abstractContainerScreen).getGrid().getGridType() == GridType.PATTERN && recipe instanceof ProcessorEmiCategory) {
            ProcessorEmiCategory processorRecipe = (ProcessorEmiCategory)recipe;
            return this.transferProcessingRecipe(processorRecipe, context, gridScreen);
        }
        return true;
    }

    private boolean transferProcessingRecipe(ProcessorEmiCategory processorRecipe, EmiCraftContext<T> context, GridScreen gridScreen) {
        NcRecipe ncRecipe = processorRecipe.getRecipe();
        ItemStackIngredient[] inputs = ncRecipe.getInputItems();
        List<ItemStack> outputs = ncRecipe.getResultItems();
        FluidStackIngredient[] fluidInputs = ncRecipe.getInputFluids();
        List<FluidStack> fluidOutputs = ncRecipe.getOutputFluids();
        return this.sendProcessingTransferMessage(inputs, outputs, fluidInputs, fluidOutputs);
    }

    private boolean sendProcessingTransferMessage(ItemStackIngredient[] inputs, List<ItemStack> outputs, FluidStackIngredient[] fluidInputs, List<FluidStack> fluidOutputs) {
        try {
            ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
            for (ItemStackIngredient ingredient : inputs) {
                inputItems.add((ItemStack)ingredient.getRepresentations().get(0));
            }
            ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
            for (FluidStackIngredient ingredient : fluidInputs) {
                inputFluids.add((FluidStack)ingredient.getRepresentations().get(0));
            }
            RS.NETWORK_HANDLER.sendToServer((Object)new GridProcessingTransferMessage(inputItems, outputs, inputFluids, fluidOutputs));
        }
        catch (Exception ignore) {
            return false;
        }
        return true;
    }
}

