/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.materials;

import igentuman.nc.content.materials.Materials;
import igentuman.nc.content.materials.NCMaterial;
import igentuman.nc.world.ore.NCOre;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Ores {
    private static HashMap<String, NCOre> all;
    private static HashMap<String, NCOre> registered;

    public static HashMap<String, NCOre> registered() {
        if (registered == null) {
            registered = new HashMap();
            for (String name : Ores.all().keySet()) {
                if (!Ores.all().get(name).config().isRegistered()) continue;
                registered.put(name, Ores.all().get(name));
            }
        }
        return registered;
    }

    public static boolean isRegistered(String name) {
        return Ores.registered().containsKey(name);
    }

    public static HashMap<String, NCOre> all() {
        if (all == null) {
            all = new HashMap();
            for (NCMaterial m : Materials.ores().values()) {
                int min = 4;
                int max = 60;
                if (m.deepslate_ore) {
                    min = -60;
                }
                if (!(m.normal_ore || m.nether_ore || m.end_ore)) {
                    max = 0;
                }
                all.put(m.name, NCOre.get(m.name).vein(7, 3).height(min, max).dim("minecraft:overworld", "nuclearcraft:wasteland"));
            }
        }
        return all;
    }

    public static List<Boolean> initialOreRegistration() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (NCOre ore : Ores.all().values()) {
            tmp.add(true);
        }
        return tmp;
    }

    public static List<Integer> initialOreVeinSizes() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (NCOre ore : Ores.all().values()) {
            tmp.add(ore.veinSize);
        }
        return tmp;
    }

    public static List<Integer> initialOreVeinsAmount() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (NCOre ore : Ores.all().values()) {
            tmp.add(ore.veinAmount);
        }
        return tmp;
    }

    public static List<Integer> initialOreMinHeight() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (NCOre ore : Ores.all().values()) {
            tmp.add(ore.height[0]);
        }
        return tmp;
    }

    public static List<Integer> initialOreMaxHeight() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (NCOre ore : Ores.all().values()) {
            tmp.add(ore.height[1]);
        }
        return tmp;
    }

    public static List<List<String>> initialOreDimensions() {
        ArrayList<List<String>> tmp = new ArrayList<List<String>>();
        for (NCOre ore : Ores.all().values()) {
            List<String> t = ore.dimensions;
            tmp.add(t);
        }
        return tmp;
    }
}

