/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen;

import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.multiblock.particle_chamber.TargetChamberRegistration;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.setup.registration.NCStorageBlocks;
import igentuman.nc.util.TextUtils;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;

public class NCLanguageProvider
extends LanguageProvider {
    public NCLanguageProvider(DataGenerator gen, String locale) {
        super(gen.getPackOutput(), "nuclearcraft", locale);
    }

    protected void addTranslations() {
        this.add("itemGroup.nuclearcraft_items", "NuclearCraft Items");
        this.add("itemGroup.nuclearcraft_blocks", "NuclearCraft Blocks");
        this.add("itemGroup.nuclearcraft_fission_reactor", "NuclearCraft Fission Reactor");
        this.add("itemGroup.nuclearcraft_fusion_reactor", "NuclearCraft Fusion Reactor");
        this.add("itemGroup.nuclearcraft_fluids", "NuclearCraft Fluids");
        this.add("itemGroup.nuclearcraft_turbine", "NuclearCraft Turbine");
        this.add("itemGroup.nuclearcraft_kugelblitz", "NuclearCraft Kugelblitz");
        this.add("itemGroup.nuclearcraft_accelerator", "NuclearCraft Accelerators");
        this.add("entity.nuclearcraft.feral_ghoul", "Feral Ghoul");
        this.add("entity.nuclearcraft.feral_ghoul_boss", "Boss of the Wasteland");
        this.add("biome.nuclearcraft.wasteland", "Wasteland");
        this.ores();
        this.ingots();
        this.plates();
        this.dusts();
        this.nuggets();
        this.gems();
        this.parts();
        this.chunks();
        this.blocks();
        this.food();
        this.armor();
        this.records();
        this.particleSources();
        this.tools();
        this.items();
        this.fuel();
        this.tooltips();
        this.isotopes();
        this.waste();
        this.shielding();
        this.buckets();
        this.fluids();
        this.processors();
        this.energyBlocks();
        this.multiblocks();
        this.labels();
        this.messages();
        this.storageBlocks();
        this.sounds();
        this.advancements();
        this.particles();
    }

    private void particles() {
        this.add("report.nc.validation_count", "Validations: %s");
        this.add("report.nc.validation_duration", "Validated in: %s ms");
        this.add("emi.category.nuclearcraft.cooler_placement", "Cooler Placement");
        this.add("emi.category.nuclearcraft.ingot_former", "Ingot Former");
        this.add("emi.category.nuclearcraft.fusion_coolant", "Fusion Reactor Coolant");
        this.add("emi.category.nuclearcraft.fusion_core", "Fusion Reactor");
        this.add("emi.category.nuclearcraft.crystallizer", "Crystallizer");
        this.add("emi.category.nuclearcraft.fluid_infuser", "Fluid Infuser");
        this.add("emi.category.nuclearcraft.manufactory", "Manufactory");
        this.add("emi.category.nuclearcraft.rock_crusher", "Rock Crusher");
        this.add("emi.category.nuclearcraft.irradiator", "Irradiator");
        this.add("emi.category.nuclearcraft.pressurizer", "Pressurizer");
        this.add("emi.category.nuclearcraft.melter", "Melter");
        this.add("emi.category.nuclearcraft.nc_ore_veins", "Ore Veins");
        this.add("emi.category.nuclearcraft.gas_scrubber", "Gas Scrubber");
        this.add("emi.category.nuclearcraft.centrifuge", "Centrifuge");
        this.add("emi.category.nuclearcraft.electrolyzer", "Electrolyzer");
        this.add("emi.category.nuclearcraft.subatomic_liquifier", "Sub-atomic liquifier");
        this.add("emi.category.nuclearcraft.pump", "Pump");
        this.add("emi.category.nuclearcraft.nuclear_furnace", "Nuclear Furnace");
        this.add("emi.category.nuclearcraft.fluid_enricher", "Fluid Enricher");
        this.add("emi.category.nuclearcraft.fission_reactor_controller", "Fission Reactor");
        this.add("emi.category.nuclearcraft.decay_hastener", "Decay Hastener");
        this.add("emi.category.nuclearcraft.fission_boiling", "Fission Boiling");
        this.add("emi.category.nuclearcraft.accelerator_coolant", "Accelerator Coolant");
        this.add("emi.category.nuclearcraft.analyzer", "Analyzer");
        this.add("emi.category.nuclearcraft.target_chamber", "Target Chamber");
        this.add("emi.category.nuclearcraft.kugelblitz_chamber", "Kugelblitz Chamber");
        this.add("emi.category.nuclearcraft.turbine_controller", "Turbine Controller");
        this.add("emi.category.nuclearcraft.heat_sink_placement", "Heat Sink Placement");
        this.add("emi.category.nuclearcraft.assembler", "Assembler");
        this.add("emi.category.nuclearcraft.isotope_separator", "Isotope Separator");
        this.add("emi.category.nuclearcraft.chemical_reactor", "Chemical Reactor");
        this.add("emi.category.nuclearcraft.alloy_smelter", "Alloy Smelter");
        this.add("emi.category.nuclearcraft.extractor", "Extractor");
        this.add("emi.category.nuclearcraft.steam_turbine", "Steam Turbine");
        this.add("emi.category.nuclearcraft.leacher", "Leacher");
        this.add("emi.category.nuclearcraft.supercooler", "Supercooler");
        this.add("emi.category.nuclearcraft.fuel_reprocessor", "");
        this.add("emi.category.nuclearcraft.particle_info", "Particle Info");
        this.add("emi.category.nuclearcraft.kugelblitz_info", "Kugelblitz Info");
        this.add("gui.nuclearcraft.jei.particle.mass", "Mass: %s");
        this.add("jei.category.nuclearcraft.particle_info", "Particle Info");
        this.add("jei.category.nuclearcraft.heat_sink_placement", "Heat Sink Placement");
        this.add("jei.category.nuclearcraft.cooler_placement", "Cooler Placement");
        this.add("gui.nuclearcraft.jei.particle.charge", "Charge: %s");
        this.add("gui.nuclearcraft.jei.particle.spin", "Spin: %s");
        this.add("gui.nuclearcraft.jei.particle.colour", "Feels Strong Force: %s");
        this.add("gui.nuclearcraft.jei.particle.weak", "Feels Weak Force: %s");
        this.add("gui.nuclearcraft.jei.particle.components", "Made of:");
        this.add("gui.nuclearcraft.jei.particle.focus", "Minimum Focus: %s");
        this.add("gui.nuclearcraft.jei.reaction.range", "Range: %s");
        this.add("gui.nuclearcraft.jei.reaction.energy_released", "Released Energy: %s");
        this.add("gui.nuclearcraft.jei.reaction.cross_section", "Cross Section: %s%%");
        this.add("gui.nuclearcraft.jei.reaction.heat_released", "Heat Released: %s");
        this.add("gui.nuclearcraft.jei.reaction.max_energy", "Maximum Energy: %s");
        this.add("nuclearcraft.particle.none.name", "None");
        this.add("nuclearcraft.particle.up_quark.name", "Up Quark");
        this.add("nuclearcraft.particle.antiup_quark.name", "Anti-Up Quark");
        this.add("nuclearcraft.particle.down_quark.name", "Down Quark");
        this.add("nuclearcraft.particle.antidown_quark.name", "Anti-Down Quark");
        this.add("nuclearcraft.particle.charm_quark.name", "Charm Quark");
        this.add("nuclearcraft.particle.anticharm_quark.name", "Anti-Charm Quark");
        this.add("nuclearcraft.particle.strange_quark.name", "Strange Quark");
        this.add("nuclearcraft.particle.antistrange_quark.name", "Anti-Strange Quark");
        this.add("nuclearcraft.particle.top_quark.name", "Top Quark");
        this.add("nuclearcraft.particle.antitop_quark.name", "Anti-Top Quark");
        this.add("nuclearcraft.particle.bottom_quark.name", "Bottom Quark");
        this.add("nuclearcraft.particle.antibottom_quark.name", "Anti-Bottom Quark");
        this.add("nuclearcraft.particle.electron.name", "Electron");
        this.add("nuclearcraft.particle.positron.name", "Positron");
        this.add("nuclearcraft.particle.electron_neutrino.name", "Electron Neutrino");
        this.add("nuclearcraft.particle.electron_antineutrino.name", "Electron Antineutrino");
        this.add("nuclearcraft.particle.muon.name", "Muon");
        this.add("nuclearcraft.particle.antimuon.name", "Anti-Muon");
        this.add("nuclearcraft.particle.muon_neutrino.name", "Muon Neutrino");
        this.add("nuclearcraft.particle.muon_antineutrino.name", "Muon Antineutrino");
        this.add("nuclearcraft.particle.tau.name", "Tau");
        this.add("nuclearcraft.particle.antitau.name", "Anti-Tau");
        this.add("nuclearcraft.particle.tau_neutrino.name", "Tau Neutrino");
        this.add("nuclearcraft.particle.tau_antineutrino.name", "Tau Antineutrino");
        this.add("nuclearcraft.particle.photon.name", "Photon");
        this.add("nuclearcraft.particle.gluon.name", "Gluon");
        this.add("nuclearcraft.particle.w_plus_boson.name", "W+ Boson");
        this.add("nuclearcraft.particle.w_minus_boson.name", "W- Boson");
        this.add("nuclearcraft.particle.z_boson.name", "Z Boson");
        this.add("nuclearcraft.particle.higgs_boson.name", "Higgs Boson");
        this.add("nuclearcraft.particle.proton.name", "Proton");
        this.add("nuclearcraft.particle.antiproton.name", "Anti-Proton");
        this.add("nuclearcraft.particle.neutron.name", "Neutron");
        this.add("nuclearcraft.particle.antineutron.name", "Anti-Neutron");
        this.add("nuclearcraft.particle.deuteron.name", "Deuteron");
        this.add("nuclearcraft.particle.antideuteron.name", "Anti-Deuteron");
        this.add("nuclearcraft.particle.alpha.name", "Alpha Particle");
        this.add("nuclearcraft.particle.antialpha.name", "Anti-Alpha Particle");
        this.add("nuclearcraft.particle.pion_plus.name", "Pion +");
        this.add("nuclearcraft.particle.pion_naught.name", "Pion 0");
        this.add("nuclearcraft.particle.pion_minus.name", "Pion -");
        this.add("nuclearcraft.particle.triton.name", "Triton");
        this.add("nuclearcraft.particle.antitriton.name", "Anti-Triton");
        this.add("nuclearcraft.particle.helion.name", "Helion");
        this.add("nuclearcraft.particle.antihelion.name", "Anti-Helion");
        this.add("nuclearcraft.particle.boron_ion.name", "Boron Ion");
        this.add("nuclearcraft.particle.calcium_48_ion.name", "Calcium-48 Ion");
        this.add("nuclearcraft.particle.kaon_plus.name", "Kaon +");
        this.add("nuclearcraft.particle.kaon_minus.name", "Kaon -");
        this.add("nuclearcraft.particle.kaon_naught.name", "Kaon 0");
        this.add("nuclearcraft.particle.antikaon_naught.name", "Anti-Kaon 0");
        this.add("nuclearcraft.particle.eta.name", "Eta Meson");
        this.add("nuclearcraft.particle.eta_prime.name", "Eta Prime Meson");
        this.add("nuclearcraft.particle.charmed_eta.name", "Charmed Eta Meson");
        this.add("nuclearcraft.particle.bottom_eta.name", "Bottom Eta Meson");
        this.add("nuclearcraft.particle.glueball.name", "Glueball");
        this.add("nuclearcraft.particle.sigma_plus.name", "Sigma +");
        this.add("nuclearcraft.particle.antisigma_plus.name", "Anti-Sigma +");
        this.add("nuclearcraft.particle.sigma_naught.name", "Sigma 0");
        this.add("nuclearcraft.particle.antisigma_naught.name", "Anti-Sigma 0");
        this.add("nuclearcraft.particle.sigma_minus.name", "Sigma -");
        this.add("nuclearcraft.particle.antisigma_minus.name", "Anti-Sigma -");
        this.add("nuclearcraft.particle.delta_plus_plus.name", "Delta ++");
        this.add("nuclearcraft.particle.antidelta_plus_plus.name", "Anti-Delta ++");
        this.add("nuclearcraft.particle.delta_minus.name", "Delta -");
        this.add("nuclearcraft.particle.antidelta_minus.name", "Anti-Delta -");
        this.add("nuclearcraft.particle.up_quark.desc", "The Up Quark is the lightest quark. Up and Down quarks combine to form Protons and Neutrons");
        this.add("nuclearcraft.particle.antiup_quark.desc", "The Anti-Up Quark is the antimatter partner of the Up Quark.");
        this.add("nuclearcraft.particle.down_quark.desc", "The Down Quark is the second lightest quark. Up and Down quarks combine to form Protons and Neutrons");
        this.add("nuclearcraft.particle.antidown_quark.desc", "The Anti-Down Quark is the antimatter partner of the Up Down.");
        this.add("nuclearcraft.particle.charm_quark.desc", "The Charm Quark is a heavy version of the Up Quark.");
        this.add("nuclearcraft.particle.anticharm_quark.desc", "The Anti-Charm Quark is the antimatter partner of the Charm Quark.");
        this.add("nuclearcraft.particle.strange_quark.desc", "The Strange Quark is a heavy version of the Down Quark.");
        this.add("nuclearcraft.particle.antistrange_quark.desc", "The Anti-Strange Quark is the antimatter partner of the Strange Quark.");
        this.add("nuclearcraft.particle.top_quark.desc", "The Top Quark is a very heavy version of the Up Quark.");
        this.add("nuclearcraft.particle.antitop_quark.desc", "The Anti-Top Quark is the antimatter partner of the Top Quark.");
        this.add("nuclearcraft.particle.bottom_quark.desc", "The Bottom Quark is a very heavy version of the Down Quark.");
        this.add("nuclearcraft.particle.antibottom_quark.desc", "The Anti-Bottom Quark is the antimatter partner of the Bottom Quark.");
        this.add("nuclearcraft.particle.electron.desc", "The Electron is lightest charged lepton. It is commonly found in orbitals around nuclei, forming atoms.");
        this.add("nuclearcraft.particle.positron.desc", "The positron is the Antimatter particle of the electron. When a electron and positron meet the annihilate resulting in all there mass being converted into energy in the form of 2 gamma rays.");
        this.add("nuclearcraft.particle.electron_neutrino.desc", "The Electron Neutrino is the neutrino partner of the Electron.");
        this.add("nuclearcraft.particle.electron_antineutrino.desc", "The Electron Antineutrino is the antimatter partner of the Electron Neutrino.");
        this.add("nuclearcraft.particle.muon.desc", "The Muon is basically a heavy electron.");
        this.add("nuclearcraft.particle.antimuon.desc", "The Anti-Muon is the antimatter partner of the Muon.");
        this.add("nuclearcraft.particle.muon_neutrino.desc", "The Muon Neutrino is the neutrino partner of the Muon.");
        this.add("nuclearcraft.particle.muon_antineutrino.desc", "The Muon Antineutrino is the antimatter partner of the Muon Neutrino.");
        this.add("nuclearcraft.particle.tau.desc", "The Tau is basically a really heavy electron");
        this.add("nuclearcraft.particle.antitau.desc", "The Anti-Tau is the antimatter partner of the Tau.");
        this.add("nuclearcraft.particle.tau_neutrino.desc", "The Tau Neutrino is the neutrino partner of the Tau.");
        this.add("nuclearcraft.particle.tau_antineutrino.desc", "The Tau Antineutrino is the antimatter partner of the Tau Neutrino.");
        this.add("nuclearcraft.particle.photon.desc", "Photons are the particles that make up light. They are the carries of the electromagnetic force. High energy Photons are called gamma rays.");
        this.add("nuclearcraft.particle.gluon.desc", "Gluons are the carries of the strong force. The strong force is what keeps quarks bound together to create composite particles like protons and neutrons.");
        this.add("nuclearcraft.particle.w_plus_boson.desc", "The Z and W bosons are the carries of the weak force. The weak force is what allows some particles to decay and is responsible for beta decay.");
        this.add("nuclearcraft.particle.w_minus_boson.desc", " The Z and W bosons are the carries of the weak force. The weak force is what allows some particles to decay and is responsible for beta decay.");
        this.add("nuclearcraft.particle.z_boson.desc", "The Z and W bosons are the carries of the weak force. The weak force is what allows some particles to decay and is responsible for beta decay.");
        this.add("nuclearcraft.particle.higgs_boson.desc", "The Higgs Boson is the boson of the Higgs Field which is responsible for giving particles their mass.");
        this.add("nuclearcraft.particle.proton.desc", "The Proton is a Nucleon along with the Neutron make up the nucleus of atoms.");
        this.add("nuclearcraft.particle.antiproton.desc", "The Anti-Proton is the antimatter partner of the Proton.");
        this.add("nuclearcraft.particle.neutron.desc", "The Neutron is a Nucleon along with the Protons make up the nucleus of atoms. The Neutron is used in nuclear fission to split fissile nuclei.");
        this.add("nuclearcraft.particle.antineutron.desc", "The Anti-Neutron is the antimatter partner of the Neutron.");
        this.add("nuclearcraft.particle.deuteron.desc", "The Deuteron is the nucleus of a Deuterium Atom.");
        this.add("nuclearcraft.particle.antideuteron.desc", "The Anti-Deuteron is the antimatter partner of the Deuteron.");
        this.add("nuclearcraft.particle.alpha.desc", "Alpha Particle is another name for the nucleus of helium 4. It is commonly released in the decay of heavy elements like uranium and plutonium.");
        this.add("nuclearcraft.particle.antialpha.desc", "The Anti-Alpha Particle is the antimatter partner of the Alpha Particle.");
        this.add("nuclearcraft.particle.pion_plus.desc", "Pions are the particles that are responsible for holding nuclei together. Although not colored themselves they distribute the \"residual\" strong force to keep nuclei together.");
        this.add("nuclearcraft.particle.pion_naught.desc", "Pions are the particles that are responsible for holding nuclei together. Although not colored themselves they distribute the \"residual\" strong force to keep nuclei together.");
        this.add("nuclearcraft.particle.pion_minus.desc", "Pions are the particles that are responsible for holding nuclei together. Although not colored themselves they distribute the \"residual\" strong force to keep nuclei together.");
        this.add("nuclearcraft.particle.triton.desc", "The Triton is the nucleus of a Tritium Atom.");
        this.add("nuclearcraft.particle.antitriton.desc", "The Anti-Triton is the antimatter partner of the Triton.");
        this.add("nuclearcraft.particle.helion.desc", "The Helion is the nucleus of a Helium-3 Atom.");
        this.add("nuclearcraft.particle.antihelion.desc", "The Anti-Helion is the antimatter partner of the Helion.");
        this.add("nuclearcraft.particle.boron_ion.desc", "A Boron atom with one electron missing.");
        this.add("nuclearcraft.particle.calcium_48_ion.desc", "A Calcium-48 atom with one electron missing. This is a particularly neutron rich atom useful for creating Super heavy elements.");
        this.add("nuclearcraft.particle.kaon_plus.desc", "The Kaon + is a meson with strangeness of 1.");
        this.add("nuclearcraft.particle.kaon_naught.desc", "The Kaon 0 is a meson with strangeness of 1.");
        this.add("nuclearcraft.particle.antikaon_naught.desc", "The Anti-Kaon 0 is a meson with strangeness of -1.");
        this.add("nuclearcraft.particle.kaon_minus.desc", "The Kaon - is a meson with strangeness of -1.");
        this.add("nuclearcraft.particle.eta.desc", "Eta Mesons are flavourless mesons meaning their flavor numbers like strangeness and isospin are 0.");
        this.add("nuclearcraft.particle.eta_prime.desc", "Eta Mesons are flavorless mesons meaning their flavor numbers like strangeness and isospin are 0.");
        this.add("nuclearcraft.particle.charmed_eta.desc", "Eta Mesons are flavorless mesons meaning their flavor numbers like strangeness and isospin are 0.");
        this.add("nuclearcraft.particle.bottom_eta.desc", "Eta Mesons are flavorless mesons meaning their flavor numbers like strangeness and isospin are 0.");
        this.add("nuclearcraft.particle.glueball.desc", "Glueballs are particle made entirely out of gluons.");
        this.add("nuclearcraft.particle.sigma_plus.desc", "Sigma Baryons contain one Strange Quark. They are heavier than Protons and Neutrons.");
        this.add("nuclearcraft.particle.antisigma_plus.desc", "Anti-Sigma Baryons contain one Anti-Strange Quark. They are heavier than Anti-Protons and Anti-Neutrons.");
        this.add("nuclearcraft.particle.sigma_naught.desc", "Sigma Baryons contain one Strange Quark. They are heavier than Protons and Neutrons.");
        this.add("nuclearcraft.particle.antisigma_naught.desc", "Anti-Sigma Baryons contain one Anti-Strange Quark. They are heavier than Anti-Protons and Anti-Neutrons.");
        this.add("nuclearcraft.particle.sigma_minus.desc", "Sigma Baryons contain one Strange Quark. They are heavier than Protons and Neutrons.");
        this.add("nuclearcraft.particle.antisigma_minus.desc", "Anti-Sigma Baryons contain one Anti-Strange Quark. They are heavier than Anti-Protons and Anti-Neutrons.");
        this.add("nuclearcraft.particle.delta_plus_plus.desc", "Delta ++ is a baryon containing three Up Quarks. They quickly decay via the strong force.");
        this.add("nuclearcraft.particle.antidelta_plus_plus.desc", "Anti-Delta ++ is a baryon containing three Anti-Up Quarks. They quickly decay via the strong force.");
        this.add("nuclearcraft.particle.delta_minus.desc", "Delta - is a baryon containing three Down Quarks. They quickly decay via the strong force.");
        this.add("nuclearcraft.particle.antidelta_minus.desc", "Anti-Delta - is a baryon containing three Anti-Down Quarks. They quickly decay via the strong force.");
    }

    private void messages() {
        this.add("message.nc.player_radiation_contamination", "Radiation Dose: %s");
        this.add("message.nc.debug_logging.enable", "Enabled debug logging");
        this.add("message.nc.debug_logging.disable", "Disabled debug logging");
        this.add("message.nc.geiger_radiation_measure", "Radiation Level: %s");
        this.add("death.attack.radiation", "Died of Radiation Poisoning");
        this.add("nc.message.patrons", "Special thanks to patrons: Noteclip, marcin212, PersonBelowRocks, tomdodd4598, ethantabler, endleon201, sancho.lucky, Cerusvi, tocix9730 and others...");
    }

    private void sounds() {
        this.add("music.hyperspace", "Hyperspace");
        this.add("music.end_of_the_world", "End of the World");
        this.add("music.wanderer", "Wanderer");
        this.add("music.money_for_nothing", "Money For Nothing");
        this.add("sound_event.nuclearcraft.feral_ghoul.idle", "Feral Ghoul idle");
        this.add("sound_event.nuclearcraft.feral_ghoul.death", "Feral Ghoul death");
        this.add("sound_event.nuclearcraft.item.geiger_1", "Geiger Counter Ticks Level 1 Intensity");
        this.add("sound_event.nuclearcraft.item.geiger_2", "Geiger Counter Ticks Level 2 Intensity");
        this.add("sound_event.nuclearcraft.item.geiger_3", "Geiger Counter Ticks Level 3 Intensity");
        this.add("sound_event.nuclearcraft.item.geiger_4", "Geiger Counter Ticks Level 4 Intensity");
        this.add("sound_event.nuclearcraft.item.geiger_5", "Geiger Counter Ticks Level 5 Intensity");
        this.add("sound_event.nuclearcraft.item.geiger_6", "Geiger Counter Ticks Max Intensity");
        this.add("sound_event.nuclearcraft.fusion.ready", "Fusion Reactor Ready");
        this.add("sound_event.nuclearcraft.fusion.running", "Fusion Reactor Running");
        this.add("sound_event.nuclearcraft.fusion.charging", "Fusion Reactor Charging");
        this.add("sound_event.nuclearcraft.fusion.switch", "Fusion Reactor Switch");
        this.add("sound_event.nuclearcraft.fission_reactor", "Fission Reactor Ticking");
        this.add("sound_event.nuclearcraft.turbine", "Turbine is spinning");
    }

    private void advancements() {
        this.add("advancement.nc.root", "NuclearCraft");
        this.add("advancement.nc.root.desc", "The beginning of your nuclear journey");
        this.add("advancement.nc.basic_barrel", "Basic Barrel");
        this.add("advancement.nc.basic_barrel.desc", "Got the barrel");
        this.add("advancement.nc.basic_storage_container", "Basic Storage Container");
        this.add("advancement.nc.basic_storage_container.desc", "Better than chests");
        this.add("advancement.nc.basic_voltaic_pile", "Basic Voltaic Pile");
        this.add("advancement.nc.basic_voltaic_pile.desc", "Keeping energy, just in case");
        this.add("advancement.nc.alloy_smelter", "Alloy Smelter");
        this.add("advancement.nc.alloy_smelter.desc", "Combine metals into alloys");
        this.add("advancement.nc.qnp", "QNP");
        this.add("advancement.nc.qnp.desc", "Craft a QNP for advanced excavation");
        this.add("advancement.nc.leacher", "Leacher");
        this.add("advancement.nc.leacher.desc", "Craft a Leacher to extract minerals using acids");
        this.add("advancement.nc.wasteland", "Wasteland");
        this.add("advancement.nc.wasteland.desc", "Enter the desolate Wasteland biome");
        this.add("advancement.nc.wasteland_boss", "Wasteland Conqueror");
        this.add("advancement.nc.wasteland_boss.desc", "Defeat the Boss of the Wasteland");
        this.add("advancement.nc.manufactory", "Manufactory");
        this.add("advancement.nc.manufactory.desc", "Craft a Manufactory to process ores and other materials");
        this.add("advancement.nc.isotope_separator", "Isotope Separator");
        this.add("advancement.nc.isotope_separator.desc", "Craft an Isotope Separator to separate isotopes");
        this.add("advancement.nc.assembler", "Assembler");
        this.add("advancement.nc.assembler.desc", "Craft an Assembler to create complex components");
        this.add("advancement.nc.pressurizer", "Pressurizer");
        this.add("advancement.nc.pressurizer.desc", "The compression");
        this.add("advancement.nc.decay_hastener", "Decay Hastener");
        this.add("advancement.nc.decay_hastener.desc", "C'mon, hurry up!");
        this.add("advancement.nc.chemical_reactor", "Chemical Reactor");
        this.add("advancement.nc.chemical_reactor.desc", "Mixing fuids and gases");
        this.add("advancement.nc.analyzer", "Analyzer");
        this.add("advancement.nc.analyzer.desc", "It's time to analyze");
        this.add("advancement.nc.solar_panel_basic", "Basic Solar Panel");
        this.add("advancement.nc.solar_panel_basic.desc", "Harness the power of the sun");
        this.add("advancement.nc.decay_generator", "Decay Generator");
        this.add("advancement.nc.decay_generator.desc", "Generate energy from radioactive decay");
        this.add("advancement.nc.uranium_rtg", "Uranium RTG");
        this.add("advancement.nc.uranium_rtg.desc", "Radioisotope Thermoelectric generation");
        this.add("advancement.nc.fission_reactor_controller", "Fission Reactor Controller");
        this.add("advancement.nc.fission_reactor_controller.desc", "Splitting the Atom");
        this.add("advancement.nc.irradiator", "Irradiator");
        this.add("advancement.nc.irradiator.desc", "Transforming materials with neutron flux");
        this.add("advancement.nc.chamber_terminal", "Chamber Terminal");
        this.add("advancement.nc.chamber_terminal.desc", "Can you keep that blackhole stable?");
        this.add("advancement.nc.turbine_controller", "Turbine Controller");
        this.add("advancement.nc.turbine_controller.desc", "Convert steam into energy efficiently");
        this.add("advancement.nc.fusion_core", "Fusion Core");
        this.add("advancement.nc.fusion_core.desc", "Fusing elements = energy");
        this.add("advancement.nc.research_paper", "Research Paper");
        this.add("advancement.nc.research_paper.desc", "Analyze chunks for mineral veins");
        this.add("advancement.nc.spaxelhoe_thorium", "Thorium Spaxelhoe");
        this.add("advancement.nc.spaxelhoe_thorium.desc", "Craft a multi-tool made from Thorium");
        this.add("advancement.nc.expl", "EXPL");
        this.add("advancement.nc.expl.desc", "Howbout making blackhole out of light?");
        this.add("advancement.nc.light_shielding", "Light Radiation Shielding");
        this.add("advancement.nc.light_shielding.desc", "Your first step in radiation protection");
        this.add("advancement.nc.radaway", "RadAway");
        this.add("advancement.nc.radaway.desc", "Remove radiation contamination from your body");
        this.add("advancement.nc.hazmat_mask", "Hazmat Protection");
        this.add("advancement.nc.hazmat_mask.desc", "Full-body protection against radiation exposure");
        this.add("advancement.nc.hev_helmet", "Advanced Protection");
        this.add("advancement.nc.hev_helmet.desc", "High-tech suit with enhanced radiation shielding");
    }

    private void labels() {
        this.add("multiblock.analyze.report", "Multiblock Report");
        this.add("report.nc.1.stabilizers", "Stabilizers: %s");
        this.add("report.nc.2.flux_regulators", "Flux Regulators: %s");
        this.add("report.nc.3.transformers", "Transformers: %s");
        this.add("report.nc.1.target_chamber.all_detectors", "All Detectors: %s");
        this.add("report.nc.1.target_chamber.valid_detectors", "Valid Detectors: %s");
        this.add("report.nc.1.accelerator.all_coolers", "All Coolers: %s");
        this.add("report.nc.1.accelerator.valid_coolers", "Valid Coolers: %s");
        this.add("report.nc.1.reactor_all_moderators", "All Moderators: %s");
        this.add("report.nc.2.reactor_moderators", "Valid Moderators: %s");
        this.add("report.nc.3.reactor_moderator_attachments", "Moderator Attachments: %s");
        this.add("report.nc.4.reactor_all_heat_sinks", "All Heat Sinks: %s");
        this.add("report.nc.5.reactor_heat_sinks", "Valid Heat Sinks: %s");
        this.add("report.nc.6.active_cooling_heatsinks", "Active Cooling Heat Sinks: %s");
        this.add("report.nc.7.all_irradiators", "All Irradiators: %s");
        this.add("report.nc.8.irradiators", "Valid Irradiators: %s");
        this.add("report.nc.9.ports", "Ports: %s");
        this.add("report.nc.10.reactor_fuel_cells", "Fuel Cells: %s");
        this.add("report.nc.11.has_recipe", "Has Recipe: %s");
        this.add("report.nc.multiblock_ticks_count", "Multiblock ticks: %s");
        this.add("report.nc.1.fusion_size", "Fusion Reactor Size: %s");
        this.add("report.nc.2.magnets", "Magnets: %s");
        this.add("report.nc.3.amplifiers", "RF Amplifiers: %s");
        this.add("report.nc.4.fusion_rf_amplification", "RF Amplification: %s");
        this.add("report.nc.5.casing_blocks", "Casing Blocks: %s");
        this.add("report.nc.6.connectors", "Connectors: %s");
        this.add("jei.category.nuclearcraft.multiblock_structure", "NuclearCraft Multiblocks");
        this.add("jei.recipe.nc.turbine", "Turbine");
        this.add("jei.recipe.nc.fusion_reactor", "Fusion Reactor");
        this.add("jei.recipe.nc.fission_reactor", "Fission Reactor");
        this.add("jei.recipe.nc.target_chamber", "Target Chamber");
        this.add("jei.recipe.nc.linear_accelerator", "Linear Accelerator");
        this.add("jei.recipe.nc.kugelblitz_chamber", "Kugelblitz Chamber");
        this.add("jei.recipe.nc.leacher", "Leacher Setup");
        this.add("jei.info.nuclearcraft.kugelblitz.description", "Kugelblitz chamber allows to transform items using black hole quantum fields.");
        this.add("jei.info.nuclearcraft.kugelblitz.problem", "The problem is, we don't know transformation recipes, we can only know what it can produce.");
        this.add("jei.info.nuclearcraft.kugelblitz.input_output", "What kugelblitz transformation produce is what it can take as input");
        this.add("entity.minecraft.villager.nuclearcraft.nuclear_scientist", "Nuclear Scientist");
        this.add("block.nuclearcraft.expl", "EXPL");
        this.add("gui.nuclearcraft:button.burst", "Activate");
        this.add("nc.guide_book.name", "NuclearCraft Guide");
        this.add("nc.guide_book.desc", "Basics and advanced topics about NuclearCraft");
        this.add("nc.guide_book.edition", "Neoteric Edition");
        this.add("fusion_core.rf_amplifiers.power", "RF Amplifiers: %s%%");
        this.add("fusion_core.rf_amplifiers.adjustment", "RF Adjustment: %s%%");
        this.add("fusion_core.stability", "Plasma Stability: %s%%");
        this.add("nc.label.leacher_wrong_position", "Wrong Position");
        this.add("nc.label.leacher_no_source", "No Data Source");
        this.add("nc.label.leacher_no_acid", "No Acid");
        this.add("block.nuclearcraft.glowing_mushroom", "Glowing Mushroom");
        this.add("fusion_core", "Fusion Reactor Core");
        this.add("fusion_core.efficiency", "Efficiency: %s%%");
        this.add("nc_jei_cat.accelerator_coolant", "Accelerator Coolant");
        this.add("nc_jei_cat.fusion_core", "Fusion Reactor");
        this.add("nc_jei_cat.target_chamber", "Target Chamber");
        this.add("nc_jei_cat.kugelblitz_chamber", "Quantum Transformation");
        this.add("nc_jei_cat.turbine", "Turbine");
        this.add("nc_jei_cat.fusion_coolant", "Fusion Reactor Coolant");
        this.add("nc_jei_cat.mek_chemical_conversion", "NC - GAS -> Fluid Conversion");
        this.add("nc_jei_cat.fission_boiling", "Boiling Reactor");
        this.add("label.kugelblitz.stability", "Stability: %s%%");
        this.add("label.kugelblitz.charge", "Charge: %s");
        this.add("label.kugelblitz.evaporation", "Evaporation Rate: %s");
        this.add("label.kugelblitz.blackhole_mass", "Blackhole Mass: %s");
        this.add("label.kugelblitz.frequency", "Quantum Frequency: %s");
        this.add("label.kugelblitz.transformation", "Transformation");
        this.add("label.kugelblitz.feeding", "Feeding Rate: %s");
        this.add("label.kugelblitz.energy_gen", "FE Gen");
        this.add("tooltip.nc.structure.size", "Structure size: %sx%sx%s");
        this.add("fission.casing.wrong.block", "Wrong block at: %s");
        this.add("fission_reactor.efficiency", "Efficiency: %s%%");
        this.add("fission_reactor.net_heat", "Net Heat: %s H/t");
        this.add("fission.casing.reactor_incomplete", "Reactor Incomplete");
        this.add("fission_reactor.heat_multiplier", "Heat Multiplier: %sx");
        this.add("turbine.efficiency", "Efficiency: %s%%");
        this.add("turbine.real_flow", "Real Flow: %smB");
        this.add("turbine.ratio", "Pressure: %s%%");
        this.add("processor_side_config.title", "Select Slot");
        this.add("processor_slot_mode.title", "Slot Mode");
        this.add("commands.nuclearcraft.no_permission", "No permissions");
        this.add("message.heat_sink.valid0", "This one is looking good");
        this.add("message.heat_sink.valid1", "I like this one");
        this.add("message.heat_sink.valid2", "This heat sink design shows promise");
        this.add("message.heat_sink.valid3", "The heat dissipation capability looks good");
        this.add("message.heat_sink.valid4", "The thermal conductivity appears to be efficient");
        this.add("message.heat_sink.valid5", "Attention to detail is evident in this design");
        this.add("message.heat_sink.valid6", "This heat sink design seems promising for our project");
        this.add("message.heat_sink.valid7", "Attention to detail is impressive");
        this.add("message.heat_sink.valid8", "This is a perfect fit for our application");
        this.add("message.heat_sink.valid9", "This meets our standards very well");
        this.add("message.heat_sink.invalid0", "Not sure if it's valid");
        this.add("message.heat_sink.invalid1", "Maybe you should check it again");
        this.add("message.heat_sink.invalid2", "Hm...");
        this.add("message.heat_sink.invalid3", "Will it explode? -Shouldn't");
        this.add("message.heat_sink.invalid4", "This doesn't seem to meet our standards.");
        this.add("message.heat_sink.invalid5", "There are some concerns about the validity of this.");
        this.add("message.heat_sink.invalid6", "I have some reservations about this.");
        this.add("message.heat_sink.invalid7", "This may not be suitable for our project.");
        this.add("message.heat_sink.invalid8", "This may need some significant revisions before it can be considered valid.");
        this.add("message.heat_sink.invalid9", "More work may be needed before this can be considered valid.");
        this.add("nc_jei_cat.fission_reactor_controller", "Fission Reactor Fuel Depletion");
        this.add("nc_jei_cat.nc_ore_veins", "Ore Veins");
        this.add("container.nc.storage", "Item Storage Container");
    }

    private void multiblocks() {
        Object title;
        String prefix = "";
        for (String name : AcceleratorRegistration.ACCELERATOR_BLOCKS.keySet()) {
            prefix = "";
            if (name.contains("cooler")) {
                prefix = "Accelerator ";
            }
            title = TextUtils.convertToName(name);
            if (name.contains("ring")) {
                title = "(WIP) " + (String)title;
            }
            this.add((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get(name).get(), prefix + (String)title);
        }
        for (String name : TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.keySet()) {
            title = TextUtils.convertToName(name);
            if (TargetChamberRegistration.TARGET_CHAMBER_DETECTORS.containsKey(name)) {
                title = (String)title + " Detector";
            }
            this.add((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get(name).get(), (String)title);
        }
        for (String name : KugelblitzRegistration.KUGELBLITZ_BLOCKS.keySet()) {
            title = TextUtils.convertToName(name);
            this.add((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get(name).get(), (String)title);
        }
        for (String name : FissionReactorRegistration.FISSION_BLOCKS.keySet()) {
            prefix = "";
            if (name.contains("heat_sink")) {
                prefix = "Fission Reactor ";
            }
            title = TextUtils.convertToName(name);
            this.add((Block)FissionReactorRegistration.FISSION_BLOCKS.get(name).get(), prefix + (String)title);
        }
        for (String name : TurbineRegistration.TURBINE_BLOCKS.keySet()) {
            title = TextUtils.convertToName(name);
            this.add((Block)TurbineRegistration.TURBINE_BLOCKS.get(name).get(), (String)title);
        }
        for (String name : FusionReactorRegistration.FUSION_BLOCKS.keySet()) {
            title = TextUtils.convertToName(name);
            this.add((Block)FusionReactorRegistration.FUSION_BLOCKS.get(name).get(), (String)title);
        }
        this.add((Block)FusionReactorRegistration.FUSION_CORE_PROXY.get(), "Fusion Reactor Core");
        this.add((Block)KugelblitzRegistration.EXPL_PROXY_BLOCK.get(), "EXPL");
    }

    private void storageBlocks() {
        for (String name : NCStorageBlocks.STORAGE_BLOCKS.keySet()) {
            String title = TextUtils.convertToName(name);
            this.add((Block)NCStorageBlocks.STORAGE_BLOCKS.get(name).get(), title);
        }
    }

    private void energyBlocks() {
        for (String name : NCEnergyBlocks.ENERGY_BLOCKS.keySet()) {
            String title = TextUtils.convertToName(name);
            this.add((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), title);
        }
    }

    private void processors() {
        for (String name : NCProcessors.PROCESSORS.keySet()) {
            String title = TextUtils.convertToName(name);
            this.add((Block)NCProcessors.PROCESSORS.get(name).get(), title);
            this.add("nc_jei_cat." + name, title);
        }
    }

    private void buckets() {
        for (String name : NCFluids.NC_MATERIALS.keySet()) {
            String molten = "";
            if (NCItems.NC_INGOTS.containsKey(name)) {
                molten = "Molten ";
            }
            this.add((Item)NCFluids.NC_MATERIALS.get(name).getBucket(), "Bucket of " + molten + TextUtils.convertToName(name));
        }
        for (String name : NCFluids.NC_GASES.keySet()) {
            this.add((Item)NCFluids.NC_GASES.get(name).getBucket(), "Bucket of " + TextUtils.convertToName(name));
        }
    }

    private void fluids() {
        for (String name : NCFluids.NC_MATERIALS.keySet()) {
            String molten = "";
            if (NCItems.NC_INGOTS.containsKey(name)) {
                molten = "Molten ";
            }
            this.add("fluid_type." + NCFluids.NC_MATERIALS.get(name).type().getId().m_214298_(), molten + TextUtils.convertToName(name));
        }
        for (String name : NCFluids.NC_GASES.keySet()) {
            this.add("fluid_type." + NCFluids.NC_GASES.get(name).type().getId().m_214298_(), TextUtils.convertToName(name));
        }
    }

    private void shielding() {
        for (String name : NCItems.NC_SHIELDING.keySet()) {
            this.add((Item)NCItems.NC_SHIELDING.get(name).get(), TextUtils.convertToName(name) + " Shielding");
        }
    }

    private void tooltips() {
        this.add("tooltip.nc.decay_generator_allowed.desc", "Can be used with Decay Generator");
        this.add("tooltip.nc.energy_eu_tier.depends_on_terminal", "EU Tier inherits Tier from Terminal");
        this.add("tooltip.nc.energy_eu_tier.depends_on_controller", "EU Tier inherits Tier from Controller");
        this.add("tooltip.nc.wasteland.disabled", "Wasteland dimension is disabled");
        this.add("tooltip.nc.wasteland.portal.descr", "Teleport to Wasteland dimension");
        this.add("tooltip.ion_source.particle", "Particle: %s");
        this.add("tooltip.nc.expl", "Produce powerful beam of light. Shooting 6 beams into single point can create black hole inside Kugelblitz Chamber.");
        this.add("tooltip.nc.magnet.disable", "Disable Auto-pickup");
        this.add("tooltip.nc.magnet.enable", "Enable Auto-pickup");
        this.add("tooltip.ion_source.amount", "Amount: %spu / %spu");
        this.add("tooltip.target_chamber.detectors", "Detectors: %s");
        this.add("tooltip.detector.distance", "Max distance to chamber camera: %s");
        this.add("tooltip.detector.power", "FE required: %s/t");
        this.add("tooltip.detector.efficiency", "Efficiency: %s%%");
        this.add("tooltip.structure.sizes", "Structure sizes: Min %s - Max: %s");
        this.add("tooltip.turbine.max_eu_energy", "Max EU gen: %s");
        this.add("tooltip.nc.particle_beam.desc", "Forms the central beam line for particle accelerators.");
        this.add("tooltip.turbine.max_energy", "Max FE gen: %s");
        this.add("tooltip.nc.report_issue", "Copy link to post a bug");
        this.add("tooltip.nc.accelerator.strength", "Magnet Strength: %s T");
        this.add("tooltip.nc.accelerator.efficiency", "Efficiency: %s");
        this.add("tooltip.nc.accelerator.focus", "Focus: %s");
        this.add("tooltip.nc.accelerator.quadroupoles", "Quadrupoles: %s");
        this.add("tooltip.nc.accelerator.dipoles", "Dipoles: %s");
        this.add("tooltip.nc.accelerator.voltage", "Voltage: %sV");
        this.add("tooltip.nc.accelerator.amplifiers", "Amplifiers: %s");
        this.add("tooltip.nc.accelerator.coolers", "Coolers: %s");
        this.add("tooltip.nc.max_fe_extract_per_tick", "FE/t output: %s");
        this.add("tooltip.nc.upgrade_energy.tier", "+1 Energy Tier for every %s Upgrades");
        this.add("tooltip.nc.eu_energy_stored", "EU Stored: %s / %s");
        this.add("tooltip.nc.energy_base_eu_tier", "Base EU Tier: %s");
        this.add("tooltip.nc.energy_eu_tier", "EU Tier: %s");
        this.add("tooltip.nc.energy_eu_capacity", "EU Capacity: %s");
        this.add("tooltip.nc.energy_eu_generation", "EU Generation: %s/t");
        this.add("tooltip.nc.eu_amplifier.power", "EU Required: %s/t");
        this.add("tooltip.nc.build", "Build Multiblock");
        this.add("tooltip.nc.paste_json", "Paste JSON");
        this.add("tooltip.nc.paste_json.descr", "File content or file itself");
        this.add("tooltip.nc.wiki", "Open WIKI");
        this.add("tooltip.nc.link.designs", "Reactor Bots Discord");
        this.add("tooltip.nc.link.designs.descr", "Place where you can generate reactors");
        this.add("tooltip.nuclearcraft.particlestack.name", "Type: %s");
        this.add("tooltip.nuclearcraft.particlestack.amount", "Amount: %s");
        this.add("tooltip.nuclearcraft.particlestack.mean_energy", "Energy: %s");
        this.add("tooltip.nuclearcraft.particlestack.focus", "Focus: %s");
        this.add("tooltip.nuclearcraft.particlestack.focus_loss", "Focus Loss: %s/Block");
        this.add("tooltip.nuclearcraft.particlestack.travel_distance", "Travel Distance: %s Blocks");
        this.add("tooltip.nuclearcraft.particlestack.empty", "No Particles");
        this.add("tooltip.nc.analyze", "Analyze structure");
        this.add("tooltip.nc.analyze.descr", "Refresh multiblock data, analyze and provide more details");
        this.add("multiblock.build_in_chunk.advise", "Consider building structure within one chunk for better performance");
        this.add("decay_generator.fe_generation", "Result FE generation depends on attached blocks radiation");
        this.add("tooltip.nc.lightning_rod_charge", "Can charge NC Energy blocks by %s FE");
        this.add("tooltip.nc.jei.gas_to_fluid.desc", "NC blocks automatically converts Mek Gasses into Fluids during input");
        this.add("tooltip.nc.hev.desc", "Grants additional protection and passive effects when charged");
        this.add("tooltip.nc.moderator.desc", "Fission Reactor moderator. Has to be placed next to fuel cell. \n Each adjacent with fuel cell adds +%s%% efficiency and +%s%% heat gen");
        this.add("boiling.recipe.heat_required", "Heat required: %s H");
        this.add("tooltip.active_heatsink", "Needs coolant fluid supply into reactor to work.");
        this.add("tooltip.kugelblitz.stability_info", "You can stabilize blackhole with EXPL lasers burst. \n On low values blackhole vibrates at 15 level.");
        this.add("tooltip.kugelblitz.photon_concentrator", "Concentrates photons into a single point. \n Need to be placed at center of all 6 chamber walls.");
        this.add("tooltip.kugelblitz.ready_for_burst", "Ready for Laser Burst");
        this.add("tooltip.kugelblitz.flux_regulators", "Flux Regulators: %s");
        this.add("tooltip.kugelblitz.transformers", "Quantum Transformers: %s");
        this.add("tooltip.kugelblitz.stabilizers", "Stabilizers: %s");
        this.add("tooltip.kugelblitz.block_neutronium_frame", "Casing block of Kugelblitz Chamber");
        this.add("tooltip.kugelblitz.block_event_horizon_stabilizer", "Helps to stabilize blackhole");
        this.add("tooltip.kugelblitz.block_quantum_flux_regulator", "Increases FE generation of Kugelblitz Chamber");
        this.add("tooltip.kugelblitz.block_quantum_transformer", "Increases Quantum Transformation rate of Kugelblitz Chamber");
        this.add("tooltip.upgrade_stack", "Improved speed upgrade with parallel processing");
        this.add("tooltip.upgrade_speed", "Increases recipe speed and energy consumption");
        this.add("tooltip.upgrade_energy", "Reduce energy consumption and increase energy buffer");
        this.add("processor.recipe.power", "Process Power: %s FE/t");
        this.add("processor.recipe.duration", "Process Duration: %s t");
        this.add("processor.recipe.radiation", "Process Radiation: %s uRad");
        this.add("fusion_core.charge", "Charging: %s%%");
        this.add("fusion_core.recipe.cooling_rate", "Cooling Rate: %s H");
        this.add("fusion_core.recipe.power", "Base Energy Generation: %s FE/t");
        this.add("fusion_core.recipe.duration", "Reaction Duration: %s t");
        this.add("fusion_core.recipe.radiation", "Reaction Radiation: %s uRad");
        this.add("fusion_core.recipe.temperature", "Optimal Temperature: %s MK");
        this.add("fission.recipe.power", "Base Energy Generation: %s FE/t");
        this.add("fission.recipe.duration", "Depletion Time: %s s");
        this.add("fission.recipe.radiation", "Reaction Radiation: %s pRad");
        this.add("fission.recipe.heat", "Heat Generation: %s H/t");
        this.add("gui.nc.kugelblits_port.tooltip_1", "Comparator: FE Gen");
        this.add("gui.nc.kugelblits_port.tooltip_2", "Comparator: Mass");
        this.add("gui.nc.kugelblits_port.tooltip_3", "Comparator: Transformation Progress");
        this.add("gui.nc.kugelblits_port.tooltip_4", "Comparator: Inventory Size");
        this.add("gui.nc.kugelblits_port.tooltip_5", "Input: Quantum Frequency");
        this.add("gui.nc.kugelblits_port.tooltip_6", "Input: FE Gen vs Transformation rate");
        this.add("gui.nc.kugelblits_port.tooltip_strength", "Signal strength: %s");
        this.add("gui.nc.reactor_mode.tooltip_steam", "Boiling Mode");
        this.add("gui.nc.reactor_mode.tooltip_energy", "Energy Mode");
        this.add("gui.nc.reactor_mode.timer", "Changing mode in: %s sec");
        this.add("reactor.steam_per_tick", "Boiling rate: %s mB/t");
        this.add("reactor.max_boiling_rate", "Max rate: %s mB/t");
        this.add("nc.redstone_dimmer.description", "Adjusts redstone output power based on impulses received from the left or right sides.");
        this.add("nc.multiblock_builder.description", "For automated building.");
        this.add("tooltip.nc.fusion_connector.descr", "Used to connect fusion core and toroidal reactor chamber");
        this.add("tooltip.nc.fusion_casing.descr", "Used to build toroidal fusion reactor chamber");
        this.add("tooltip.nc.rf_amplifier.not_found", "No RF Amplifiers attached");
        this.add("tooltip.nc.rf_amplifier.power", "Energy Required: %s FE/t");
        this.add("tooltip.nc.rf_amplifier.voltage", "Amplification: %s V");
        this.add("tooltip.nc.rf_amplifier.efficiency", "Efficiency: %s%%");
        this.add("tooltip.nc.rf_amplifier.heat", "Heat: %s H/t");
        this.add("tooltip.nc.rf_amplifier.max_temp", "Max Temperature: %s K");
        this.add("tooltip.nc.reactor.charge", "Charged: %s");
        this.add("tooltip.nc.reactor.running", "Activation: %s");
        this.add("tooltip.nc.reactor.has_magnets", "Electromagnets: %s");
        this.add("tooltip.nc.reactor.has_amplifiers", "RF Amplifiers: %s");
        this.add("tooltip.nc.reactor.has_coolant", "Coolant: %s");
        this.add("tooltip.nc.reactor.has_energy", "Energy: %s");
        this.add("tooltip.nc.reactor.has_fuel", "Fuel: %s");
        this.add("tooltip.nc.reactor.ready", "Ready");
        this.add("tooltip.nc.reactor.not_ready", "Not Ready");
        this.add("tooltip.nc.show_recipes", "Show Recipes");
        this.add("gui.nc.fluid_tank_renderer.can_void", "SHIFT+Mouse 1 to void content");
        this.add("tooltip.nc.electromagnet.not_found", "No Electromagnets attached");
        this.add("tooltip.nc.electromagnet.power", "Energy Required: %s FE/t");
        this.add("tooltip.nc.electromagnet.magnetic_field", "Magnetic Field: %s T");
        this.add("tooltip.nc.description.efficiency", "Efficiency: %s%%");
        this.add("tooltip.nc.description.expansion", "Expansion: %s%%");
        this.add("tooltip.nc.electromagnet.heat", "Heat: %s H/t");
        this.add("tooltip.nc.electromagnet.max_temp", "Max Temparature: %s K");
        this.add("tooltip.nc.blade.desc", "Converts the energy of the oncoming fluid flow into rotational energy in the rotor shaft. The expansion coefficient is larger than unity, so the volume of the fluid flow will increase each time it passes through a set. Must be placed in complete sets of four coplanar groups extending from the turbine shaft to the wall. Each blade block can process up to %s of oncoming fluid.");
        this.add("tooltip.nc.rotor_shaft.desc", "Connects the rotor blades to the dynamo to convert the generated kinetic energy into electrical energy. Must be placed axially as a cuboid along the centre of the turbine interior.");
        this.add("tooltip.nc.bearing.desc", "Connects the rotor shaft to the turbine wall and dynamo. Must cover the full area of each end of the shaft.");
        this.add("turbine.active.coils", "Active coils: %s");
        this.add("turbine.blades.flow", "Max steam flow: %s mB/t");
        this.add("tooltip.nc.liquid_empty", "Stored: 0 of %s");
        this.add("tooltip.nc.liquid_stored", "Stored: %s %s / %s");
        this.add("tooltip.nc.liquid_capacity", "Capacity: %s");
        this.add("effect.nuclearcraft.radiation_resistance", "Radiation Resistance");
        this.add("effect.nuclearcraft.radiation_decay", "Radiation Decay");
        this.add("leacher.tooltip.valid_pump", "Pump - Ok");
        this.add("leacher.tooltip.invalid_pump", "Pump in the corner not found");
        this.add("tooltip.nc.target_chamber.camera", "Center of Target Chamber structure");
        this.add("processor.description.nuclear_furnace", "Fast furnace what uses uranium ingots as fuel.");
        this.add("processor.description.alloy_smelter", "Smelts and alloys items.");
        this.add("processor.description.centrifuge", "Separates fluids into their components.");
        this.add("processor.description.fuel_reprocessor", "Separates depleted fuel into components.");
        this.add("processor.description.melter", "Melts items into liquids.");
        this.add("processor.description.ingot_former", "Forms solid items from molten liquids.");
        this.add("processor.description.crystallizer", "Grows crystals from solutions.");
        this.add("processor.description.chemical_reactor", "Mixes fluids and gases together.");
        this.add("processor.description.assembler", "Machine what assembles items.");
        this.add("processor.description.decay_hastener", "Accelerates decay speed of radioactive materials.");
        this.add("processor.description.electrolyzer", "Separates fluids and gases into their components.");
        this.add("processor.description.extractor", "Extracts liquids from solid items.");
        this.add("processor.description.fluid_enricher", "Enriches fluids and gases with solid items.");
        this.add("processor.description.fluid_infuser", "Mixes fluids with items to get new items.");
        this.add("processor.description.irradiator", "Transform items and fluids with the power of Radiative Flux. Needs to be placed in reactor's wall.");
        this.add("processor.description.isotope_separator", "Splits items into isotopes.");
        this.add("processor.description.manufactory", "Crushes items into dusts and other materials.");
        this.add("processor.description.pressurizer", "Compresses items with high pressure.");
        this.add("processor.description.rock_crusher", "Produces dusts from rocks.");
        this.add("processor.description.supercooler", "Cools down fluids and gases.");
        this.add("processor.description.steam_turbine", "Produce energy with power of steam.");
        this.add("processor.description.gas_scrubber", "\u0421leansing ventilation.");
        this.add("processor.description.pump", "Pumps fluids and gasses from environment.");
        this.add("processor.description.analyzer", "Used to analyze environment and items.");
        this.add("processor.description.leacher", "Leaches undeground minerals with acids and pumps slurry back.");
        this.add("processor.description.subatomic_liquifier", "Decompose elements.");
        this.add("amount", "Amount: %s");
        this.add("sound_event.nuclearcraft.item.charged", "Item Charged");
        this.add("tooltip.nc.analyzed", "Item analyze completed");
        this.add("tooltip.nc.shielding.desc", "Combine with armor in crafting grid");
        this.add("tooltip.nc.rad_shielding", "Rad Shielding LVL: %s");
        this.add("tooltip.nc.use_in_leacher", "Item can be used in Leacher");
        this.add("tooltip.nc.energy_stored", "Energy Stored: %s / %s");
        this.add("tooltip.nc.energy_capacity", "Energy Capacity: %s");
        this.add("tooltip.nc.radiation", "Radiation: %s");
        this.add("tooltip.nc.radiation_removal", "Removes Radiation: %s");
        this.add("tooltip.toggle_description_keys", "Toggle description: CTRL+N");
        this.add("fuel.heat.descr", "Base Heat Gen: %s H/t");
        this.add("message.nc.battery.side_config", "Mode: %s");
        this.add("message.nc.switch_side.mode", "Mode: %s");
        this.add("gui.nc.reactor_comparator_config.tooltip_1", "Comparator: Energy Stored");
        this.add("gui.nc.turbine_comparator_config.tooltip_0", "Comparator: Energy Stored");
        this.add("gui.nc.turbine_comparator_config.tooltip_2", "Comparator: Overflow");
        this.add("gui.nc.reactor_comparator_config.tooltip_2", "Comparator: Heat Stored");
        this.add("gui.nc.reactor_comparator_config.tooltip_3", "Comparator: Depletion Progress");
        this.add("gui.nc.reactor_comparator_config.tooltip_4", "Comparator: Fuel Left");
        this.add("gui.nc.reactor_comparator_config.tooltip_5", "Input: On/Off Reactor");
        this.add("gui.nc.reactor_comparator_config.tooltip_6", "Input: Moderation Control");
        this.add("gui.nc.reactor_comparator_config.tooltip_11", "Comparator: Energy Stored");
        this.add("gui.nc.reactor_comparator_config.tooltip_12", "Comparator: Heat Stored");
        this.add("gui.nc.reactor_comparator_config.tooltip_13", "Comparator: Efficiency");
        this.add("gui.nc.reactor_comparator_strength.tooltip", "Current Signal Strength: %s");
        this.add("gui.nc.redstone_config.tooltip_0", "WORK MODE: IGNORE SIGNAL");
        this.add("gui.nc.redstone_config.tooltip_1", "WORK MODE: ON SIGNAL");
        this.add("gui.nc.fluid_tank_renderer.amount_capacity", "%s/%s mB");
        this.add("gui.nc.fluid_tank_renderer.amount", "%s mB");
        this.add("fuel.forge_energy.descr", "Forge Energy: %s FE/t");
        this.add("rtg.fe_generation", "Energy Generation: %s FE/t");
        this.add("tooltip.nc.shift_rbm_to_change", "Sneak+Use to change");
        this.add("tooltip.nc.qnp_mode", "Mode: %s");
        this.add("tooltip.mode.one_block", "One Block");
        this.add("tooltip.mode.3x3", "3x3");
        this.add("tooltip.mode.3x3x3", "3x3x3");
        this.add("tooltip.mode.5x5", "5x5");
        this.add("tooltip.mode.vein", "Vein");
        this.add("tooltip.nc.chunk_position", "Chunk Position: %s");
        this.add("nc.ore_vein.borax", "Vein of Borax");
        this.add("nc.ore_vein.bornite", "Vein of Bornite");
        this.add("nc.ore_vein.cassiterite", "Vein of Cassiterite");
        this.add("nc.ore_vein.cobaltite", "Vein of Cobaltite");
        this.add("nc.ore_vein.magnesite", "Vein of Magnesite");
        this.add("nc.ore_vein.platinum", "Vein of Platinum");
        this.add("nc.ore_vein.sphalerite", "Vein of Sphalerite");
        this.add("nc.ore_vein.spodumene", "Vein of Spodumene");
        this.add("nc.ore_vein.uraninite", "Vein of Uraninite");
        this.add("nc.ore_vein.none", "Veins not found");
        this.add("nc.ore_vein.mixed", "Vein of Mixed minerals");
        this.add("tooltip.nc.content_saved", "Content Saved");
        this.add("fuel.heat_boiling.descr", "Boiling Reactor Heat: %s H/t");
        this.add("fuel.depletion.descr", "Base Depletion Time: %s sec");
        this.add("fuel.criticality.descr", "Criticality Factor: %s N/t");
        this.add("fuel.efficiency.descr", "Base Efficiency: %s%%");
        this.add("fuel.description", "Used in Fission Reactors. Use Fuel Ports to Load/Unload. \r\nActual FE generation depends on Reactor Efficiency.");
        this.add("heat_sink.heat.descr", "Cooling Rate: %s H/t");
        this.add("heat_sink.placement.rule", "Must be placed %s");
        this.add("heat_sink.between", "between %s %s");
        this.add("heat_sink.atleast", "next to at least %s %s");
        this.add("heat_sink.atleasts", "next to at least %s %s blocks");
        this.add("heat_sink.exact", "next to exactly %s %s");
        this.add("heat_sink.exacts", "next to exactly %s %s blocks");
        this.add("heat_sink.less_than", "next to less than %s %s");
        this.add("heat_sink.in_corner", "in the corner of %s %s blocks");
        this.add("heat_sink.or", "or");
        this.add("heat_sink.and", "and");
        this.add("heat_sink.placement.error", "Error during placement rule generation");
        this.add("multiblock.interior.complete", "Interior Complete");
        this.add("multiblock.interior.incomplete", "Interior Incomplete");
        this.add("multiblock.casing.complete", "Multiblock Casing Complete");
        this.add("multiblock.casing.incomplete", "Multiblock Casing Incomplete");
        this.add("energy.bar.amount", "Total FE: %s / %s");
        this.add("tooltip.eu.bar.amount", "Total EU: %s / %s");
        this.add("reactor.internal_usage", "Internal usage: %s FE/t");
        this.add("coolant.bar.amount", "Coolant: %s / %s mB");
        this.add("hot_coolant.bar.amount", "Heated Coolant: %s / %s mB");
        this.add("heat.bar.amount", "Total Heat: %s / %s K");
        this.add("tooltip.nc.reactor.plasma_heat", "Plasma Heat: %s K");
        this.add("tooltip.nc.reactor.plasma_optimal", "Optimal: %s K");
        this.add("tooltip.machine.progress", "Progress: %s%%");
        this.add("reactor.fuel_cells", "Fuel Cells: %s");
        this.add("reactor.irradiators_connections", "Irradiation lines: %s");
        this.add("fission.interior.no_fuel_cells", "No Fuel Cells Found");
        this.add("fission.interior.no_moderators", "No Moderators Found");
        this.add("fission.interior.no_heat_sink", "No Heat Sinks Found");
        this.add("tooltip.nc.use_multitool", "Use Multitool to config sides");
        this.add("tooltip.nc.multitool.desc", "Commonly used to config sides of batteries, barrels, ports...");
        this.add("tooltip.nc.multitool.shift.desc", "Sneak + RBM to config back side");
        this.add("side_config.up", "UP: ");
        this.add("side_config.down", "DOWN: ");
        this.add("side_config.left", "LEFT: ");
        this.add("side_config.right", "RIGHT: ");
        this.add("side_config.front", "FRONT: ");
        this.add("side_config.back", "BACK: ");
        this.add("side_config.input", "INPUT");
        this.add("side_config.pull", "PULL");
        this.add("side_config.output", "OUTPUT");
        this.add("side_config.push", "PUSH");
        this.add("side_config.push_excess", "PUSH EXCESS");
        this.add("side_config.disabled", "DISABLED");
        this.add("side_config.default", "DEFAULT");
        this.add("gui.nc.side_config.tooltip", "Side Config");
        this.add("speed.parallel_processing", "Parallel processing: x%s");
        this.add("speed.multiplier", "Speed Multiplier: x%s");
        this.add("energy.multiplier", "Energy Multiplier: x%s");
        this.add("tooltip.nc.energy.per_tick", "Energy Per Tick: %s FE/t");
        this.add("tooltip.eu.tier", "Energy Tier: %s");
        this.add("tooltip.eu.per_tick", "Energy Per Tick: %s EU/t");
        this.add("reactor.cooling", "Cooling: %s H/t");
        this.add("reactor.heating", "Heat Gen: %s H/t");
        this.add("reactor.net_heat", "Net Heat: %s H/t");
        this.add("reactor.boiling_penalty", "Boiling Penalty: %s H/t");
        this.add("tooltip.nc.forge_energy_per_tick", "FE Gen: %s FE/t");
        this.add("tooltip.nc.eu_per_tick", "EU Gen: %s EU/t");
        this.add("reactor.heat_sinks_count", "Active Heat Sinks: %s");
        this.add("reactor.moderators_count", "Active Moderators: %s");
        this.add("reactor.moderation_level", "Moderation Level: %s%%");
        this.add("reactor.reactivity", "Reactivity: %s%%");
        this.add("validation.structure.too_big", "Structure is too big");
        this.add("validation.structure.too_small", "Structure is too small");
        this.add("validation.structure.incomplete", "Incomplete");
        this.add("validation.structure.wrong_outer", "Wrong Casing at: %s");
        this.add("validation.structure.wrong_inner", "Wrong Block at: %s");
        this.add("validation.structure.too_many_controllers", "Too many controllers");
        this.add("validation.structure.no_controller", "No controllers");
        this.add("validation.structure.no_port", "No port found");
        this.add("validation.structure.valid", "Structure is Valid");
        this.add("validation.structure.wrong_corner", "Wrong corner block at: %s");
        this.add("validation.structure.wrong_proportions", "Wrong proportions");
        this.add("validation.structure.wrong_blades", "Wrong blades placement");
        this.add("validation.structure.photon_concentrator", "Incorrect Photon Concentrators placement");
        this.add("validation.structure.asymetric_walls", "Walls are asymetric");
        this.add("solar_panel.fe_generation", "Daytime Gen: %s FE/t");
        this.add("fission_port.descr", "One port for everything: Fluids, items, redstone, computers, etc...");
        this.add("irradiation_chamber.descr", "Irradiates items with neutron flux. \r\nHas to be placed in one line with moderator and fuel cell behind it.");
    }

    private void fuel() {
        for (List<String> name : FissionFuel.NC_FUEL.keySet()) {
            this.add((Item)FissionFuel.NC_FUEL.get(name).get(), TextUtils.convertToName(name.get(0)) + " " + TextUtils.convertToName(name.get(1)) + " " + name.get(2).toUpperCase() + " " + name.get(3).toUpperCase());
        }
        for (List<String> name : FissionFuel.NC_DEPLETED_FUEL.keySet()) {
            this.add((Item)FissionFuel.NC_DEPLETED_FUEL.get(name).get(), TextUtils.convertToName(name.get(0)) + " " + TextUtils.convertToName(name.get(1)) + " " + name.get(2).toUpperCase() + " " + name.get(3).toUpperCase());
        }
    }

    private void ores() {
        for (String ore : NCBlocks.ORE_BLOCKS.keySet()) {
            this.add((Block)NCBlocks.ORE_BLOCKS.get(ore).get(), TextUtils.convertToName(ore) + " Ore");
        }
    }

    private void items() {
        for (String name : NCItems.NC_ITEMS.keySet()) {
            this.add((Item)NCItems.NC_ITEMS.get(name).get(), TextUtils.convertToName(name));
        }
        this.add("item.nuclearcraft.feral_ghoul_spawn_egg", "Feral Ghoul Spawn Egg");
        this.add("item.nuclearcraft.wanderer.desc", "Wanderer");
        this.add("item.nuclearcraft.end_of_the_world.desc", "End of the World");
        this.add("item.nuclearcraft.hyperspace.desc", "Hyperspace");
        this.add("item.nuclearcraft.money_for_nothing.desc", "Money For Nothing");
    }

    private void waste() {
        for (String name : FissionFuel.NC_WASTE.keySet()) {
            this.add((Item)FissionFuel.NC_WASTE.get(name).get(), TextUtils.convertToName(name));
        }
    }

    private void isotopes() {
        for (String name : FissionFuel.NC_ISOTOPES.keySet()) {
            this.add((Item)FissionFuel.NC_ISOTOPES.get(name).get(), TextUtils.convertToName(name));
        }
    }

    private void particleSources() {
        for (String name : NCItems.ION_SOURCES.keySet()) {
            this.add((Item)NCItems.ION_SOURCES.get(name).get(), TextUtils.convertToName(name));
        }
    }

    private void records() {
        for (String name : NCItems.NC_RECORDS.keySet()) {
            this.add((Item)NCItems.NC_RECORDS.get(name).get(), TextUtils.convertToName(name));
        }
    }

    private void tools() {
        this.add((Item)NCItems.QNP.get(), "QNP");
        this.add((Item)NCItems.MULTITOOL.get(), "Multitool");
        this.add((Item)NCItems.GEIGER_COUNTER.get(), "Geiger Counter");
        this.add((Item)NCItems.SPAXELHOE_THORIUM.get(), "Thorium Spaxel");
        this.add((Item)NCItems.SPAXELHOE_TOUGH.get(), "Tough Spaxel");
        this.add((Item)NCItems.LITHIUM_ION_CELL.get(), "Lithium Ion Cell");
    }

    private void armor() {
        this.add((Item)NCItems.TOUGH_HELMET.get(), "Tough Helmet");
        this.add((Item)NCItems.TOUGH_PANTS.get(), "Tough Pants");
        this.add((Item)NCItems.TOUGH_BOOTS.get(), "Tough Boots");
        this.add((Item)NCItems.TOUGH_CHEST.get(), "Tough Chest");
        this.add((Item)NCItems.HEV_HELMET.get(), "HEV Helmet");
        this.add((Item)NCItems.HEV_PANTS.get(), "HEV Pants");
        this.add((Item)NCItems.HEV_BOOTS.get(), "HEV Boots");
        this.add((Item)NCItems.HEV_CHEST.get(), "HEV Chest");
        this.add((Item)NCItems.HAZMAT_MASK.get(), "Hazmat Mask");
        this.add((Item)NCItems.HAZMAT_PANTS.get(), "Hazmat Pants");
        this.add((Item)NCItems.HAZMAT_BOOTS.get(), "Hazmat Boots");
        this.add((Item)NCItems.HAZMAT_CHEST.get(), "Hazmat Chest");
    }

    private void food() {
        for (String name : NCItems.NC_FOOD.keySet()) {
            this.add((Item)NCItems.NC_FOOD.get(name).get(), TextUtils.convertToName(name));
        }
    }

    private void parts() {
        for (String name : NCItems.NC_PARTS.keySet()) {
            this.add((Item)NCItems.NC_PARTS.get(name).get(), TextUtils.convertToName(name));
        }
        this.add((Item)NCItems.UNKNOWN_INGREDIENT.get(), "Unknown Ingredient");
    }

    private void gems() {
        for (String name : NCItems.NC_GEMS.keySet()) {
            this.add((Item)NCItems.NC_GEMS.get(name).get(), TextUtils.convertToName(name) + " Gem");
        }
    }

    private void ingots() {
        for (String ingot : NCItems.NC_INGOTS.keySet()) {
            this.add((Item)NCItems.NC_INGOTS.get(ingot).get(), TextUtils.convertToName(ingot) + " Ingot");
        }
    }

    private void plates() {
        for (String name : NCItems.NC_PLATES.keySet()) {
            this.add((Item)NCItems.NC_PLATES.get(name).get(), TextUtils.convertToName(name) + " Plate");
        }
    }

    private void dusts() {
        for (String name : NCItems.NC_DUSTS.keySet()) {
            this.add((Item)NCItems.NC_DUSTS.get(name).get(), TextUtils.convertToName(name) + " Dust");
        }
    }

    private void nuggets() {
        for (String name : NCItems.NC_NUGGETS.keySet()) {
            this.add((Item)NCItems.NC_NUGGETS.get(name).get(), TextUtils.convertToName(name) + " Nugget");
        }
    }

    private void chunks() {
        for (String name : NCItems.NC_CHUNKS.keySet()) {
            this.add((Item)NCItems.NC_CHUNKS.get(name).get(), TextUtils.convertToName(name) + " Chunk");
        }
    }

    private void blocks() {
        for (String name : NCBlocks.NC_MATERIAL_BLOCKS.keySet()) {
            this.add((Block)NCBlocks.NC_MATERIAL_BLOCKS.get(name).get(), TextUtils.convertToName(name) + " Block");
        }
        for (String name : NCBlocks.NC_BLOCKS.keySet()) {
            this.add((Block)NCBlocks.NC_BLOCKS.get(name).get(), TextUtils.convertToName(name) + " Block");
        }
        for (String name : NCBlocks.NC_ELECTROMAGNETS.keySet()) {
            this.add((Block)NCBlocks.NC_ELECTROMAGNETS.get(name).get(), TextUtils.convertToName(name));
        }
        for (String name : NCBlocks.NC_RF_AMPLIFIERS.keySet()) {
            this.add((Block)NCBlocks.NC_RF_AMPLIFIERS.get(name).get(), TextUtils.convertToName(name));
        }
        this.add("block.nuclearcraft.redstone_dimmer", "Redstone Dimmer");
        this.add("block.nuclearcraft.multiblock_builder", "Creative Multiblock Builder");
        this.add("block.nuclearcraft.portal", "Wasteland Portal");
        this.add("block.nuclearcraft.wasteland_earth", "Wasteland Earth");
    }
}

