/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen;

import igentuman.nc.datagen.BaseLootTableProvider;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.multiblock.particle_chamber.TargetChamberRegistration;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.setup.registration.NCStorageBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class NCLootTables
extends BaseLootTableProvider {
    private void ores() {
        for (String ore : NCBlocks.ORE_BLOCKS.keySet()) {
            if (NCItems.NC_CHUNKS.containsKey(ore.replaceAll("_deepslate|_end|_nether", ""))) {
                this.m_246481_((Block)NCBlocks.ORE_BLOCKS.get(ore).get(), block -> this.createSilkTouchTable("ore", (Block)NCBlocks.ORE_BLOCKS.get(ore).get(), (Item)NCItems.NC_CHUNKS.get(ore.replaceAll("_deepslate|_end|_nether", "")).get(), 1.0f, 1.0f));
                continue;
            }
            this.m_246481_((Block)NCBlocks.ORE_BLOCKS.get(ore).get(), block -> this.createSimpleTable("ore", (Block)NCBlocks.ORE_BLOCKS.get(ore).get()));
        }
    }

    private void blocks() {
        NCBlocks.NC_BLOCKS.values().forEach(this::add);
        NCBlocks.NC_MATERIAL_BLOCKS.values().forEach(this::add);
        AcceleratorRegistration.ACCELERATOR_BLOCKS.values().forEach(this::add);
        TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.values().forEach(this::add);
        KugelblitzRegistration.KUGELBLITZ_BLOCKS.values().forEach(block -> {
            if (!((Block)block.get()).m_5456_().toString().equals("black_hole")) {
                this.add((RegistryObject<Block>)block);
            }
        });
        FissionReactorRegistration.FISSION_BLOCKS.values().forEach(this::add);
        TurbineRegistration.TURBINE_BLOCKS.values().forEach(this::add);
        FusionReactorRegistration.FUSION_BLOCKS.values().forEach(this::add);
        this.m_246481_((Block)NCBlocks.MUSHROOM_BLOCK.get(), block -> this.createSimpleTable("block", (Block)NCBlocks.MUSHROOM_BLOCK.get()));
        this.m_246481_((Block)NCBlocks.WASTELAND_EARTH.get(), block -> this.createSimpleTable("block", (Block)NCBlocks.WASTELAND_EARTH.get()));
        this.m_246481_((Block)NCBlocks.PORTAL_BLOCK.get(), block -> this.createSimpleTable("block", (Block)NCBlocks.PORTAL_BLOCK.get()));
    }

    private void add(RegistryObject<Block> regBlock) {
        this.m_246481_((Block)regBlock.get(), block -> this.createSimpleTable("block", (Block)regBlock.get()));
    }

    private void machines() {
        for (String name : NCProcessors.PROCESSORS.keySet()) {
            this.m_246481_((Block)NCProcessors.PROCESSORS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCProcessors.PROCESSORS.get(name).get()));
        }
        for (String name : NCEnergyBlocks.ENERGY_BLOCKS.keySet()) {
            this.m_246481_((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get()));
        }
        for (String name : NCStorageBlocks.STORAGE_BLOCKS.keySet()) {
            this.m_246481_((Block)NCStorageBlocks.STORAGE_BLOCKS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCStorageBlocks.STORAGE_BLOCKS.get(name).get()));
        }
        for (String name : NCBlocks.NC_ELECTROMAGNETS.keySet()) {
            this.m_246481_((Block)NCBlocks.NC_ELECTROMAGNETS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCBlocks.NC_ELECTROMAGNETS.get(name).get()));
        }
        for (String name : NCBlocks.NC_RF_AMPLIFIERS.keySet()) {
            this.m_246481_((Block)NCBlocks.NC_RF_AMPLIFIERS.get(name).get(), block -> this.createSimpleTable("block", (Block)NCBlocks.NC_RF_AMPLIFIERS.get(name).get()));
        }
        this.m_246481_((Block)KugelblitzRegistration.EXPL_BLOCK.get(), block -> this.createSimpleTable("block", (Block)KugelblitzRegistration.EXPL_BLOCK.get()));
        this.m_246481_((Block)KugelblitzRegistration.EXPL_PROXY_BLOCK.get(), block -> this.createSimpleTable("block", Blocks.f_50016_));
    }

    public void m_245660_() {
        this.ores();
        this.blocks();
        this.machines();
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        ArrayList<Block> all = new ArrayList<Block>();
        all.addAll(NCBlocks.ORE_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCBlocks.NC_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCBlocks.NC_MATERIAL_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(FissionReactorRegistration.FISSION_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(FusionReactorRegistration.FUSION_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(TurbineRegistration.TURBINE_BLOCKS.values().stream().map(RegistryObject::get).toList());
        List<Block> kugelblitzBlocks = KugelblitzRegistration.KUGELBLITZ_BLOCKS.values().stream().map(RegistryObject::get).toList();
        all.addAll(kugelblitzBlocks.stream().filter(block -> !block.m_5456_().toString().contains("black_hole")).toList());
        all.addAll(AcceleratorRegistration.ACCELERATOR_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCProcessors.PROCESSORS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCEnergyBlocks.ENERGY_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCStorageBlocks.STORAGE_BLOCKS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCBlocks.NC_ELECTROMAGNETS.values().stream().map(RegistryObject::get).toList());
        all.addAll(NCBlocks.NC_RF_AMPLIFIERS.values().stream().map(RegistryObject::get).toList());
        all.add((Block)KugelblitzRegistration.EXPL_PROXY_BLOCK.get());
        all.add((Block)KugelblitzRegistration.EXPL_BLOCK.get());
        all.add((Block)NCBlocks.MUSHROOM_BLOCK.get());
        all.add((Block)NCBlocks.WASTELAND_EARTH.get());
        all.add((Block)NCBlocks.PORTAL_BLOCK.get());
        return all;
    }
}

