/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.models;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.storage.BarrelBlocks;
import igentuman.nc.content.storage.ContainerBlocks;
import igentuman.nc.fluid.NCFluid;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.multiblock.particle_chamber.TargetChamberRegistration;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class NCItemModels
extends ItemModelProvider {
    public NCItemModels(DataGenerator generator, GatherDataEvent event) {
        super(generator.getPackOutput(), "nuclearcraft", event.getExistingFileHelper());
    }

    protected void registerModels() {
        this.ores();
        this.blocks();
        this.multiblocks();
        this.processors();
        this.energyBlocks();
        this.chunks();
        this.ingots();
        this.nuggets();
        this.plates();
        this.dusts();
        this.gems();
        this.parts();
        this.records();
        this.particleSources();
        this.food();
        this.armor();
        this.items();
        this.shielding();
        this.fuel();
        this.isotopes();
        this.waste();
        this.storageBlocks();
        this.withExistingParent(NCItems.FERAL_GHOUL_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(NCBlocks.PORTAL_ITEM.getId().m_135815_(), this.modLoc("block/portal"));
        this.withExistingParent(NCBlocks.WASTELAND_EARTH.getId().m_135815_(), this.modLoc("block/wasteland_earth"));
        this.singleTexture(NCItems.MULTITOOL.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/tool/" + NCItems.MULTITOOL.getId().m_135815_()));
        this.singleTexture(NCItems.SPAXELHOE_TOUGH.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/tool/" + NCItems.SPAXELHOE_TOUGH.getId().m_135815_()));
        this.singleTexture(NCItems.SPAXELHOE_THORIUM.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/tool/" + NCItems.SPAXELHOE_THORIUM.getId().m_135815_()));
        NCFluids.ALL_FLUID_ENTRIES.values().forEach(this::createBucket);
    }

    private void multiblocks() {
        for (String name : NCBlocks.MULTI_BLOCKS.keySet()) {
            this.withExistingParent(NCItems.MULTIBLOCK_ITEMS.get(name).getId().m_135815_(), this.modLoc("block/multiblock/" + name));
        }
        for (String name : FissionReactorRegistration.FISSION_BLOCKS.keySet()) {
            this.withExistingParent(FissionReactorRegistration.FISSION_BLOCK_ITEMS.get(name).getId().m_135815_(), this.modLoc("block/multiblock/" + name));
        }
        for (String name : TurbineRegistration.TURBINE_BLOCKS.keySet()) {
            this.withExistingParent(TurbineRegistration.TURBINE_BLOCKS.get(name).getId().m_135815_(), this.modLoc("block/multiblock/" + name));
        }
        for (String name : FusionReactorRegistration.FUSION_BLOCKS.keySet()) {
            if (name.contains("core")) continue;
            this.withExistingParent(FusionReactorRegistration.FUSION_BLOCKS.get(name).getId().m_135815_(), this.modLoc("block/fusion/" + name));
        }
        for (String name : KugelblitzRegistration.KUGELBLITZ_BLOCKS.keySet()) {
            this.withExistingParent(KugelblitzRegistration.KUGELBLITZ_BLOCKS.get(name).getId().m_135815_(), this.modLoc("block/multiblock/" + name));
        }
        for (String name : AcceleratorRegistration.ACCELERATOR_BLOCKS.keySet()) {
            this.withExistingParent(AcceleratorRegistration.ACCELERATOR_BLOCKS.get(name).getId().m_135815_(), this.modLoc("block/multiblock/" + name));
        }
        for (String name : TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.keySet()) {
            this.withExistingParent(TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get(name).getId().m_135815_(), this.modLoc("block/multiblock/" + name));
        }
        this.withExistingParent(FusionReactorRegistration.FUSION_CORE_PROXY.getId().m_135815_(), this.modLoc("item/fusion_core"));
    }

    private void processors() {
        for (String name : NCProcessors.PROCESSORS.keySet()) {
            this.withExistingParent(NCProcessors.PROCESSOR_BLOCKS_ITEMS.get(name).getId().m_135815_(), this.modLoc("block/processor/" + name));
        }
    }

    private void energyBlocks() {
        for (String name : NCEnergyBlocks.ENERGY_BLOCKS.keySet()) {
            this.withExistingParent(NCEnergyBlocks.ENERGY_BLOCKS.get(name).getId().m_135815_(), this.modLoc("block/" + name.replace("/", "_")));
        }
    }

    private void storageBlocks() {
        for (String name : BarrelBlocks.all().keySet()) {
            this.withExistingParent(name, this.modLoc("block/barrel/" + name));
        }
        for (String name : ContainerBlocks.all().keySet()) {
            this.withExistingParent(name, this.modLoc("block/container/" + name));
        }
    }

    private String name(ItemLike item) {
        return ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_();
    }

    private ResourceLocation forgeLoc(String s) {
        return NuclearCraft.forgeRl(s);
    }

    private void createBucket(NCFluids.FluidEntry entry) {
        ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.withExistingParent(this.name((ItemLike)entry.getBucket()), this.forgeLoc("item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid((Fluid)entry.getStill()).flipGas(((NCFluid)((Object)entry.flowing().get())).getFluidType().getDensity() < 0).applyTint(true);
    }

    private void shielding() {
        for (String name : NCItems.NC_SHIELDING.keySet()) {
            this.singleTexture(NCItems.NC_SHIELDING.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/rad_shielding/" + name));
        }
    }

    private void fuel() {
        String subPath;
        String depleted;
        for (List<String> name : FissionFuel.NC_FUEL.keySet()) {
            depleted = "/";
            if (name.get(0).equals("depleted")) {
                depleted = "/depleted/";
            }
            subPath = name.get(1) + depleted + name.get(2).replace("-", "_");
            if (!name.get(3).isEmpty()) {
                subPath = subPath + "_" + name.get(3);
            }
            this.singleTexture(FissionFuel.NC_FUEL.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/fuel/" + subPath));
        }
        for (List<String> name : FissionFuel.NC_DEPLETED_FUEL.keySet()) {
            depleted = "/";
            if (name.get(0).equals("depleted")) {
                depleted = "/depleted/";
            }
            subPath = name.get(1) + depleted + name.get(2).replace("-", "_");
            if (!name.get(3).isEmpty()) {
                subPath = subPath + "_" + name.get(3);
            }
            this.singleTexture(FissionFuel.NC_DEPLETED_FUEL.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/fuel/" + subPath));
        }
    }

    private void waste() {
        for (String name : FissionFuel.NC_WASTE.keySet()) {
            this.singleTexture(FissionFuel.NC_WASTE.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/material/waste/" + name));
        }
    }

    private void isotopes() {
        for (String name : FissionFuel.NC_ISOTOPES.keySet()) {
            this.singleTexture(FissionFuel.NC_ISOTOPES.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/material/isotope/" + name));
        }
    }

    private void items() {
        for (String name : NCItems.NC_ITEMS.keySet()) {
            if (name.contains("collector")) continue;
            this.singleTexture(NCItems.NC_ITEMS.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + name));
        }
    }

    private void particleSources() {
        for (String name : NCItems.ION_SOURCES.keySet()) {
            this.singleTexture(NCItems.ION_SOURCES.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/particle_sources/" + name));
        }
    }

    private void records() {
        for (String name : NCItems.NC_RECORDS.keySet()) {
            this.singleTexture(NCItems.NC_RECORDS.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/record/" + name));
        }
    }

    private void armor() {
        this.singleTexture(NCItems.HEV_BOOTS.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.HEV_BOOTS.getId().m_135815_()));
        this.singleTexture(NCItems.HEV_CHEST.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.HEV_CHEST.getId().m_135815_()));
        this.singleTexture(NCItems.HEV_PANTS.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.HEV_PANTS.getId().m_135815_()));
        this.singleTexture(NCItems.HEV_HELMET.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.HEV_HELMET.getId().m_135815_()));
        this.singleTexture(NCItems.HAZMAT_BOOTS.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.HAZMAT_BOOTS.getId().m_135815_()));
        this.singleTexture(NCItems.HAZMAT_CHEST.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.HAZMAT_CHEST.getId().m_135815_()));
        this.singleTexture(NCItems.HAZMAT_MASK.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.HAZMAT_MASK.getId().m_135815_()));
        this.singleTexture(NCItems.HAZMAT_PANTS.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.HAZMAT_PANTS.getId().m_135815_()));
        this.singleTexture(NCItems.TOUGH_BOOTS.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.TOUGH_BOOTS.getId().m_135815_()));
        this.singleTexture(NCItems.TOUGH_CHEST.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.TOUGH_CHEST.getId().m_135815_()));
        this.singleTexture(NCItems.TOUGH_PANTS.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.TOUGH_PANTS.getId().m_135815_()));
        this.singleTexture(NCItems.TOUGH_HELMET.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/armor/" + NCItems.TOUGH_HELMET.getId().m_135815_()));
    }

    private void food() {
        for (String name : NCItems.NC_FOOD.keySet()) {
            if (name.contains("smore")) continue;
            this.singleTexture(NCItems.NC_FOOD.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/food/" + name));
        }
    }

    private void parts() {
        for (String name : NCItems.NC_PARTS.keySet()) {
            if (name.matches("chassis|empty_frame|steel_frame")) continue;
            this.singleTexture(NCItems.NC_PARTS.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/part/" + name));
        }
    }

    private void gems() {
        for (String name : NCItems.NC_GEMS.keySet()) {
            this.singleTexture(NCItems.NC_GEMS.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/material/gem/" + name));
        }
    }

    private void chunks() {
        for (String name : NCItems.NC_CHUNKS.keySet()) {
            this.singleTexture(NCItems.NC_CHUNKS.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/material/chunk/" + name));
        }
    }

    private void ingots() {
        for (String name : NCItems.NC_INGOTS.keySet()) {
            this.singleTexture(NCItems.NC_INGOTS.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/material/ingot/" + name));
        }
    }

    private void nuggets() {
        for (String name : NCItems.NC_NUGGETS.keySet()) {
            this.singleTexture(NCItems.NC_NUGGETS.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/material/nugget/" + name));
        }
    }

    private void plates() {
        for (String name : NCItems.NC_PLATES.keySet()) {
            this.singleTexture(NCItems.NC_PLATES.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/material/plate/" + name));
        }
    }

    private void dusts() {
        for (String name : NCItems.NC_DUSTS.keySet()) {
            this.singleTexture(NCItems.NC_DUSTS.get(name).getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/material/dust/" + name));
        }
    }

    private void ores() {
        for (String ore : NCItems.ORE_BLOCK_ITEMS.keySet()) {
            this.withExistingParent(NCItems.ORE_BLOCK_ITEMS.get(ore).getId().m_135815_(), this.modLoc("block/ore/" + ore + "_ore"));
        }
    }

    private void blocks() {
        for (String name : NCItems.NC_BLOCKS_ITEMS.keySet()) {
            this.withExistingParent(NCItems.NC_BLOCKS_ITEMS.get(name).getId().m_135815_(), this.modLoc("block/material/" + name + "_block"));
        }
        for (String name : NCItems.NC_ELECTROMAGNETS_ITEMS.keySet()) {
            this.withExistingParent(NCItems.NC_ELECTROMAGNETS_ITEMS.get(name).getId().m_135815_(), this.modLoc("block/electromagnet/" + name));
        }
        for (String name : NCItems.NC_RF_AMPLIFIERS_ITEMS.keySet()) {
            this.withExistingParent(NCItems.NC_RF_AMPLIFIERS_ITEMS.get(name).getId().m_135815_(), this.modLoc("block/rf_amplifier/" + name));
        }
    }
}

