/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.entity;

import igentuman.nc.radiation.data.PlayerRadiationProvider;
import igentuman.nc.setup.registration.Entities;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.setup.registration.WorldGeneration;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class EntityFeralGhoul
extends Zombie {
    private static final int VAULT_COOLDOWN = 60;
    private static final double VAULT_TRIGGER_DISTANCE = 16.0;
    private static final double VAULT_JUMP_POWER = 0.7;
    private static final double VAULT_FORWARD_MOMENTUM = 0.8;
    private static final int RADIATION_AMOUNT = 10000000;
    private int vaultCooldownRemaining = 0;

    public EntityFeralGhoul(Level pLevel) {
        this((EntityType)Entities.FERAL_GHOUL.get(), pLevel);
    }

    public EntityFeralGhoul(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)NCSounds.FERAL_GHOUL_CHARGE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)NCSounds.FERAL_GHOUL_DEATH.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return new GhoulGroupData(false, false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FeralGhoulVaultGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder m_34328_() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 45.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.vaultCooldownRemaining > 0) {
            --this.vaultCooldownRemaining;
        }
    }

    public void vault() {
        if (this.vaultCooldownRemaining <= 0) {
            Vec3 direction = Vec3.f_82478_;
            direction = this.m_5448_() != null ? new Vec3(this.m_5448_().m_20185_() - this.m_20185_(), 0.0, this.m_5448_().m_20189_() - this.m_20189_()).m_82541_() : Vec3.m_82498_((float)0.0f, (float)this.m_146908_()).m_82541_();
            this.m_20334_(direction.f_82479_ * 0.8, 0.7, direction.f_82481_ * 0.8);
            this.m_5496_(SoundEvents.f_12601_, 0.2f, 1.2f);
            this.vaultCooldownRemaining = 60;
        }
    }

    public boolean hasObstacleAhead() {
        Vec3 directionVec = Vec3.m_82498_((float)0.0f, (float)this.m_146908_()).m_82541_();
        BlockPos currentPos = this.m_20183_();
        BlockPos forwardPos = new BlockPos((int)((double)currentPos.m_123341_() + directionVec.f_82479_ * 2.0), currentPos.m_123342_(), (int)((double)currentPos.m_123343_() + directionVec.f_82481_ * 2.0));
        return !this.m_9236_().m_8055_(forwardPos).m_60795_() || !this.m_9236_().m_8055_(forwardPos.m_7494_()).m_60795_();
    }

    public boolean m_7327_(Entity pEntity) {
        boolean attackResult = super.m_7327_(pEntity);
        if (attackResult && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            player.getCapability(PlayerRadiationProvider.PLAYER_RADIATION).ifPresent(radiation -> {
                long currentRadiation = radiation.getRadiation();
                radiation.setRadiation(currentRadiation + 10000000L);
            });
            this.m_5496_(SoundEvents.f_11911_, 0.2f, 0.8f);
        }
        return attackResult;
    }

    public static boolean checkFeralGhoulSpawnRules(EntityType<EntityFeralGhoul> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!Monster.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random)) {
            return false;
        }
        return level.m_204166_(pos).m_203656_(WorldGeneration.WASTELAND);
    }

    public static class GhoulGroupData
    implements SpawnGroupData {
        public final boolean isBaby;
        public final boolean canSpawnJockey;

        public GhoulGroupData(boolean pIsBaby, boolean pCanSpawnJockey) {
            this.isBaby = pIsBaby;
            this.canSpawnJockey = pCanSpawnJockey;
        }
    }

    static class FeralGhoulVaultGoal
    extends Goal {
        private final EntityFeralGhoul ghoul;
        private Path path;
        private int checkPathDelay;
        private boolean pathBlocked;

        public FeralGhoulVaultGoal(EntityFeralGhoul ghoul) {
            this.ghoul = ghoul;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            LivingEntity target = this.ghoul.m_5448_();
            if (target == null || !target.m_6084_() || this.ghoul.vaultCooldownRemaining > 0) {
                return false;
            }
            if ((double)this.ghoul.m_20270_((Entity)target) <= 16.0) {
                return this.ghoul.hasObstacleAhead();
            }
            if (--this.checkPathDelay > 0) {
                return false;
            }
            this.checkPathDelay = 10;
            this.path = this.ghoul.m_21573_().m_6570_((Entity)target, 0);
            if (this.path == null || this.path.m_77403_()) {
                return false;
            }
            return this.ghoul.hasObstacleAhead();
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.ghoul.vault();
        }
    }
}

