/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.event.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import igentuman.api.nc.SideModeToggleable;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.item.QNP;
import igentuman.nc.util.AreaUtil;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.StackUtils;
import igentuman.nc.util.collection.HashList;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="nuclearcraft", value={Dist.CLIENT})
public class BlockOverlayHandler {
    private static int outlineCooldown = 5;
    private static final HashList<BlockPos> highlightsToRemove = new HashList();
    private static final HashMap<Long, RenderBox> boxes = new HashMap();
    public static final HashList<FissionControllerBE> reactors = new HashList();
    public static List<BlockPos> outlineBlocks = new CopyOnWriteArrayList<BlockPos>();
    public static List<BlockPos> fusionReactors = new CopyOnWriteArrayList<BlockPos>();

    public static void register(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(BlockOverlayHandler::blockOverlayEvent);
        MinecraftForge.EVENT_BUS.addListener(BlockOverlayHandler::onRenderPre);
    }

    @SubscribeEvent
    public static void onRenderWorldEvent(RenderLevelStageEvent e) {
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (e.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            for (BlockPos blockPos : fusionReactors) {
            }
        }
        if (!highlightsToRemove.isEmpty() && --outlineCooldown < 1) {
            outlineCooldown = 400;
            for (BlockPos blockPos : highlightsToRemove) {
                outlineBlocks.remove(blockPos);
            }
            highlightsToRemove.clear();
        }
        if (e.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            gameRenderer.m_252879_(e.getProjectionMatrix());
            if (player.m_9236_().f_46443_) {
                for (FissionControllerBE fissionControllerBE : reactors) {
                }
                for (RenderBox renderBox : boxes.values()) {
                    BlockOverlayHandler.drawBoundingBoxAtBlockPos(e.getPoseStack(), renderBox.boundingBox, renderBox.red, renderBox.green, renderBox.blue, renderBox.alpha, renderBox.relative, player.m_20183_());
                }
                if (outlineBlocks.isEmpty()) {
                    return;
                }
                for (BlockPos blockPos : outlineBlocks) {
                    if (blockPos.equals((Object)BlockPos.f_121853_)) continue;
                    AABB aabb = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                    BlockOverlayHandler.drawBoundingBoxAtBlockPos(e.getPoseStack(), aabb, 1.0f, 0.0f, 0.0f, 1.0f, blockPos, player.m_20183_());
                    highlightsToRemove.add(blockPos);
                }
            }
        }
    }

    @SubscribeEvent
    public static void blockOverlayEvent(RenderHighlightEvent.Block event) {
        BlockHitResult hit = event.getTarget();
        ItemStack stackItem = Minecraft.m_91087_().f_91074_.m_21205_();
        BlockOverlayHandler.handleQNP(event, (HitResult)hit, stackItem);
        BlockOverlayHandler.handleMultitool(event, (HitResult)hit, stackItem);
    }

    private static void handleMultitool(RenderHighlightEvent.Block event, HitResult hit, ItemStack stackItem) {
        if (hit.m_6662_() == HitResult.Type.BLOCK && StackUtils.isMultiTool(stackItem)) {
            SideModeToggleable.SideMode mode;
            BlockHitResult blockRayTraceResult = (BlockHitResult)hit;
            event.setCanceled(true);
            BlockPos blockPos = blockRayTraceResult.m_82425_();
            Level world = Minecraft.m_91087_().f_91074_.m_9236_();
            BlockEntity be = world.m_7702_(blockPos);
            if (!(be instanceof NuclearCraftBE)) {
                return;
            }
            NuclearCraftBE ncBe = (NuclearCraftBE)be;
            if (ncBe.sideConfig.isEmpty()) {
                return;
            }
            Direction hitSide = blockRayTraceResult.m_82434_();
            if (Minecraft.m_91087_().f_91074_.m_6144_()) {
                hitSide = hitSide.m_122424_();
            }
            if ((mode = ncBe.sideConfig.get(hitSide.ordinal())) == null) {
                return;
            }
            float[] color = new float[]{0.0f, 1.0f, 0.0f};
            switch (mode) {
                case DEFAULT: {
                    color = new float[]{0.0f, 1.0f, 0.0f};
                    break;
                }
                case IN: {
                    color = new float[]{0.0f, 0.0f, 1.0f};
                    break;
                }
                case OUT: {
                    color = new float[]{1.0f, 0.0f, 0.0f};
                    break;
                }
                case DISABLED: {
                    color = new float[]{0.5f, 0.5f, 0.5f};
                }
            }
            PoseStack stack = new PoseStack();
            stack.m_85836_();
            Camera info = event.getCamera();
            stack.m_252781_(Axis.f_252529_.m_252977_(info.m_90589_()));
            stack.m_252781_(Axis.f_252436_.m_252977_(info.m_90590_() + 180.0f));
            double d0 = info.m_90583_().m_7096_();
            double d1 = info.m_90583_().m_7098_();
            double d2 = info.m_90583_().m_7094_();
            VertexConsumer builder = Minecraft.m_91087_().m_91269_().m_110109_().m_6299_(RenderType.m_110504_());
            VoxelShape shape = world.m_8055_(blockPos).m_60808_((BlockGetter)world, blockPos);
            AABB bounds = shape.m_83215_();
            switch (hitSide) {
                case DOWN: {
                    bounds = bounds.m_165893_(0.01);
                    break;
                }
                case UP: {
                    bounds = bounds.m_165887_(0.99);
                    break;
                }
                case NORTH: {
                    bounds = bounds.m_165895_(0.01);
                    break;
                }
                case SOUTH: {
                    bounds = bounds.m_165889_(0.99);
                    break;
                }
                case WEST: {
                    bounds = bounds.m_165891_(0.01);
                    break;
                }
                case EAST: {
                    bounds = bounds.m_165880_(0.99);
                }
            }
            LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)bounds.m_82386_((double)blockPos.m_123341_() - d0, (double)blockPos.m_123342_() - d1, (double)blockPos.m_123343_() - d2), (float)color[0], (float)color[1], (float)color[2], (float)0.35f);
            stack.m_85849_();
        }
    }

    private static void handleQNP(RenderHighlightEvent.Block event, HitResult hit, ItemStack stackItem) {
        Item item;
        if (hit.m_6662_() == HitResult.Type.BLOCK && (item = stackItem.m_41720_()) instanceof QNP) {
            QNP qnp = (QNP)item;
            BlockHitResult blockRayTraceResult = (BlockHitResult)hit;
            event.setCanceled(true);
            QNP.Mode mode = QNP.getMode(stackItem);
            Level world = Minecraft.m_91087_().f_91074_.m_9236_();
            Pair<BlockPos, BlockPos> area = AreaUtil.getArea(blockRayTraceResult.m_82425_(), blockRayTraceResult.m_82434_(), mode.radius, mode.depth);
            PoseStack stack = new PoseStack();
            stack.m_85836_();
            Camera info = event.getCamera();
            stack.m_252781_(Axis.f_252529_.m_252977_(info.m_90589_()));
            stack.m_252781_(Axis.f_252436_.m_252977_(info.m_90590_() + 180.0f));
            double d0 = info.m_90583_().m_7096_();
            double d1 = info.m_90583_().m_7098_();
            double d2 = info.m_90583_().m_7094_();
            VertexConsumer builder = Minecraft.m_91087_().m_91269_().m_110109_().m_6299_(RenderType.m_110504_());
            BlockPos.m_121940_((BlockPos)((BlockPos)area.getLeft()), (BlockPos)((BlockPos)area.getRight())).forEach(blockPos -> {
                VoxelShape shape = world.m_8055_(blockPos).m_60808_((BlockGetter)world, blockPos);
                if (!(shape == null || shape.m_83281_() || world.m_46859_(blockPos) || !(world.m_8055_(blockPos).m_60800_((BlockGetter)world, blockPos) >= 0.0f) || world.m_8055_(blockPos).m_60734_() instanceof IFluidBlock || world.m_8055_(blockPos).m_60734_() instanceof LiquidBlock)) {
                    LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)shape.m_83215_().m_82386_((double)blockPos.m_123341_() - d0, (double)blockPos.m_123342_() - d1, (double)blockPos.m_123343_() - d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
                }
            });
            stack.m_85849_();
        }
    }

    @SubscribeEvent
    public static void onRenderPre(RenderPlayerEvent.Pre event) {
        if (event.getEntity().m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_()) && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            return;
        }
        if (event.getEntity().m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof QNP) {
            event.getEntity().m_6672_(InteractionHand.MAIN_HAND);
        } else if (event.getEntity().m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof QNP) {
            event.getEntity().m_6672_(InteractionHand.OFF_HAND);
        }
    }

    public static void drawBoundingBoxAtBlockPos(PoseStack matrixStackIn, AABB aabbIn, float red, float green, float blue, float alpha, BlockPos pos, BlockPos aimed) {
        Vec3 cam = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double camX = cam.f_82479_;
        double camY = cam.f_82480_;
        double camZ = cam.f_82481_;
        matrixStackIn.m_85836_();
        GL11.glDisable((int)2929);
        BlockOverlayHandler.drawShapeOutline(matrixStackIn, Shapes.m_83064_((AABB)aabbIn), (double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ, red, green, blue, alpha, pos, aimed);
        GL11.glEnable((int)2929);
        matrixStackIn.m_85849_();
    }

    private static void drawShapeOutline(PoseStack matrixStack, VoxelShape voxelShape, double originX, double originY, double originZ, float red, float green, float blue, float alpha, BlockPos pos, BlockPos aimed) {
        PoseStack.Pose pose = matrixStack.m_85850_();
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer bufferIn = renderTypeBuffer.m_6299_(RenderType.m_110504_());
        voxelShape.m_83224_((x0, y0, z0, x1, y1, z1) -> {
            if (!pos.equals((Object)aimed)) {
                bufferIn.m_252986_(pose.m_252922_(), (float)(x0 + originX), (float)(y0 + originY), (float)(z0 + originZ)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), (float)(x1 - x0), (float)(y1 - y0), (float)(z1 - z0)).m_5752_();
                bufferIn.m_252986_(pose.m_252922_(), (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), (float)(x1 - x0), (float)(y1 - y0), (float)(z1 - z0)).m_5752_();
            }
        });
        renderTypeBuffer.m_109912_(RenderType.m_110504_());
    }

    public static void renderFilledBox(PoseStack poseStack, AABB box, float r, float g, float b, float alpha, BlockPos pos, BlockPos player) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Vec3 cam = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double camX = cam.f_82479_;
        double camY = cam.f_82480_;
        double camZ = cam.f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_(-camX, -camY, -camZ);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float x1 = (float)box.f_82288_;
        float y1 = (float)box.f_82289_;
        float z1 = (float)box.f_82290_;
        float x2 = (float)box.f_82291_;
        float y2 = (float)box.f_82292_;
        float z2 = (float)box.f_82293_;
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z1).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, alpha).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z2).m_85950_(r, g, b, alpha).m_5752_();
        tesselator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    public static void removeFromOutline(BlockPosInstance pos, boolean instant) {
        if (instant) {
            outlineBlocks.remove((Object)pos);
        } else {
            BlockOverlayHandler.removeFromOutline(pos);
        }
    }

    public static void removeBoxFromOutline(BlockPos blockPos) {
        if (boxes.containsKey(blockPos.m_121878_())) {
            boxes.remove(blockPos.m_121878_());
        }
    }

    public static void addBoxToOutline(AABB boundingBox, float v, float v1, float v2, float v3, BlockPos pos) {
        if (boxes.containsKey(pos.m_121878_())) {
            return;
        }
        boxes.put(pos.m_121878_(), new RenderBox(boundingBox, v, v1, v2, v3, pos));
    }

    public void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, Vector3f blpos, Vector3f brpos, Vector3f trpos, Vector3f tlpos, Vec2 blUVpos, Vec2 brUVpos, Vec2 trUVpos, Vec2 tlUVpos, Vector3f normalVector, Color color, int lightmapValue) {
        BlockOverlayHandler.addQuadVertex(matrixPos, matrixNormal, renderBuffer, blpos, blUVpos, normalVector, color, lightmapValue);
        BlockOverlayHandler.addQuadVertex(matrixPos, matrixNormal, renderBuffer, brpos, brUVpos, normalVector, color, lightmapValue);
        BlockOverlayHandler.addQuadVertex(matrixPos, matrixNormal, renderBuffer, trpos, trUVpos, normalVector, color, lightmapValue);
        BlockOverlayHandler.addQuadVertex(matrixPos, matrixNormal, renderBuffer, tlpos, tlUVpos, normalVector, color, lightmapValue);
    }

    static void addQuadVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, Vector3f pos, Vec2 texUV, Vector3f normalVector, Color color, int lightmapValue) {
        renderBuffer.m_252986_(matrixPos, pos.x(), pos.y(), pos.z()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(texUV.f_82470_, texUV.f_82471_).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmapValue).m_252939_(matrixNormal, normalVector.x(), normalVector.y(), normalVector.z()).m_5752_();
    }

    public static void addFusionReactor(BlockPos pos) {
        if (!fusionReactors.contains(pos)) {
            fusionReactors.add(pos);
        }
    }

    public static void removeFusionReactor(BlockPos pos) {
        if (fusionReactors.contains(pos)) {
            fusionReactors.remove(pos);
        }
    }

    public static void addToOutline(BlockPosInstance blockPosInstance) {
        if (!outlineBlocks.contains((Object)blockPosInstance)) {
            outlineBlocks.add(blockPosInstance);
            highlightsToRemove.remove((Object)blockPosInstance);
        }
    }

    public static void removeFromOutline(BlockPosInstance blockPosInstance) {
        if (!highlightsToRemove.contains((Object)blockPosInstance)) {
            highlightsToRemove.add(blockPosInstance);
        }
    }

    private static class RenderBox {
        public final AABB boundingBox;
        public final float red;
        public final float green;
        public final float blue;
        public final float alpha;
        public final BlockPos relative;

        public RenderBox(AABB boundingBox, float red, float green, float blue, float alpha, BlockPos relative) {
            this.boundingBox = boundingBox;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            this.relative = relative;
        }
    }
}

