/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.item;

import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.handler.ItemEnergyHandler;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.setup.registration.NcParticleTypes;
import igentuman.nc.util.AreaUtil;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.RayTraceUtils;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.capability.CapabilityUtils;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class QNP
extends PickaxeItem {
    public int veinMinedBlocksCounter = 0;

    public QNP(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return false;
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(pStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    protected int getEnergyMaxStorage() {
        return (Integer)CommonConfig.ENERGY_STORAGE.QNP_ENERGY_STORAGE.get();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return super.canPerformAction(stack, toolAction) && this.enoughEnergy(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        CustomEnergyStorage energyStorage = this.getEnergy(stack);
        float chargeRatio = (float)energyStorage.getEnergyStored() / (float)this.getEnergyMaxStorage();
        return (int)Math.min(13.0f, 13.0f * chargeRatio);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isCorrectToolForDrops(@NotNull ItemStack stack, @NotNull BlockState state) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        return true;
    }

    public List<ItemStack> mineArea(BlockPos pos, Level worldIn, LivingEntity entityLiving, BlockHitResult blockResult, ItemStack stack, List<ItemStack> totalDrops) {
        Direction facing = blockResult.m_82434_();
        Mode miningMode = QNP.getMode(stack);
        Pair<BlockPos, BlockPos> area = AreaUtil.getArea(pos, facing, miningMode.radius, miningMode.depth);
        BlockPos.m_121940_((BlockPos)((BlockPos)area.getLeft()), (BlockPos)((BlockPos)area.getRight())).forEach(blockPos -> {
            if (this.enoughEnergy(stack) && worldIn.m_7702_(blockPos) == null && worldIn instanceof ServerLevel && entityLiving instanceof ServerPlayer && !worldIn.m_46859_(blockPos)) {
                BlockState tempState = worldIn.m_8055_(blockPos);
                if (!tempState.m_204336_(BlockTags.f_144282_) && !tempState.m_204336_(BlockTags.f_144283_)) {
                    return;
                }
                if (tempState.m_60800_((BlockGetter)worldIn, blockPos) < 0.0f) {
                    return;
                }
                this.harvestBlock((BlockPos)blockPos, worldIn, entityLiving, stack, false, totalDrops);
            }
        });
        worldIn.m_45976_(ExperienceOrb.class, new AABB((BlockPos)area.getLeft(), (BlockPos)area.getRight()).m_82400_(1.0)).forEach(entityXPOrb -> entityXPOrb.m_6021_((double)entityLiving.m_20183_().m_123341_(), (double)entityLiving.m_20183_().m_123342_(), (double)entityLiving.m_20183_().m_123343_()));
        return totalDrops;
    }

    public static Mode getMode(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("mode")) {
            tag.m_128405_("mode", Mode.ONE_BLOCK.ordinal());
            stack.m_41739_(tag);
        }
        return Mode.values()[tag.m_128451_("mode")];
    }

    public int energyPerBlock(ItemStack stack) {
        int durability = this.getEnchantmentLevel(stack, Enchantments.f_44986_);
        if (durability > 0) {
            return (int)((double)((Integer)CommonConfig.ENERGY_STORAGE.QNP_ENERGY_PER_BLOCK.get()).intValue() / Math.sqrt(durability + 1));
        }
        return (Integer)CommonConfig.ENERGY_STORAGE.QNP_ENERGY_PER_BLOCK.get();
    }

    public void consumeEnergy(ItemStack stack) {
        int energyPerBlock = this.energyPerBlock(stack);
        if (this.getEnergy(stack).getEnergyStored() > energyPerBlock) {
            this.getEnergy(stack).setEnergy(this.getEnergy(stack).getEnergyStored() - energyPerBlock);
            CompoundTag tag = stack.m_41783_();
            tag.m_128405_("energy", this.getEnergy(stack).getEnergyStored());
            stack.m_41751_(tag);
        }
    }

    public static void dropResource(Level pLevel, BlockPos pPos, ItemStack pStack) {
        double d0 = (double)EntityType.f_20461_.m_20679_() / 2.0;
        double d1 = (double)pPos.m_123341_() + 0.5 + Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.25, (double)0.25);
        double d2 = (double)pPos.m_123342_() + 0.5 + Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.m_123343_() + 0.5 + Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.25, (double)0.25);
        QNP.popResource(pLevel, () -> new ItemEntity(pLevel, d1, d2, d3, pStack), pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.f_46443_ && !pStack.m_41619_() && pLevel.m_46469_().m_46207_(GameRules.f_46136_) && !pLevel.restoringBlockSnapshots) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.m_32061_();
            itementity.f_31985_ /= 2;
            pLevel.m_7967_((Entity)itementity);
        }
    }

    public boolean m_6813_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entityLiving) {
        HitResult rayTraceResult;
        if (entityLiving instanceof Player && (rayTraceResult = RayTraceUtils.rayTraceSimple(worldIn, entityLiving, 16.0, 0.0f)).m_6662_() == HitResult.Type.BLOCK) {
            BlockEntity be = worldIn.getExistingBlockEntity(pos);
            if (be != null) {
                return super.m_6813_(stack, worldIn, state, pos, entityLiving);
            }
            BlockHitResult blockResult = (BlockHitResult)rayTraceResult;
            ArrayList<ItemStack> totalDrops = new ArrayList<ItemStack>();
            if (QNP.getMode(stack) == Mode.VEIN_MINER) {
                this.mineVein(pos, worldIn, entityLiving, blockResult, stack, totalDrops);
            } else {
                this.mineArea(pos, worldIn, entityLiving, blockResult, stack, totalDrops);
            }
            totalDrops.forEach(itemStack -> QNP.dropResource(worldIn, entityLiving.m_20183_().m_5484_(entityLiving.m_6350_(), 2), itemStack));
        }
        return super.m_6813_(stack, worldIn, state, pos, entityLiving);
    }

    private List<ItemStack> harvestBlock(BlockPos pos, @NotNull Level worldIn, LivingEntity entityLiving, ItemStack tool, boolean veinMode, List<ItemStack> totalDrops) {
        BlockState tempState = worldIn.m_8055_(pos);
        Block block = tempState.m_60734_();
        if (!this.enoughEnergy(tool)) {
            return totalDrops;
        }
        int xp = ForgeHooks.onBlockBreakEvent((Level)worldIn, (GameType)((ServerPlayer)entityLiving).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)entityLiving), (BlockPos)pos);
        if (xp >= 0 && block.onDestroyedByPlayer(tempState, worldIn, pos, (Player)((ServerPlayer)entityLiving), true, tempState.m_60819_())) {
            block.m_6786_((LevelAccessor)worldIn, pos, tempState);
            Block.m_49874_((BlockState)tempState, (ServerLevel)((ServerLevel)worldIn), (BlockPos)pos, (BlockEntity)worldIn.getExistingBlockEntity(pos), (Entity)entityLiving, (ItemStack)tool).forEach(itemStack -> {
                boolean combined = false;
                for (ItemStack drop : totalDrops) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)drop, (ItemStack)itemStack)) continue;
                    drop.m_41764_(drop.m_41613_() + itemStack.m_41613_());
                    combined = true;
                    break;
                }
                if (!combined) {
                    totalDrops.add((ItemStack)itemStack);
                }
            });
            Random random = new Random();
            ((ServerLevel)worldIn).m_8767_((ParticleOptions)((SimpleParticleType)NcParticleTypes.RADIATION.get()), (double)pos.m_123341_() + ((double)random.nextFloat() - 0.5), (double)pos.m_123342_() + ((double)random.nextFloat() - 0.5), (double)pos.m_123343_() + ((double)random.nextFloat() - 0.5), 3, 0.0, 0.0, 0.0, 0.0);
            this.consumeEnergy(tool);
            if (veinMode && this.veinMinedBlocksCounter < 20) {
                ++this.veinMinedBlocksCounter;
                for (Direction facing : Direction.values()) {
                    BlockPos newPos = pos.m_121945_(facing);
                    if (!worldIn.m_8055_(newPos).equals(tempState)) continue;
                    this.harvestBlock(newPos, worldIn, entityLiving, tool, true, totalDrops);
                }
            }
            block.m_49805_((ServerLevel)worldIn, pos, xp);
            this.consumeEnergy(tool);
        }
        return totalDrops;
    }

    private void mineVein(BlockPos pos, Level worldIn, LivingEntity entityLiving, BlockHitResult blockResult, ItemStack stack, List<ItemStack> totalDrops) {
        BlockState initialBlockState = worldIn.m_8055_(pos);
        if (!initialBlockState.m_204336_(BlockTags.f_144282_) && !initialBlockState.m_204336_(BlockTags.f_144283_)) {
            return;
        }
        if (initialBlockState.m_60800_((BlockGetter)worldIn, pos) < 0.0f) {
            return;
        }
        this.harvestBlock(pos, worldIn, entityLiving, stack, false, totalDrops);
        this.consumeEnergy(stack);
        ++this.veinMinedBlocksCounter;
        if (initialBlockState.m_204336_(Tags.Blocks.ORES)) {
            for (Direction facing : Direction.values()) {
                BlockPos newPos = pos.m_121945_(facing);
                if (!worldIn.m_8055_(newPos).equals(initialBlockState)) continue;
                this.harvestBlock(newPos, worldIn, entityLiving, stack, true, totalDrops);
            }
        }
        this.veinMinedBlocksCounter = 0;
    }

    private boolean enoughEnergy(ItemStack itemStack) {
        int energyPerBlock = this.energyPerBlock(itemStack);
        if (QNP.getMode((ItemStack)itemStack).radius == 0) {
            return this.getEnergy(itemStack).getEnergyStored() > energyPerBlock;
        }
        int fe = energyPerBlock * (QNP.getMode((ItemStack)itemStack).radius * 2 + 1) * (QNP.getMode((ItemStack)itemStack).radius * 2 + 1);
        if (QNP.getMode((ItemStack)itemStack).depth) {
            fe *= QNP.getMode((ItemStack)itemStack).radius * 2 + 1;
        }
        return this.getEnergy(itemStack).getEnergyStored() > fe;
    }

    public float m_8102_(@NotNull ItemStack stack, @NotNull BlockState state) {
        int efficiency = this.getEnchantmentLevel(stack, Enchantments.f_44984_);
        if (this.enoughEnergy(stack)) {
            return this.m_43314_().m_6624_() + (float)efficiency * 0.5f;
        }
        return 0.1f;
    }

    public boolean chargeFromEnergyBlock(BlockEntity be, ItemStack tool) {
        if (be == null) {
            return false;
        }
        if (this.getEnergy(tool).getEnergyStored() == this.getEnergy(tool).getMaxEnergyStored()) {
            return false;
        }
        for (Direction side : Direction.values()) {
            IEnergyStorage storage = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, side).orElse(null);
            if (storage == null) {
                return false;
            }
            if (!storage.canExtract()) continue;
            int energy = storage.extractEnergy(this.getEnergy(tool).receiveEnergy(storage.extractEnergy(this.getEnergy(tool).getMaxEnergyStored() - this.getEnergy(tool).getEnergyStored(), true), false), false);
            this.getEnergy(tool).receiveEnergy(energy, false);
            return true;
        }
        IEnergyStorage storage = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY).orElse(null);
        if (storage == null) {
            return false;
        }
        if (storage.canExtract()) {
            int energy = storage.extractEnergy(this.getEnergy(tool).receiveEnergy(storage.extractEnergy(this.getEnergy(tool).getMaxEnergyStored() - this.getEnergy(tool).getEnergyStored(), true), false), false);
            this.getEnergy(tool).receiveEnergy(energy, false);
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return super.onItemUseFirst(stack, context);
        }
        BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
        if (this.chargeFromEnergyBlock(be, context.m_43722_())) {
            Objects.requireNonNull(context.m_43723_()).m_5496_((SoundEvent)NCSounds.ITEM_CHARGED.get(), 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.f_46443_) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        if (pPlayer.m_20161_()) {
            ItemStack tool = pPlayer.m_21120_(pUsedHand);
            Mode miningMode = Mode.values()[(QNP.getMode(tool).ordinal() + 1) % Mode.values().length];
            tool.m_41784_().m_128405_("mode", miningMode.ordinal());
            pPlayer.m_213846_((Component)TextUtils.__("tooltip.nc.qnp_mode", miningMode.getName()).m_130940_(ChatFormatting.GREEN));
            return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pUsedHand));
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemEnergyHandler(stack, this.getEnergyMaxStorage(), 0, this.getEnergyMaxStorage() / 4);
    }

    public CustomEnergyStorage getEnergy(ItemStack stack) {
        return (CustomEnergyStorage)((Object)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)TextUtils.__("tooltip.nc.qnp_mode", TextUtils.__("tooltip.mode." + QNP.getMode(stack).getName(), new Object[0])).m_130940_(ChatFormatting.BLUE));
        list.add((Component)TextUtils.__("tooltip.nc.shift_rbm_to_change", new Object[0]).m_130940_(ChatFormatting.GRAY));
        if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
            list.add((Component)TextUtils.__("tooltip.nc.eu_energy_stored", GTUtils.formatEUEnergy(this.getEnergy(stack).getEnergyStored()), GTUtils.formatEUEnergy(this.getEnergyMaxStorage())).m_130940_(ChatFormatting.GOLD));
        }
        if (!ModUtil.isGtLoaded() || !GTUtils.isOnlyGTCEUCapEnabled()) {
            list.add((Component)TextUtils.__("tooltip.nc.energy_stored", this.formatEnergy(this.getEnergy(stack).getEnergyStored()), this.formatEnergy(this.getEnergyMaxStorage())).m_130940_(ChatFormatting.BLUE));
        }
    }

    public String formatEnergy(int energy) {
        return TextUtils.numberFormat(energy / 1000) + " KFE";
    }

    public static enum Mode {
        ONE_BLOCK("1", 0, false),
        THREE_BY_THREE("3x3", 1, false),
        THREE_BY_THREE_BY_THREE("3x3x3", 1, true),
        FIVE_BY_FIVE("5x5", 2, false),
        FIVE_BY_FIVE_BY_FIVE("5x5x5", 2, true),
        SEVEN_BY_SEVEN("7x7", 3, false),
        VEIN_MINER("vein", 0, false);

        private final String name;
        public final int radius;
        public final boolean depth;

        public String getName() {
            return this.name;
        }

        private Mode(String name, int radius, boolean depth) {
            this.name = name;
            this.radius = radius;
            this.depth = depth;
        }
    }
}

