/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.mixin;

import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.radiation.data.PlayerRadiation;
import mekanism.api.Coord4D;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RadiationManager.class}, remap=false)
public abstract class MekRadiationManager {
    public boolean isMekRadiationEnabled() {
        return MekanismConfig.general.radiationEnabled.getOrDefault();
    }

    @Inject(method={"isRadiationEnabled"}, at={@At(value="TAIL")}, remap=false, cancellable=true)
    public void isRadiationEnabled(CallbackInfoReturnable<Boolean> callback) {
        if (!((Boolean)RadiationConfig.RADIATION_CONFIG.MEKANISM_RADIATION_INTEGRATION.get()).booleanValue()) {
            return;
        }
        callback.setReturnValue((Object)true);
    }

    @Inject(method={"radiate(Lmekanism/api/Coord4D;D)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void radiate(Coord4D source, double magnitude, CallbackInfo callback) {
        if (!((Boolean)RadiationConfig.RADIATION_CONFIG.MEKANISM_RADIATION_INTEGRATION.get()).booleanValue()) {
            return;
        }
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(source.dimension);
        if (level == null) {
            return;
        }
        igentuman.nc.radiation.data.RadiationManager.get((Level)level).addRadiation((Level)level, magnitude * 10.0, source.getX(), source.getY(), source.getZ());
        if (!this.isMekRadiationEnabled()) {
            callback.cancel();
        }
    }

    @Inject(method={"getRadiationResistance(Lnet/minecraft/world/entity/LivingEntity;)D"}, at={@At(value="TAIL")}, remap=false, cancellable=true)
    private void getRadiationResistance(LivingEntity entity, CallbackInfoReturnable<Double> callback) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            double shieldingRate = (double)PlayerRadiation.getRadiationShielding((LivingEntity)player, "nuclearcraft") / 10.0;
            callback.setReturnValue((Object)((Double)callback.getReturnValue() + shieldingRate));
        }
    }
}

