/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.accelerator;

import com.google.gson.JsonArray;
import igentuman.nc.block.accelerator.AcceleratorBeamPortBlock;
import igentuman.nc.block.accelerator.AcceleratorBlock;
import igentuman.nc.block.accelerator.AcceleratorIonSourcePortBlock;
import igentuman.nc.block.accelerator.AcceleratorOrientedBlock;
import igentuman.nc.block.accelerator.AcceleratorPortBlock;
import igentuman.nc.block.accelerator.CoolerBlock;
import igentuman.nc.block.accelerator.LinearAcceleratorControllerBlock;
import igentuman.nc.block.accelerator.RingAcceleratorControllerBlock;
import igentuman.nc.block.accelerator.entity.AcceleratorBeamPortBE;
import igentuman.nc.block.accelerator.entity.AcceleratorIonSourcePortBE;
import igentuman.nc.block.accelerator.entity.AcceleratorPortBE;
import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import igentuman.nc.block.accelerator.entity.RingAcceleratorControllerBE;
import igentuman.nc.container.AcceleratorIonSourcePortContainer;
import igentuman.nc.container.AcceleratorPortContainer;
import igentuman.nc.container.LinearAcceleratorContainer;
import igentuman.nc.container.RingAcceleratorContainer;
import igentuman.nc.multiblock.accelerator.CoolerDef;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.setup.registration.Tags;
import igentuman.nc.util.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.RegistryObject;

public class AcceleratorRegistration {
    public static final Item.Properties ACCELERATOR_ITEM_PROPERTIES = new Item.Properties();
    public static final BlockBehaviour.Properties NO_OCCLUSION_BLOCK_PROPS = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_60999_().m_60955_();
    public static final BlockBehaviour.Properties ACCELERATOR_BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(4.0f).m_60999_();
    public static final HashMap<String, RegistryObject<Block>> ACCELERATOR_BLOCKS = new HashMap();
    public static final HashMap<String, RegistryObject<BlockEntityType<? extends BlockEntity>>> ACCELERATOR_BE = new HashMap();
    public static final HashMap<String, RegistryObject<Item>> ACCELERATOR_ITEMS = new HashMap();
    public static final TagKey<Block> ACCELERATOR_CASING_BLOCKS = Tags.blockTag("accelerator_casing");
    public static final TagKey<Block> ACCELERATOR_INNER_BLOCKS = Tags.blockTag("accelerator_inner");
    public static final TagKey<Item> ACCELERATOR_INNER_ITEMS = Tags.itemTag("accelerator_inner");
    public static final TagKey<Item> ACCELERATOR_CASING_ITEMS = Tags.itemTag("accelerator_casing");
    public static final Pattern TRANSPARENT_BLOCKS_PATTERN = Pattern.compile(".*glass.*");
    public static final RegistryObject<MenuType<LinearAcceleratorContainer>> LINEAR_ACCELERATOR_CONTROLLER_CONTAINER = Registries.CONTAINERS.register("linear_accelerator_controller", () -> IForgeMenuType.create((windowId, inv, data) -> new LinearAcceleratorContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<MenuType<RingAcceleratorContainer>> THOROIDAL_ACCELERATOR_CONTROLLER_CONTAINER = Registries.CONTAINERS.register("ring_accelerator_controller", () -> IForgeMenuType.create((windowId, inv, data) -> new RingAcceleratorContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<MenuType<AcceleratorPortContainer>> ACCELERATOR_PORT_CONTAINER = Registries.CONTAINERS.register("accelerator_port", () -> IForgeMenuType.create((windowId, inv, data) -> new AcceleratorPortContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<MenuType<AcceleratorIonSourcePortContainer>> ACCELERATOR_ION_SOURCE_PORT_CONTAINER = Registries.CONTAINERS.register("accelerator_ion_source_port", () -> IForgeMenuType.create((windowId, inv, data) -> new AcceleratorIonSourcePortContainer(windowId, data.m_130135_(), inv)));
    public static final HashMap<String, CoolerDef> COOLERS = AcceleratorRegistration.coolers();
    private static final List<RegistryObject<Block>> COOLER_BLOCKS = new ArrayList<RegistryObject<Block>>();

    public static void init() {
        AcceleratorRegistration.registerSimpleBlock("accelerator_casing");
        AcceleratorRegistration.registerSimpleBlock("electromagnet_yoke");
        AcceleratorRegistration.registerSimpleBlock("accelerator_casing_glass");
        AcceleratorRegistration.registerSimpleBlock("particle_beam");
        AcceleratorRegistration.registerOrientedBlock("linear_accelerator_controller");
        AcceleratorRegistration.registerOrientedBlock("ring_accelerator_controller");
        AcceleratorRegistration.registerOrientedBlock("accelerator_port");
        AcceleratorRegistration.registerOrientedBlock("accelerator_beam_port");
        AcceleratorRegistration.registerOrientedBlock("accelerator_ion_source_port");
        ACCELERATOR_BE.put("accelerator_port", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("accelerator_port", () -> BlockEntityType.Builder.m_155273_(AcceleratorPortBE::new, (Block[])new Block[]{(Block)ACCELERATOR_BLOCKS.get("accelerator_port").get()}).m_58966_(null)));
        ACCELERATOR_BE.put("accelerator_beam_port", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("accelerator_beam_port", () -> BlockEntityType.Builder.m_155273_(AcceleratorBeamPortBE::new, (Block[])new Block[]{(Block)ACCELERATOR_BLOCKS.get("accelerator_beam_port").get()}).m_58966_(null)));
        ACCELERATOR_BE.put("accelerator_ion_source_port", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("accelerator_ion_source_port", () -> BlockEntityType.Builder.m_155273_(AcceleratorIonSourcePortBE::new, (Block[])new Block[]{(Block)ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get()}).m_58966_(null)));
        ACCELERATOR_BE.put("linear_accelerator_controller", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("linear_accelerator_controller", () -> BlockEntityType.Builder.m_155273_(LinearAcceleratorControllerBE::new, (Block[])new Block[]{(Block)ACCELERATOR_BLOCKS.get("linear_accelerator_controller").get()}).m_58966_(null)));
        ACCELERATOR_BE.put("ring_accelerator_controller", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("ring_accelerator_controller", () -> BlockEntityType.Builder.m_155273_(RingAcceleratorControllerBE::new, (Block[])new Block[]{(Block)ACCELERATOR_BLOCKS.get("ring_accelerator_controller").get()}).m_58966_(null)));
        for (String name : COOLERS.keySet()) {
            ACCELERATOR_BLOCKS.put(name + "_cooler", (RegistryObject<Block>)Registries.BLOCKS.register(name + "_cooler", () -> new CoolerBlock(ACCELERATOR_BLOCK_PROPERTIES, COOLERS.get(name))));
            ACCELERATOR_ITEMS.put(name + "_cooler", NCBlocks.fromMultiblock(ACCELERATOR_BLOCKS.get(name + "_cooler")));
            NCItems.ALL_NC_ITEMS.put(name + "_cooler", ACCELERATOR_ITEMS.get(name + "_cooler"));
            if (name.contains("empty")) continue;
            COOLER_BLOCKS.add(ACCELERATOR_BLOCKS.get(name + "_cooler"));
        }
    }

    private static void registerOrientedBlock(String key) {
        BlockBehaviour.Properties props = TRANSPARENT_BLOCKS_PATTERN.matcher(key).matches() ? NO_OCCLUSION_BLOCK_PROPS : ACCELERATOR_BLOCK_PROPERTIES;
        switch (key) {
            case "linear_accelerator_controller": {
                ACCELERATOR_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new LinearAcceleratorControllerBlock(props)));
                break;
            }
            case "ring_accelerator_controller": {
                ACCELERATOR_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new RingAcceleratorControllerBlock(props)));
                break;
            }
            case "accelerator_ion_source_port": {
                ACCELERATOR_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new AcceleratorIonSourcePortBlock(props)));
                break;
            }
            case "accelerator_port": {
                ACCELERATOR_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new AcceleratorPortBlock(props)));
                break;
            }
            case "accelerator_beam_port": {
                ACCELERATOR_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new AcceleratorBeamPortBlock(props)));
                break;
            }
            default: {
                ACCELERATOR_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new AcceleratorOrientedBlock(props)));
            }
        }
        ACCELERATOR_ITEMS.put(key, NCBlocks.fromMultiblock(ACCELERATOR_BLOCKS.get(key)));
        NCItems.ALL_NC_ITEMS.put(key, ACCELERATOR_ITEMS.get(key));
    }

    private static void registerSimpleBlock(String key) {
        BlockBehaviour.Properties props = TRANSPARENT_BLOCKS_PATTERN.matcher(key).matches() ? NO_OCCLUSION_BLOCK_PROPS : ACCELERATOR_BLOCK_PROPERTIES;
        ACCELERATOR_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new AcceleratorBlock(props)));
        ACCELERATOR_ITEMS.put(key, NCBlocks.fromMultiblock(ACCELERATOR_BLOCKS.get(key)));
        NCItems.ALL_NC_ITEMS.put(key, ACCELERATOR_ITEMS.get(key));
    }

    public static HashMap<String, CoolerDef> coolers() {
        HashMap<String, CoolerDef> tmp = new HashMap<String, CoolerDef>();
        List<JsonArray> data = JSONUtil.loadAllJsonFromConfig("accelerator_coolers");
        if (data == null) {
            return tmp;
        }
        for (JsonArray array : data) {
            for (int i = 0; i < array.size(); ++i) {
                CoolerDef heatSink = CoolerDef.of(array.get(i).getAsJsonObject());
                if (heatSink == null) continue;
                tmp.put(heatSink.name, heatSink);
            }
        }
        return tmp;
    }

    public static Block[] getCoolerBlocks() {
        Block[] blocks = new Block[COOLER_BLOCKS.size()];
        int i = 0;
        for (RegistryObject<Block> b : COOLER_BLOCKS) {
            blocks[i] = (Block)b.get();
            ++i;
        }
        return blocks;
    }
}

