/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.accelerator;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import igentuman.nc.NuclearCraft;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.util.NcUtils;
import igentuman.nc.util.StackUtils;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class CoolerDef {
    public double heat = 0.0;
    public String name = "";
    public String[] rules;
    protected Validator validator;

    public static CoolerDef of(JsonObject asJsonObject) {
        CoolerDef def = new CoolerDef();
        try {
            def.heat = asJsonObject.get("heat").getAsDouble();
            def.name = asJsonObject.get("type").getAsString();
            JsonArray rules = asJsonObject.getAsJsonArray("placement_rule");
            String[] ruleArray = new String[rules.size()];
            for (int i = 0; i < rules.size(); ++i) {
                ruleArray[i] = rules.get(i).getAsString();
            }
            def.rules = ruleArray;
            return def;
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("Error parsing heatsink definition: " + e.getMessage());
            return null;
        }
    }

    public Validator getValidator() {
        if (this.validator == null) {
            this.initCondition(this.rules);
        }
        return this.validator;
    }

    private CoolerDef() {
    }

    private void initCondition(String[] rules) {
        HashMap<String[], List<String>> conditions = new HashMap<String[], List<String>>();
        for (String rule : rules) {
            int cnt = 1;
            try {
                cnt = Math.max(Integer.parseInt(rule.substring(rule.length() - 1)), 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] conditionParts = rule.split("=|-|>|<|\\^");
            String[] blocks = conditionParts[0].split("\\|");
            List<String> actualBlocks = this.collectBlocks(blocks);
            conditions.put(new String[]{this.getConditionFunc(rule), String.valueOf(cnt), rule}, actualBlocks);
        }
        this.validator = new Validator(conditions);
    }

    private String getConditionFunc(String rule) {
        Pattern func = Pattern.compile("=|-|>|<|\\^");
        Matcher matcher = func.matcher(rule);
        ArrayList<String> matches = new ArrayList<String>();
        String funcType = ">";
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        if (!matches.isEmpty()) {
            funcType = (String)matches.get(0);
        }
        return funcType;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> collectBlocks(String[] blocks) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String string : blocks) {
            void var6_6;
            if (string.contains("#")) {
                tmp.addAll(StackUtils.getItemsByTagKey(string.replace("#", "")));
                continue;
            }
            if (!string.contains(":")) {
                String string2 = "nuclearcraft:" + string;
            }
            tmp.add((String)var6_6);
        }
        return tmp;
    }

    public double getHeat() {
        return this.heat;
    }

    public static class Validator {
        private final HashMap<String[], List<String>> blockLines;
        private final HashMap<String[], List<Block>> blocks = new HashMap();

        public Validator(HashMap<String[], List<String>> conditions) {
            this.blockLines = conditions;
        }

        public boolean isValid(Level level, BlockPos pos, AbstractMultiblock multiblock) {
            boolean result = false;
            BlockPos p = new BlockPos((Vec3i)pos);
            for (String[] condition : this.blocks().keySet()) {
                if (result = (switch (condition[0]) {
                    case ">" -> this.isMoreThan(Integer.parseInt(condition[1]), condition, level, p, multiblock);
                    case "<" -> this.isLessThan(Integer.parseInt(condition[1]), condition, level, p, multiblock);
                    case "-" -> this.isBetween(condition, level, p, multiblock);
                    case "=" -> this.isExact(Integer.parseInt(condition[1]), condition, level, p, multiblock);
                    case "^" -> this.inCorner(Integer.parseInt(condition[1]), condition, level, p, multiblock);
                    default -> result;
                })) continue;
                return false;
            }
            return result;
        }

        private BlockState getBlockState(Level level, BlockPos pos, AbstractMultiblock multiblock) {
            BlockState target = null;
            if (multiblock != null) {
                target = multiblock.getBlockState(pos);
            }
            if (target == null) {
                target = level.m_8055_(pos);
            }
            return target;
        }

        private boolean inCorner(int qty, String[] condition, Level level, BlockPos pos, AbstractMultiblock multiblock) {
            int initial = this.blocks.get(condition).contains(this.getBlockState(level, pos.m_6630_(1), multiblock).m_60734_()) ? 1 : 0;
            initial = this.blocks.get(condition).contains(this.getBlockState(level, pos.m_6625_(1), multiblock).m_60734_()) ? 1 : initial;
            int[] matches = new int[4];
            int i = 0;
            for (Direction dir : List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST)) {
                if (this.blocks.get(condition).contains(this.getBlockState(level, pos.m_121945_(dir), multiblock).m_60734_())) {
                    if (1 + initial >= qty) {
                        return true;
                    }
                    matches[i] = 1;
                }
                ++i;
            }
            for (int k = 0; k < 4; ++k) {
                int next = k + 1;
                if (next > 3) {
                    next = 0;
                }
                if (matches[k] + matches[next] + initial < qty) continue;
                return true;
            }
            return false;
        }

        private boolean isExact(int s, String[] condition, Level level, BlockPos pos, AbstractMultiblock multiblock) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!this.blocks.get(condition).contains(this.getBlockState(level, pos.m_121945_(dir), multiblock).m_60734_()) || ++counter <= s) continue;
                return false;
            }
            return counter == s;
        }

        private boolean isBetween(String[] condition, Level level, BlockPos pos, AbstractMultiblock multiblock) {
            for (Direction dir : Direction.values()) {
                if (!this.blocks.get(condition).contains(this.getBlockState(level, pos.m_121945_(dir), multiblock).m_60734_()) || !this.blocks.get(condition).contains(this.getBlockState(level, pos.m_121945_(dir.m_122424_()), multiblock).m_60734_())) continue;
                return true;
            }
            return false;
        }

        private boolean isLessThan(int s, String[] condition, Level level, BlockPos pos, AbstractMultiblock multiblock) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!this.blocks.get(condition).contains(this.getBlockState(level, pos.m_121945_(dir), multiblock).m_60734_()) || ++counter < s) continue;
                return false;
            }
            return counter < s;
        }

        private boolean isMoreThan(int s, String[] condition, Level level, BlockPos pos, AbstractMultiblock multiblock) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                BlockState target = this.getBlockState(level, pos.m_121945_(dir), multiblock);
                if (!this.blocks.get(condition).contains(target.m_60734_()) || ++counter < s) continue;
                return true;
            }
            return counter >= s;
        }

        public HashMap<String[], List<String>> blockLines() {
            return this.blockLines;
        }

        /*
         * WARNING - void declaration
         */
        public HashMap<String[], List<Block>> blocks() {
            if (this.blocks.isEmpty()) {
                for (String[] condition : this.blockLines().keySet()) {
                    ArrayList<Block> tmp = new ArrayList<Block>();
                    for (String string : this.blockLines().get(condition)) {
                        void var5_5;
                        if (string.contains("#")) {
                            tmp.addAll(TagUtil.getBlocksByTagKey(string));
                            continue;
                        }
                        if (!string.contains(":")) {
                            String string2 = "nuclearcraft:" + string;
                        }
                        tmp.add((Block)ForgeRegistries.BLOCKS.getValue(NcUtils.rlFromString((String)var5_5)));
                    }
                    this.blocks.put(condition, tmp);
                }
            }
            return this.blocks;
        }
    }
}

