/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.accelerator;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.accelerator.AbstractAcceleratorMultiblock;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.accelerator.LinearAcceleratorController;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.TagUtil;
import igentuman.nc.util.math.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class LinearAcceleratorMultiblock
extends AbstractAcceleratorMultiblock {
    private LinearAcceleratorControllerBE controllerBe;

    public LinearAcceleratorMultiblock(LinearAcceleratorControllerBE controller) {
        super(TagUtil.getBlocksByTagKey(AcceleratorRegistration.ACCELERATOR_CASING_BLOCKS.f_203868_().toString()), TagUtil.getBlocksByTagKey(AcceleratorRegistration.ACCELERATOR_INNER_BLOCKS.f_203868_().toString()), new LinearAcceleratorController(controller));
        this.id = "linear_accelerator_" + controller.m_58899_().m_123344_();
        this.controllerBe = controller;
        MultiblockHandler.get((ResourceKey<Level>)this.getLevel().m_46472_()).addMultiblock(this);
    }

    @Override
    public LinearAcceleratorController controller() {
        return (LinearAcceleratorController)this.controller;
    }

    @Override
    protected LinearAcceleratorControllerBE controllerBE() {
        if (this.controllerBe == null) {
            this.controllerBe = this.controller().controllerBE();
        }
        return this.controllerBe;
    }

    @Override
    protected Direction getControllerDirection() {
        return this.controllerBE().getFacing();
    }

    @Override
    public void clearStats() {
        this.controller().clearStats();
    }

    @Override
    public void validateOuter() {
        BlockState bs;
        this.topRight = null;
        this.bottomLeft = null;
        this.initialPos = null;
        this.beamPorts.clear();
        this.validationResult = ValidationResult.INCOMPLETE;
        this.stage = 4;
        this.initialPos = BlockPosInstance.copy(this.controller().controllerBE().m_58899_());
        this.multiblockDirection = null;
        this.controllers.clear();
        this.connectedPorts = 0;
        this.width = 0;
        this.depth = 0;
        this.height = 0;
        this.outerValid = false;
        this.resolveHeight();
        if (this.height != this.maxHeight()) {
            this.validationResult = ValidationResult.INCOMPLETE;
            return;
        }
        this.resolveDepth();
        this.resolveWidth();
        boolean controllerOnSide = this.isControllerPlacedOnSide();
        if (controllerOnSide) {
            if (this.width > this.maxWidth()) {
                this.validationResult = ValidationResult.TOO_BIG;
                return;
            }
            if (this.width < this.minWidth()) {
                this.validationResult = ValidationResult.TOO_SMALL;
                return;
            }
        }
        if (!controllerOnSide) {
            if (this.depth > this.maxDepth()) {
                this.validationResult = ValidationResult.TOO_BIG;
                return;
            }
            if (this.depth < this.minDepth()) {
                this.validationResult = ValidationResult.TOO_SMALL;
                return;
            }
        }
        BlockPosInstance leftFront = new BlockPosInstance((Vec3i)this.getLeftPos(this.leftCasing));
        BlockPosInstance leftBack = new BlockPosInstance((Vec3i)this.getLeftPos(this.leftCasing).m_5484_(this.getControllerDirection(), -this.depth + 1));
        BlockPosInstance rightFront = new BlockPosInstance((Vec3i)this.getRightPos(this.rightCasing));
        BlockPosInstance rightBack = new BlockPosInstance((Vec3i)this.getRightPos(this.rightCasing).m_5484_(this.getControllerDirection(), -this.depth + 1));
        int minX = MathUtils.min(leftFront.m_123341_(), rightFront.m_123341_(), leftBack.m_123341_(), rightBack.m_123341_());
        int minZ = MathUtils.min(leftFront.m_123343_(), rightFront.m_123343_(), leftBack.m_123343_(), rightBack.m_123343_());
        int maxX = MathUtils.max(leftFront.m_123341_(), rightFront.m_123341_(), leftBack.m_123341_(), rightBack.m_123341_());
        int maxZ = MathUtils.max(leftFront.m_123343_(), rightFront.m_123343_(), leftBack.m_123343_(), rightBack.m_123343_());
        this.bottomLeft = new BlockPosInstance(minX, leftFront.m_123342_() - this.bottomCasing, minZ);
        this.topRight = new BlockPosInstance(maxX, leftFront.m_123342_() + this.topCasing, maxZ);
        this.cacheBlockStates(null);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    if (y != 0 && x != 0 && z != 0 && y != this.height - 1 && x != this.width - 1 && z != this.depth - 1) continue;
                    if (!((y != 0 && y != this.height - 1 || z != 0 && z != this.depth - 1) && (y != 0 && y != this.height - 1 || x != 0 && x != this.width - 1) && (z != 0 && z != this.depth - 1 || x != 0 && x != this.width - 1))) {
                        if (!this.isValidCorner(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z))) {
                            this.validationResult = ValidationResult.WRONG_CORNER;
                            this.errorBlockPos = new BlockPos((Vec3i)this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z));
                            return;
                        }
                    } else if (!this.isValidForOuter(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z))) {
                        this.validationResult = ValidationResult.WRONG_OUTER;
                        this.errorBlockPos = new BlockPos((Vec3i)this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z));
                        return;
                    }
                    this.processOuterBlock(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z));
                }
            }
        }
        if (maxX - minX == 4) {
            this.centerPos = new BlockPosInstance((minX + maxX) / 2, this.bottomLeft.m_123342_() + 2, minZ);
            this.multiblockDirection = Direction.SOUTH;
        }
        if (maxZ - minZ == 4) {
            this.centerPos = new BlockPosInstance(minX, this.bottomLeft.m_123342_() + 2, (minZ + maxZ) / 2);
            this.multiblockDirection = Direction.EAST;
        }
        if ((bs = this.getBlockState(this.centerPos)).m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get())) {
            this.beamPorts.add(this.centerPos.m_121878_());
        }
        if (!bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get()) && !bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get())) {
            this.validationResult = ValidationResult.WRONG_BLOCK;
            this.errorBlockPos = new BlockPosInstance((Vec3i)this.centerPos);
            return;
        }
        this.ionSourcePos = bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get()) ? new BlockPosInstance((Vec3i)this.centerPos) : BlockPos.f_121853_;
        this.initialPos = BlockPosInstance.copy(this.centerPos);
        bs = this.getBlockState(this.centerPos.relative(this.multiblockDirection, Math.max(this.width - 1, this.depth - 1)));
        if (bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get())) {
            this.beamPorts.add(this.centerPos.m_121878_());
        }
        if (!bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get()) && !bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get())) {
            this.validationResult = ValidationResult.WRONG_BLOCK;
            this.errorBlockPos = new BlockPosInstance((Vec3i)this.centerPos);
            return;
        }
        if (!this.ionSourcePos.equals((Object)BlockPos.f_121853_) && bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get())) {
            this.validationResult = ValidationResult.WRONG_BLOCK;
            this.errorBlockPos = new BlockPosInstance((Vec3i)this.centerPos);
            return;
        }
        if (this.controllers.size() > 1) {
            this.validationResult = ValidationResult.TOO_MANY_CONTROLLERS;
            return;
        }
        this.validationResult = ValidationResult.VALID;
        this.outerValid = true;
        this.stage = 1;
        this.hasToRefresh = true;
    }

    @Override
    public void validate() {
        this.isValidating = true;
        long startTime = System.currentTimeMillis();
        switch (this.stage) {
            case 0: {
                this.validateOuter();
                break;
            }
            case 1: {
                this.validateBeam();
                break;
            }
            case 2: {
                this.indexInnerBlocks();
                break;
            }
            case 3: {
                this.veryfyCoolers();
            }
        }
        NuclearCraft.debugLog("Accelerator validate stage " + this.stage + " " + this.initialPos().m_123344_() + " in " + (System.currentTimeMillis() - startTime) + "ms " + this.validationResult);
        if (this.stage < 4) {
            this.hasToRefresh = true;
            return;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        this.isFormed = this.outerValid && this.innerValid;
        this.focus = this.quadStrength + this.dipoleStrength / 2.0;
        if (this.isFormed) {
            this.validationResult = ValidationResult.VALID;
            this.errorBlockPos = BlockPos.f_121853_;
            this.controllerBE().ionSourcePos = this.ionSourcePos;
            this.controllerBE().beamLength = this.beamLength;
            this.controllerBE().amplifiers = this.amplifiers.size();
            this.controllerBE().coolers = this.validCoolers;
            this.controllerBE().quadroupoles = this.quadrupolesCount;
            this.controllerBE().dipoles = this.dipolesCount;
            this.controllerBE().focus = this.focus;
            this.controllerBE().maxTemperature = this.maxTemperature;
            this.controllerBE().heatRate = this.heatRate;
            this.controllerBE().efficiency = this.efficiency / (double)(this.amplifiers.size() + this.electromagnets.size());
            this.controllerBE().quadStrength = this.quadStrength;
            this.controllerBE().dipoleStrength = this.dipoleStrength;
            this.controllerBE().acceleratingVoltage = this.acceleratingVoltage;
            this.controllerBE().energyRequired = this.energyRequired;
            this.controllerBE().coolingRate = this.coolingRate;
            this.controllerBE().validationTime = elapsedTime;
            ++this.controllerBE().validationsCounter;
            this.hasToRefresh = false;
        } else {
            this.clearStats();
        }
        this.controllerBE().m_6596_();
        this.stage = 0;
        this.isValidating = false;
    }
}

