/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.accelerator;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.accelerator.entity.RingAcceleratorControllerBE;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.accelerator.AbstractAcceleratorMultiblock;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.accelerator.ThoroidalAcceleratorController;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.TagUtil;
import igentuman.nc.util.math.MathUtils;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ThoroidalAcceleratorMultiblock
extends AbstractAcceleratorMultiblock {
    private RingAcceleratorControllerBE controllerBe;

    public ThoroidalAcceleratorMultiblock(RingAcceleratorControllerBE controller) {
        super(TagUtil.getBlocksByTagKey(AcceleratorRegistration.ACCELERATOR_CASING_BLOCKS.f_203868_().toString()), TagUtil.getBlocksByTagKey(AcceleratorRegistration.ACCELERATOR_INNER_BLOCKS.f_203868_().toString()), new ThoroidalAcceleratorController(controller));
        this.id = "ring_accelerator_" + controller.m_58899_().m_123344_();
        this.controllerBe = controller;
        MultiblockHandler.get((ResourceKey<Level>)this.getLevel().m_46472_()).addMultiblock(this);
    }

    @Override
    public ThoroidalAcceleratorController controller() {
        return (ThoroidalAcceleratorController)this.controller;
    }

    @Override
    protected RingAcceleratorControllerBE controllerBE() {
        if (this.controllerBe == null) {
            this.controllerBe = this.controller().controllerBE();
        }
        return this.controllerBe;
    }

    @Override
    protected Direction getControllerDirection() {
        return this.controllerBE().getFacing();
    }

    @Override
    public void clearStats() {
        this.controller().clearStats();
    }

    @Override
    public void validateOuter() {
        this.topRight = null;
        this.bottomLeft = null;
        this.initialPos = null;
        this.beamPorts.clear();
        this.validationResult = ValidationResult.INCOMPLETE;
        this.stage = 4;
        this.initialPos = BlockPosInstance.copy(this.controller().controllerBE().m_58899_());
        this.multiblockDirection = null;
        this.controllers.clear();
        this.connectedPorts = 0;
        this.width = 0;
        this.depth = 0;
        this.height = 0;
        this.outerValid = false;
        this.resolveHeight();
        if (this.height != this.maxHeight()) {
            this.validationResult = ValidationResult.INCOMPLETE;
            return;
        }
        this.resolveDepth();
        this.resolveWidth();
        boolean controllerOnSide = this.isControllerPlacedOnSide();
        if (controllerOnSide) {
            if (this.width > this.maxWidth()) {
                this.validationResult = ValidationResult.TOO_BIG;
                return;
            }
            if (this.width < this.minWidth()) {
                this.validationResult = ValidationResult.TOO_SMALL;
                return;
            }
            this.resolveRealDepth();
        }
        if (!controllerOnSide) {
            if (this.depth > this.maxDepth()) {
                this.validationResult = ValidationResult.TOO_BIG;
                return;
            }
            if (this.depth < this.minDepth()) {
                this.validationResult = ValidationResult.TOO_SMALL;
                return;
            }
        }
        BlockPosInstance leftFront = new BlockPosInstance((Vec3i)this.getLeftPos(this.leftCasing));
        BlockPosInstance leftBack = new BlockPosInstance((Vec3i)this.getLeftPos(this.leftCasing).m_5484_(this.getControllerDirection(), -this.depth + 1));
        BlockPosInstance rightFront = new BlockPosInstance((Vec3i)this.getRightPos(this.rightCasing));
        BlockPosInstance rightBack = new BlockPosInstance((Vec3i)this.getRightPos(this.rightCasing).m_5484_(this.getControllerDirection(), -this.depth + 1));
        int minX = MathUtils.min(leftFront.m_123341_(), rightFront.m_123341_(), leftBack.m_123341_(), rightBack.m_123341_());
        int minZ = MathUtils.min(leftFront.m_123343_(), rightFront.m_123343_(), leftBack.m_123343_(), rightBack.m_123343_());
        int maxX = MathUtils.max(leftFront.m_123341_(), rightFront.m_123341_(), leftBack.m_123341_(), rightBack.m_123341_());
        int maxZ = MathUtils.max(leftFront.m_123343_(), rightFront.m_123343_(), leftBack.m_123343_(), rightBack.m_123343_());
        this.bottomLeft = new BlockPosInstance(minX, leftFront.m_123342_() - this.bottomCasing, minZ);
        this.topRight = new BlockPosInstance(maxX, leftFront.m_123342_() + this.topCasing, maxZ);
        AABB excludeArea = new AABB(new BlockPos((Vec3i)this.bottomLeft).m_7918_(4, -1, 4), new BlockPos((Vec3i)this.topRight).m_7918_(-4, 1, -4));
        this.cacheBlockStates(excludeArea);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    BlockPos toCheck = this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z);
                    if (excludeArea.m_82390_(toCheck.m_252807_()) || y != 0 && x != 0 && z != 0 && y != this.height - 1 && x != this.width - 1 && z != this.depth - 1) continue;
                    if (!((y != 0 && y != this.height - 1 || z != 0 && z != this.depth - 1) && (y != 0 && y != this.height - 1 || x != 0 && x != this.width - 1) && (z != 0 && z != this.depth - 1 || x != 0 && x != this.width - 1))) {
                        if (!this.isValidCorner(toCheck)) {
                            this.validationResult = ValidationResult.WRONG_CORNER;
                            this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                            return;
                        }
                    } else if (!this.isValidForOuter(toCheck)) {
                        this.validationResult = ValidationResult.WRONG_OUTER;
                        this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                        return;
                    }
                    this.processOuterBlock(toCheck);
                }
            }
        }
        BlockPos startingPos = new BlockPos((Vec3i)this.bottomLeft);
        BlockPos endingPos = new BlockPos((Vec3i)this.topRight);
        if (!this.validateInnerWalls(startingPos, endingPos)) {
            return;
        }
        if (this.controllers.size() > 1) {
            this.validationResult = ValidationResult.TOO_MANY_CONTROLLERS;
            return;
        }
        this.validationResult = ValidationResult.VALID;
        this.outerValid = true;
        this.stage = 1;
        this.hasToRefresh = true;
    }

    @Override
    protected void processOuterBlock(BlockPos pos) {
        super.processOuterBlock(pos);
        BlockState bs = this.getBlockState(pos);
        if (bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get())) {
            this.beamPorts.add(pos.m_121878_());
        }
    }

    private void resolveRealDepth() {
        NuclearCraft.debugLog("Resolving depth from position " + this.initialPos().m_123344_());
        for (int i = 1; i <= this.maxDepth() + 2; ++i) {
            if (this.isValidForOuter(this.getLeftPos(this.leftCasing).m_6625_(this.bottomCasing).m_5484_(this.getControllerDirection(), -i))) continue;
            this.depth = i;
            NuclearCraft.debugLog("Found depth boundary at offset " + i);
            break;
        }
        NuclearCraft.debugLog("Resolved real depth: " + this.depth);
    }

    private boolean validateInnerWalls(BlockPos startingPos, BlockPos endingPos) {
        NuclearCraft.debugLog("Validating inner walls of toroidal accelerator ring");
        int innerWallOffset = 4;
        BlockPos innerStart = startingPos.m_7918_(innerWallOffset, 0, innerWallOffset);
        BlockPos innerEnd = endingPos.m_7918_(-innerWallOffset, 0, -innerWallOffset);
        NuclearCraft.debugLog("Inner wall boundaries: " + innerStart.m_123344_() + " to " + innerEnd.m_123344_());
        if (!this.validateInnerWallFace(innerStart, innerEnd, Direction.Axis.X, true)) {
            NuclearCraft.debugLog("West inner wall validation failed");
            return false;
        }
        if (!this.validateInnerWallFace(innerStart, innerEnd, Direction.Axis.X, false)) {
            NuclearCraft.debugLog("East inner wall validation failed");
            return false;
        }
        if (!this.validateInnerWallFace(innerStart, innerEnd, Direction.Axis.Z, true)) {
            NuclearCraft.debugLog("North inner wall validation failed");
            return false;
        }
        if (!this.validateInnerWallFace(innerStart, innerEnd, Direction.Axis.Z, false)) {
            NuclearCraft.debugLog("South inner wall validation failed");
            return false;
        }
        NuclearCraft.debugLog("All inner walls validated successfully");
        return true;
    }

    private boolean validateInnerWallFace(BlockPos innerStart, BlockPos innerEnd, Direction.Axis axis, boolean isMinSide) {
        int wallCoordinate;
        NuclearCraft.debugLog("Validating inner wall face along " + axis + " axis, " + (isMinSide ? "min" : "max") + " side");
        switch (axis) {
            case X: {
                wallCoordinate = isMinSide ? innerStart.m_123341_() : innerEnd.m_123341_();
                break;
            }
            case Z: {
                wallCoordinate = isMinSide ? innerStart.m_123343_() : innerEnd.m_123343_();
                break;
            }
            default: {
                NuclearCraft.debugLog("Invalid axis for inner wall: " + axis);
                return false;
            }
        }
        for (int y = innerStart.m_123342_(); y <= innerEnd.m_123342_(); ++y) {
            BlockPos toCheck;
            if (axis == Direction.Axis.X) {
                for (int z = innerStart.m_123343_(); z <= innerEnd.m_123343_(); ++z) {
                    toCheck = new BlockPos(wallCoordinate, y, z);
                    if (this.validateInnerWallBlock(toCheck, y, innerStart.m_123342_(), innerEnd.m_123342_())) continue;
                    return false;
                }
                continue;
            }
            if (axis != Direction.Axis.Z) continue;
            for (int x = innerStart.m_123341_(); x <= innerEnd.m_123341_(); ++x) {
                toCheck = new BlockPos(x, y, wallCoordinate);
                if (this.validateInnerWallBlock(toCheck, y, innerStart.m_123342_(), innerEnd.m_123342_())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateInnerWallBlock(BlockPos toCheck, int y, int minY, int maxY) {
        boolean isCorner;
        boolean bl = isCorner = y == minY || y == maxY;
        if (isCorner) {
            if (!this.isValidCorner(toCheck)) {
                this.validationResult = ValidationResult.WRONG_CORNER;
                this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                NuclearCraft.debugLog("Invalid inner corner block at " + toCheck.m_123344_());
                return false;
            }
        } else if (!this.isValidForOuter(toCheck)) {
            this.validationResult = ValidationResult.WRONG_OUTER;
            this.errorBlockPos = new BlockPos((Vec3i)toCheck);
            NuclearCraft.debugLog("Invalid inner wall block at " + toCheck.m_123344_());
            return false;
        }
        this.processOuterBlock(toCheck);
        return true;
    }

    @Override
    protected void validateBeam() {
        this.stage = 4;
        this.depth -= 2;
        this.width -= 2;
        this.centerPos = new BlockPosInstance(this.bottomLeft.m_123341_() + 2, this.bottomLeft.m_123342_() + 2, this.bottomLeft.m_123343_() + 1);
        this.multiblockDirection = Direction.SOUTH;
        int tmpLength = 0;
        super.validateBeam();
        if (!this.validationResult.isValid) {
            return;
        }
        tmpLength += this.beamLength;
        this.centerPos = new BlockPosInstance(this.bottomLeft.m_123341_() + 1, this.bottomLeft.m_123342_() + 2, this.bottomLeft.m_123343_() + 2);
        this.multiblockDirection = Direction.EAST;
        super.validateBeam();
        if (!this.validationResult.isValid) {
            return;
        }
        tmpLength += this.beamLength;
        this.centerPos = new BlockPosInstance(this.topRight.m_123341_() - 2, this.topRight.m_123342_() - 2, this.topRight.m_123343_() - 1);
        this.multiblockDirection = Direction.NORTH;
        super.validateBeam();
        if (!this.validationResult.isValid) {
            return;
        }
        tmpLength += this.beamLength;
        this.centerPos = new BlockPosInstance(this.topRight.m_123341_() - 1, this.topRight.m_123342_() - 2, this.topRight.m_123343_() - 2);
        this.multiblockDirection = Direction.WEST;
        super.validateBeam();
        if (!this.validationResult.isValid) {
            return;
        }
        this.beamLength = (tmpLength += this.beamLength) - 12;
        this.depth += 2;
        this.width += 2;
        Iterator iterator = this.beamPorts.iterator();
        while (iterator.hasNext()) {
            long packed = (Long)iterator.next();
            Direction dir = (Direction)this.getBlockState(packed).m_61143_((Property)BlockStateProperties.f_61374_);
            BlockPos pos = BlockPos.m_122022_((long)packed);
            for (int i = 1; i < 7; ++i) {
                if (this.getBlockState(pos.m_5484_(dir.m_122424_(), i)).m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("particle_beam").get())) continue;
                this.validationResult = ValidationResult.WRONG_INNER;
                this.errorBlockPos = new BlockPosInstance((Vec3i)pos.m_5484_(dir.m_122424_(), i));
                this.innerValid = false;
                this.stage = 4;
                return;
            }
        }
        this.stage = 2;
    }

    @Override
    public void indexInnerBlocks() {
        int z;
        this.stage = 4;
        this.innerValid = false;
        this.acceleratingVoltage = 0L;
        this.heatRate = 0;
        this.maxTemperature = Integer.MAX_VALUE;
        this.efficiency = 0.0;
        this.quadrupolesCount = 0;
        this.dipolesCount = 0;
        this.quadStrength = 0.0;
        this.dipoleStrength = 0.0;
        this.focus = 0.0;
        this.energyRequired = 0;
        this.initialPos = new BlockPosInstance(this.bottomLeft.m_123341_() + 2, this.bottomLeft.m_123342_() + 2, this.bottomLeft.m_123343_() + 2);
        this.multiblockDirection = Direction.SOUTH;
        for (z = 1; z < Math.max(this.depth, this.width) - 4; ++z) {
            if (this.indexSlice(z)) continue;
            return;
        }
        this.multiblockDirection = Direction.EAST;
        for (z = 1; z < Math.max(this.depth, this.width) - 4; ++z) {
            if (this.indexSlice(z)) continue;
            return;
        }
        this.initialPos = new BlockPosInstance(this.topRight.m_123341_() - 2, this.topRight.m_123342_() - 2, this.topRight.m_123343_() - 2);
        this.multiblockDirection = Direction.NORTH;
        for (z = 1; z < Math.max(this.depth, this.width) - 4; ++z) {
            if (this.indexSlice(z)) continue;
            return;
        }
        this.multiblockDirection = Direction.WEST;
        for (z = 1; z < Math.max(this.depth, this.width) - 4; ++z) {
            if (this.indexSlice(z)) continue;
            return;
        }
        this.innerValid = true;
        this.validationResult = ValidationResult.VALID;
        this.stage = 3;
    }

    @Override
    public void validate() {
        long startTime = System.nanoTime();
        switch (this.stage) {
            case 0: {
                this.validateOuter();
                break;
            }
            case 1: {
                this.validateBeam();
                break;
            }
            case 2: {
                this.indexInnerBlocks();
                break;
            }
            case 3: {
                this.veryfyCoolers();
            }
        }
        NuclearCraft.debugLog("Accelerator validate stage " + this.stage + " " + this.initialPos().m_123344_() + " in " + (System.nanoTime() - startTime) / 1000000L + "ms " + this.validationResult);
        if (this.stage < 4) {
            this.hasToRefresh = true;
            return;
        }
        this.isFormed = this.outerValid && this.innerValid;
        this.focus = this.quadStrength + this.dipoleStrength / 2.0;
        if (this.isFormed) {
            this.validationResult = ValidationResult.VALID;
            this.errorBlockPos = BlockPos.f_121853_;
            this.controllerBE().ionSourcePos = this.ionSourcePos;
            this.controllerBE().beamLength = this.beamLength;
            this.controllerBE().amplifiers = this.amplifiers.size();
            this.controllerBE().coolers = this.validCoolers;
            this.controllerBE().quadroupoles = this.quadrupolesCount;
            this.controllerBE().dipoles = this.dipolesCount;
            this.controllerBE().focus = this.focus;
            this.controllerBE().maxTemperature = this.maxTemperature;
            this.controllerBE().heatRate = this.heatRate;
            this.controllerBE().efficiency = this.efficiency / (double)(this.amplifiers.size() + this.electromagnets.size());
            this.controllerBE().quadStrength = this.quadStrength;
            this.controllerBE().dipoleStrength = this.dipoleStrength;
            this.controllerBE().acceleratingVoltage = this.acceleratingVoltage;
            this.controllerBE().energyRequired = this.energyRequired;
            this.controllerBE().coolingRate = this.coolingRate;
            this.hasToRefresh = false;
        } else {
            this.clearStats();
        }
        this.controllerBE().m_6596_();
        this.stage = 0;
    }
}

