/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.kugelblitz;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.kugelblitz.entity.BlackHoleBE;
import igentuman.nc.block.kugelblitz.entity.ChamberTerminalBE;
import igentuman.nc.block.kugelblitz.entity.PhotonConcentratorBE;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.kugelblitz.KugelblitzController;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class KugelblitzMultiblock
extends AbstractMultiblock {
    protected ChamberTerminalBE controllerBe;
    protected final HashSet<Block> validCornerBlocks;
    public BlackHoleBE blackHole;
    protected BlockPos centerBlockPos;
    protected int transformers = 0;
    protected int fluxRegulators = 0;
    protected int stabilizers = 0;
    public boolean initialized = false;

    @Override
    public int maxHeight() {
        return 9;
    }

    @Override
    public int minHeight() {
        return 9;
    }

    @Override
    public int maxWidth() {
        return 9;
    }

    @Override
    public int minWidth() {
        return 9;
    }

    @Override
    public int maxDepth() {
        return 9;
    }

    @Override
    public int minDepth() {
        return 9;
    }

    @Override
    protected ChamberTerminalBE controllerBE() {
        if (this.controllerBe == null) {
            this.controllerBe = (ChamberTerminalBE)this.controller().controllerBE();
        }
        return this.controllerBe;
    }

    public BlockEntity getBlackHole() {
        if (this.getCenter() == null || this.getCenter().equals((Object)BlockPos.f_121853_)) {
            return null;
        }
        return this.getLevel().getExistingBlockEntity(this.getCenter());
    }

    @Override
    protected Direction getControllerDirection() {
        return this.controllerBE().getFacing();
    }

    public KugelblitzMultiblock(ChamberTerminalBE be) {
        super(TagUtil.getBlocksByTagKey(KugelblitzRegistration.CASING_BLOCKS.f_203868_().toString()), new HashSet<Block>(List.of((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("black_hole").get(), Blocks.f_50016_)), new KugelblitzController(be));
        this.id = "chamber_" + be.m_58899_().m_123344_();
        MultiblockHandler.get((ResourceKey<Level>)be.m_58904_().m_46472_()).addMultiblock(this);
        this.validCornerBlocks = new HashSet<Block>(List.of((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("neutronium_frame").get(), (Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_terminal").get(), (Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_port").get()));
    }

    @Override
    public void validate() {
        NuclearCraft.debugLog("=== Starting Kugelblitz Chamber validation at " + this.controllerPos.m_123344_() + " ===");
        super.validate();
        if (!(!this.initialized || this.outerValid && this.innerValid)) {
            NuclearCraft.debugLog("Kugelblitz chamber became invalid - removing black hole");
            this.removeBlackHole();
        }
        if (this.validationResult.isValid) {
            NuclearCraft.debugLog("Components - Transformers: " + this.transformers + ", Flux regulators: " + this.fluxRegulators + ", Stabilizers: " + this.stabilizers);
        } else {
            NuclearCraft.debugLog("Kugelblitz chamber validation failed with result: " + this.validationResult);
        }
        this.initialized = true;
    }

    @Override
    public int resolveDepth() {
        if (this.isValidForOuter(this.getForwardPos(6))) {
            this.depth = 6;
        }
        if (this.isValidForOuter(this.getForwardPos(8))) {
            this.depth = 8;
        }
        return this.depth;
    }

    protected int getTopY(int forward, int up) {
        if (this.isValidForOuter(this.getForwardPos(forward).m_6630_(up))) {
            return this.controllerBE().m_58899_().m_123342_() + up;
        }
        return 0;
    }

    @Override
    public void validateOuter() {
        this.fluxRegulators = 0;
        this.stabilizers = 0;
        this.transformers = 0;
        this.errorBlockPos = BlockPos.f_121853_;
        this.bottomLeft = null;
        this.topRight = null;
        this.controllers.clear();
        this.resolveWidth();
        this.resolveHeight();
        this.resolveDepth();
        this.outerValid = false;
        if (this.height() != 1 && this.width() != 5) {
            this.validationResult = ValidationResult.INCOMPLETE;
            return;
        }
        int topY = this.getTopY(2, 9);
        topY = topY != 0 ? topY : this.getTopY(2, 8);
        topY = topY != 0 ? topY : this.getTopY(2, 1);
        int n = topY = topY != 0 ? topY : this.getTopY(2, 2);
        if (topY == 0 || !this.isValidForOuter(this.getForwardPos(2).m_6625_(10 - (topY - this.controllerBE().m_58899_().m_123342_())))) {
            return;
        }
        int left = 0;
        int i = 0;
        while (i < 6 && this.isValidForOuter(this.getLeftPos(i))) {
            left = i++;
        }
        int forward = this.depth() == 8 ? -4 : -3;
        BlockPos l = this.getLeftPos(left - 2).m_5484_(this.getControllerDirection(), forward);
        BlockPos topCenter = new BlockPos(l.m_123341_(), topY, l.m_123343_());
        BlockEntity blockEntity = this.getLevel().getExistingBlockEntity(topCenter);
        if (!(blockEntity instanceof PhotonConcentratorBE)) {
            this.validationResult = ValidationResult.PHOTON_CONCENTRATOR;
            return;
        }
        PhotonConcentratorBE pcBE = (PhotonConcentratorBE)blockEntity;
        pcBE.setMultiblock(this);
        List<BlockState> topWall = this.getWallBlocks(Direction.Axis.Y, topCenter);
        if (topWall.size() != 25) {
            this.validationResult = ValidationResult.INCOMPLETE;
            return;
        }
        if (!(this.isWallValid(topWall, this.getWallBlocks(Direction.Axis.Y, topCenter.m_6625_(10))) && this.isWallValid(topWall, this.getWallBlocks(Direction.Axis.X, topCenter.m_6625_(5).m_122025_(5))) && this.isWallValid(topWall, this.getWallBlocks(Direction.Axis.X, topCenter.m_6625_(5).m_122030_(5))) && this.isWallValid(topWall, this.getWallBlocks(Direction.Axis.Z, topCenter.m_6625_(5).m_122013_(5))) && this.isWallValid(topWall, this.getWallBlocks(Direction.Axis.Z, topCenter.m_6625_(5).m_122020_(5))))) {
            this.validationResult = ValidationResult.ASYMETRIC_WALLS;
            return;
        }
        if (!(this.isFrameValid(Direction.Axis.Y, topCenter.m_6625_(1)) && this.isFrameValid(Direction.Axis.Y, topCenter.m_6625_(9)) && this.isFrameValid(Direction.Axis.X, topCenter.m_6625_(5).m_122025_(4)) && this.isFrameValid(Direction.Axis.X, topCenter.m_6625_(5).m_122030_(4)) && this.isFrameValid(Direction.Axis.Z, topCenter.m_6625_(5).m_122013_(4)) && this.isFrameValid(Direction.Axis.Z, topCenter.m_6625_(5).m_122020_(4)))) {
            this.validationResult = ValidationResult.INCOMPLETE;
            return;
        }
        if (!this.isCornersValid(topCenter.m_6625_(2)) || !this.isCornersValid(topCenter.m_6625_(8))) {
            this.validationResult = ValidationResult.INCOMPLETE;
            return;
        }
        if (this.controllers.size() > 1) {
            this.validationResult = ValidationResult.TOO_MANY_CONTROLLERS;
            return;
        }
        this.centerBlockPos = topCenter.m_6625_(5);
        this.bottomLeft = BlockPosInstance.of(topCenter.m_7918_(-3, -3, -3));
        this.topRight = BlockPosInstance.of(topCenter.m_7918_(3, 0, 3));
        this.validationResult = ValidationResult.VALID;
        this.outerValid = true;
    }

    @Override
    public void validateInner() {
        if (!this.outerValid) {
            this.clearStats();
            return;
        }
        if (this.centerBlockPos == null || this.centerBlockPos.equals((Object)BlockPos.f_121853_)) {
            this.validationResult = ValidationResult.INCOMPLETE;
            return;
        }
        int radius = 4;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    double distSquared = x * x + y * y + z * z;
                    if (!(distSquared <= 16.0)) continue;
                    BlockPos pos = this.centerBlockPos.m_7918_(x, y, z);
                    if (!this.isValidForInner(pos)) {
                        this.validationResult = ValidationResult.WRONG_INNER;
                        this.errorBlockPos = new BlockPos((Vec3i)pos);
                        return;
                    }
                    this.processInnerBlock(pos);
                }
            }
        }
        this.controllerBE().controllerEnabled = this.isFormed();
        this.controllerBE().fluxRegulators = this.fluxRegulators();
        this.controllerBE().transformers = this.transformers();
        this.controllerBE().stabilizers = this.stabilizers();
        this.controllerBE().blackholePos = this.getCenter();
        this.controllerBE().m_6596_();
        this.validationResult = ValidationResult.VALID;
        this.errorBlockPos = BlockPos.f_121853_;
        this.innerValid = true;
    }

    @Override
    public HashSet<Block> validCornerBlocks() {
        return this.validCornerBlocks;
    }

    private boolean isCornersValid(BlockPos center) {
        if (!(this.isValidForOuter(center.m_7918_(3, 0, 3)) && this.isValidForOuter(center.m_7918_(-3, 0, 3)) && this.isValidForOuter(center.m_7918_(3, 0, -3)) && this.isValidForOuter(center.m_7918_(-3, 0, -3)))) {
            return false;
        }
        this.processOuterBlock(center.m_7918_(3, 0, 3));
        this.processOuterBlock(center.m_7918_(-3, 0, 3));
        this.processOuterBlock(center.m_7918_(3, 0, -3));
        this.processOuterBlock(center.m_7918_(-3, 0, -3));
        return true;
    }

    private boolean isFrameValid(Direction.Axis axis, BlockPos center) {
        for (int i = -3; i <= 3; ++i) {
            for (int j = -3; j <= 3; ++j) {
                if (Math.abs(i) != 3 && Math.abs(j) != 3 || i == -3 && j == -3 || i == -3 && j == 3 || i == 3 && j == -3 || i == 3 && j == 3) continue;
                BlockPos posToCheck = axis == Direction.Axis.Y ? center.m_7918_(i, 0, j) : (axis == Direction.Axis.X ? center.m_7918_(0, i, j) : center.m_7918_(i, j, 0));
                if (!this.isValidCorner(posToCheck)) {
                    this.errorBlockPos = new BlockPos((Vec3i)posToCheck);
                    return false;
                }
                this.processOuterBlock(posToCheck);
            }
        }
        return true;
    }

    private boolean isWallValid(List<BlockState> initial, List<BlockState> toVerify) {
        if (initial.size() != toVerify.size()) {
            return false;
        }
        for (int i = 0; i < initial.size(); ++i) {
            if (initial.get(i).m_60713_(toVerify.get(i).m_60734_())) continue;
            return false;
        }
        return true;
    }

    private List<BlockState> getWallBlocks(Direction.Axis axis, BlockPos center) {
        ArrayList<BlockState> blocks = new ArrayList<BlockState>();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                BlockPos newPos = axis == Direction.Axis.Y ? center.m_7918_(i, 0, j) : (axis == Direction.Axis.X ? center.m_7918_(0, i, j) : center.m_7918_(i, j, 0));
                BlockState bs = this.getBlockState(newPos);
                if (bs.m_60795_() || !this.isValidForOuter(newPos)) {
                    this.errorBlockPos = new BlockPos((Vec3i)newPos);
                    return blocks;
                }
                if (bs.m_60713_((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("quantum_transformer").get())) {
                    ++this.transformers;
                }
                if (bs.m_60713_((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("quantum_flux_regulator").get())) {
                    ++this.fluxRegulators;
                }
                if (bs.m_60713_((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("event_horizon_stabilizer").get())) {
                    ++this.stabilizers;
                }
                blocks.add(bs);
                this.processOuterBlock(newPos);
            }
        }
        return blocks;
    }

    @Override
    public void tick(Level level) {
        super.tick(level);
        if (this.centerBlockPos == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockEntity blockEntity = this.getBlockEntity(this.getCenter().m_5484_(dir, 5), new boolean[0]);
            if (!(blockEntity instanceof PhotonConcentratorBE)) continue;
            PhotonConcentratorBE pcBE = (PhotonConcentratorBE)blockEntity;
            pcBE.setMultiblock(this);
        }
    }

    @Override
    public void clearStats() {
        this.controllerBE().controllerEnabled = false;
        this.controllerBE().fluxRegulators = 0;
        this.controllerBE().transformers = 0;
        this.controllerBE().stabilizers = 0;
        this.controllerBE().m_6596_();
    }

    public BlockPos getCenter() {
        return this.centerBlockPos;
    }

    public int fluxRegulators() {
        return this.fluxRegulators;
    }

    public int stabilizers() {
        return this.stabilizers;
    }

    public int transformers() {
        return this.transformers;
    }

    public void removeBlackHole() {
        if (this.blackHole != null) {
            this.getLevel().m_7731_(this.blackHole.m_58899_(), Blocks.f_50016_.m_49966_(), 3);
            this.blackHole = null;
            return;
        }
        this.getLevel().m_7731_(this.getCenter(), Blocks.f_50016_.m_49966_(), 3);
        this.blackHole = null;
    }

    @Override
    public void onControllerRemoved() {
        this.removeBlackHole();
        super.onControllerRemoved();
    }

    public void gotLaserBurst() {
        this.controllerBE().gotLaserBurst = true;
    }
}

