/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.network.toServer;

import igentuman.nc.block.entity.MultiblockBuilderBE;
import igentuman.nc.network.INcPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class PacketBuildMultiblock
implements INcPacket {
    private BlockPos tilePosition;
    private HashMap<BlockPos, Block> blockMap = new HashMap();

    public PacketBuildMultiblock(Object position, HashMap<BlockPos, Block> blockMap) {
        this.tilePosition = (BlockPos)position;
        this.blockMap = blockMap;
    }

    public PacketBuildMultiblock() {
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        BlockEntity be = player.m_9236_().m_7702_(this.tilePosition);
        if (be instanceof MultiblockBuilderBE) {
            MultiblockBuilderBE ncBe = (MultiblockBuilderBE)be;
            ncBe.build(this.blockMap);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.tilePosition);
        buffer.writeInt(this.blockMap.size());
        for (Map.Entry<BlockPos, Block> entry : this.blockMap.entrySet()) {
            buffer.m_130064_(entry.getKey());
            buffer.writeInt(Block.m_49956_((BlockState)entry.getValue().m_49966_()));
        }
    }

    public static PacketBuildMultiblock decode(FriendlyByteBuf buffer) {
        PacketBuildMultiblock packet = new PacketBuildMultiblock();
        packet.tilePosition = buffer.m_130135_();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buffer.m_130135_();
            Block block = Block.m_49803_((int)buffer.readInt()).m_60734_();
            packet.blockMap.put(pos, block);
        }
        return packet;
    }
}

