/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation.data;

import igentuman.nc.NuclearCraft;
import igentuman.nc.compat.mekanism.MekanismRadiation;
import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.radiation.FluidRadiation;
import igentuman.nc.radiation.ItemRadiation;
import igentuman.nc.radiation.RadiationCleaningItems;
import igentuman.nc.radiation.data.PlayerRadiation;
import igentuman.nc.radiation.data.PlayerRadiationProvider;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.radiation.data.WorldRadiationProvider;
import igentuman.nc.setup.Registration;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.RadiationExecutorManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RadiationEvents {
    public static boolean isTracking = false;
    private static final HashMap<Level, List<ItemEntity>> droppedRadioactiveItems = new HashMap();
    private static CompletableFuture<Void> radiationFuture;

    public static void attachWorldRadiation(AttachCapabilitiesEvent<Level> event) {
        if (!((Level)event.getObject()).getCapability(WorldRadiationProvider.WORLD_RADIATION).isPresent()) {
            event.addCapability(NuclearCraft.rl("radiation"), (ICapabilityProvider)new WorldRadiationProvider());
            isTracking = true;
        }
    }

    public static void tickAsync(TickEvent.LevelTickEvent event) {
        if (NuclearCraft.currentTick % 10L == 0L && ((Boolean)RadiationConfig.RADIATION_CONFIG.ENABLED.get()).booleanValue() && (radiationFuture == null || radiationFuture.isDone())) {
            radiationFuture = CompletableFuture.runAsync(() -> RadiationEvents.onWorldTick(event), RadiationExecutorManager.getExecutor());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemUse(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = event.getItem();
        if (stack.m_41619_()) {
            return;
        }
        long radiation = RadiationCleaningItems.byItem(stack.m_41720_());
        PlayerRadiation radCap = (PlayerRadiation)entity.getCapability(PlayerRadiationProvider.PLAYER_RADIATION).orElse(null);
        if (radCap != null) {
            if (stack.m_41720_().toString().equals("radaway")) {
                if (entity.m_21023_((MobEffect)Registration.RADIATION_RESISTANCE.get())) {
                    entity.m_21195_((MobEffect)Registration.RADIATION_RESISTANCE.get());
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)Registration.RADIATION_RESISTANCE.get(), 1200, 1, false, true));
            } else if (stack.m_41720_().toString().contains("rad_x")) {
                if (entity.m_21023_((MobEffect)Registration.RADIATION_RESISTANCE.get())) {
                    entity.m_21195_((MobEffect)Registration.RADIATION_RESISTANCE.get());
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)Registration.RADIATION_RESISTANCE.get(), 1200, 2, false, true));
            } else if (stack.m_41720_().toString().contains("radaway_slow")) {
                if (entity.m_21023_((MobEffect)Registration.RADIATION_DECAY.get())) {
                    entity.m_21195_((MobEffect)Registration.RADIATION_DECAY.get());
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)Registration.RADIATION_DECAY.get(), 2400, 1, false, true));
            }
            if (radiation == 0L) {
                return;
            }
            radCap.setRadiation(Math.max(0L, radCap.getRadiation() - radiation / 1000L));
            if (ModUtil.isMekanismLoaded() && ((Boolean)RadiationConfig.RADIATION_CONFIG.MEKANISM_RADIATION_INTEGRATION.get()).booleanValue()) {
                MekanismRadiation.addEntityRadiation((Player)entity, -radiation / 10000000L);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemStack stack = ((ItemEntity)entity).m_32055_();
            if (stack.m_41619_()) {
                return;
            }
            double radiation = ItemRadiation.byItem(stack.m_41720_());
            if (radiation > 0.001) {
                RadiationManager.get(event.getLevel()).addRadiation(event.getLevel(), (double)stack.m_41613_() * radiation / 5.0, entity.m_20183_().m_123341_(), entity.m_20183_().m_123342_(), entity.m_20183_().m_123343_());
                List items = droppedRadioactiveItems.computeIfAbsent(event.getLevel(), k -> new LinkedList());
                items.add((ItemEntity)entity);
                droppedRadioactiveItems.put(event.getLevel(), items);
            }
        }
    }

    public static void attachPlayerRadiation(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerRadiationProvider.PLAYER_RADIATION).isPresent()) {
            event.addCapability(NuclearCraft.rl("radiation"), (ICapabilityProvider)new PlayerRadiationProvider());
        }
    }

    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerRadiationProvider.PLAYER_RADIATION).ifPresent(oldStore -> event.getEntity().getCapability(PlayerRadiationProvider.PLAYER_RADIATION).ifPresent(newStore -> newStore.copyFrom((PlayerRadiation)oldStore)));
        }
    }

    @SubscribeEvent
    public void onFluidPlaced(BlockEvent.FluidPlaceBlockEvent event) {
        double radiation;
        BlockState state = event.getState();
        if (state != null && !state.m_60795_() && (radiation = FluidRadiation.byFluid(state.m_60819_().m_76152_())) > 0.001) {
            RadiationManager.get((Level)event.getLevel()).addRadiation((Level)event.getLevel(), radiation / 5.0, event.getLiquidPos());
        }
    }

    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (!isTracking || event.level.f_46443_) {
            return;
        }
        Level world = event.level;
        if (!droppedRadioactiveItems.containsKey(world)) {
            droppedRadioactiveItems.put(world, new LinkedList());
        }
        RadiationManager manager = RadiationManager.get(event.level);
        int size = droppedRadioactiveItems.get(world).size();
        for (int i = 0; i < size; ++i) {
            ItemEntity entity = droppedRadioactiveItems.get(world).get(i);
            if (entity.m_6084_()) {
                double radiation = ItemRadiation.byItem(entity.m_32055_().m_41720_());
                if (!(radiation > 0.001)) continue;
                RadiationManager.get(world).addRadiation(world, radiation / 5.0, entity.m_20183_());
                continue;
            }
            droppedRadioactiveItems.get(world).remove(i);
            --i;
            --size;
        }
        manager.tick(event.level);
    }

    public static void stopTracking() {
        isTracking = false;
    }

    public static void startTracking() {
        isTracking = true;
    }
}

