/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation.data;

import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.radiation.data.IWorldRadiationCapability;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class WorldRadiation
implements IWorldRadiationCapability {
    private final double decaySpeed;
    public HashMap<Long, Long> chunkRadiation;
    public HashMap<Long, Long> updatedChunks;
    public HashMap<Long, Long> newChunks;
    public Level level;

    public WorldRadiation() {
        this.decaySpeed = (double)((Integer)RadiationConfig.RADIATION_CONFIG.DECAY_SPEED.get()).intValue() / 10000.0;
        this.chunkRadiation = new HashMap();
        this.updatedChunks = new HashMap();
        this.newChunks = new HashMap();
    }

    public WorldRadiation(HashMap<Long, Long> radiation) {
        this.decaySpeed = (double)((Integer)RadiationConfig.RADIATION_CONFIG.DECAY_SPEED.get()).intValue() / 10000.0;
        this.chunkRadiation = new HashMap();
        this.updatedChunks = new HashMap();
        this.newChunks = new HashMap();
        this.chunkRadiation = radiation;
    }

    public static WorldRadiation deserialize(CompoundTag radiation) {
        WorldRadiation worldRadiation = new WorldRadiation();
        worldRadiation.deserializeNBT(radiation);
        return worldRadiation;
    }

    public int chunkRadiation(int chunkX, int chunkZ) {
        int radiation = 0;
        long id = WorldRadiation.pack(chunkX, chunkZ);
        if (this.chunkRadiation.containsKey(id)) {
            radiation += WorldRadiation.unpackX(this.chunkRadiation.get(id));
        }
        return radiation;
    }

    @Override
    public int getChunkRadiation(int chunkX, int chunkZ) {
        long id = WorldRadiation.pack(chunkX, chunkZ);
        int radiation = this.naturalRadiation(chunkX, chunkZ);
        if (this.chunkRadiation.containsKey(id)) {
            radiation += WorldRadiation.unpackX(this.chunkRadiation.get(id));
        }
        return radiation += this.iterateNearbyChunks(chunkX, chunkZ);
    }

    private int iterateNearbyChunks(int chunkX, int chunkZ) {
        int radius = 7;
        int radiation = 0;
        for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
            for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                if (x == chunkX && z == chunkZ) continue;
                long id = WorldRadiation.pack(x, z);
                int chunkRadiationValue = 0;
                if (this.chunkRadiation.containsKey(id)) {
                    chunkRadiationValue = WorldRadiation.unpackX(this.chunkRadiation.get(id));
                }
                double distance = Math.log(Math.pow(chunkX - x, 2.0) + Math.pow(chunkZ - z, 2.0) + 2.0);
                double multiplier = 1.0 / Math.max(1.0, distance);
                radiation += (int)(((double)chunkRadiationValue + (double)this.naturalRadiation(x, z) / 5.0) * Math.pow(multiplier, 3.0));
            }
        }
        return radiation;
    }

    public void refresh(Level level) {
        Long[] ids;
        this.level = level;
        this.chunkRadiation.putAll(this.newChunks);
        this.updatedChunks.clear();
        this.newChunks.clear();
        Long[] longArray = ids = this.chunkRadiation.keySet().toArray(new Long[0]);
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long id = longArray[i];
            this.updateChunkRadiation(id);
        }
    }

    @Override
    public void updateChunkRadiation(long id) {
        if (this.updatedChunks.containsKey(id) || !this.chunkRadiation.containsKey(id)) {
            return;
        }
        int x = WorldRadiation.unpackX(id);
        int z = WorldRadiation.unpackZ(id);
        if (!this.level.m_7726_().m_5563_(x, z)) {
            return;
        }
        int radiation = WorldRadiation.unpackX(this.chunkRadiation.get(id));
        int timestamp = WorldRadiation.unpackZ(this.chunkRadiation.get(id));
        int curTimestamp = (int)(this.getServerTime() / 20L);
        int radiationChange = (int)((double)(curTimestamp - timestamp) * this.decaySpeed);
        if ((radiation -= radiationChange) < 100) {
            this.chunkRadiation.remove(id);
            this.updatedChunks.put(id, WorldRadiation.pack(0, curTimestamp));
            return;
        }
        radiation = Math.min(radiation, 5000000);
        long radiationData = WorldRadiation.pack(radiation, curTimestamp);
        this.chunkRadiation.replace(id, radiationData);
        this.updatedChunks.put(id, radiationData);
    }

    public int addRadiation(Level level, double radiation, int x, int z) {
        this.level = level;
        long id = WorldRadiation.pack(x, z);
        int curTimestamp = (int)(this.getServerTime() / 20L);
        int newRadiation = (int)Math.min(radiation * 1000000.0, 2.147483647E9);
        if (!((Boolean)RadiationConfig.RADIATION_CONFIG.ENABLED.get()).booleanValue()) {
            return 0;
        }
        if (this.chunkRadiation.containsKey(id)) {
            int curRadiation = WorldRadiation.unpackX(this.chunkRadiation.get(id));
            if (curRadiation > newRadiation) {
                newRadiation /= 20;
            }
            newRadiation = Math.max(0, Math.min(curRadiation + newRadiation, Integer.MAX_VALUE));
            this.chunkRadiation.replace(id, WorldRadiation.pack(newRadiation, curTimestamp));
        }
        if (this.newChunks.containsKey(id)) {
            this.newChunks.replace(id, WorldRadiation.pack(newRadiation, curTimestamp));
        } else {
            this.newChunks.put(id, WorldRadiation.pack(newRadiation, curTimestamp));
        }
        return newRadiation;
    }

    private long getServerTime() {
        return this.level.m_46467_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag radiationTag = new CompoundTag();
        for (long key : this.chunkRadiation.keySet()) {
            radiationTag.m_128356_(String.valueOf(key), this.chunkRadiation.get(key).longValue());
        }
        tag.m_128365_("radiation", (Tag)radiationTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag radiationTag = nbt.m_128469_("radiation");
        for (String key : radiationTag.m_128431_()) {
            this.chunkRadiation.put(Long.parseLong(key), radiationTag.m_128454_(key));
        }
    }

    public static long pack(int x, int z) {
        return ChunkPos.m_45589_((int)x, (int)z);
    }

    public static int unpackX(long packed) {
        return ChunkPos.m_45592_((long)packed);
    }

    public static int unpackZ(long packed) {
        return ChunkPos.m_45602_((long)packed);
    }

    public int naturalRadiation(int chunkX, int chunkZ) {
        int radiation = (Integer)RadiationConfig.RADIATION_CONFIG.NATURAL_RADIATION.get();
        if (this.level == null) {
            return radiation;
        }
        String biomeId = ((ResourceKey)this.level.m_204166_(new BlockPos(chunkX * 16, 0, chunkZ * 16)).m_203543_().get()).m_135782_().toString();
        radiation += RadiationConfig.RADIATION_CONFIG.biomeRadiation(biomeId);
        return radiation += RadiationConfig.RADIATION_CONFIG.dimensionRadiation(this.level.m_46472_().m_135782_().toString());
    }

    public void setChunkRadiation(BlockPos blockPos, int value) {
        long id = WorldRadiation.pack(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
        int curTimestamp = (int)(this.getServerTime() / 20L);
        int newRadiation = Math.min(value * 1000, Integer.MAX_VALUE);
        this.chunkRadiation.put(id, WorldRadiation.pack(newRadiation, curTimestamp));
        this.updatedChunks.put(id, WorldRadiation.pack(newRadiation, curTimestamp));
    }
}

