/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes;

import igentuman.nc.handler.config.MaterialsConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.handler.sided.capability.NcFluidTank;
import igentuman.nc.recipes.NcRecipeSerializers;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.InputIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.util.IgnoredIInventory;
import igentuman.nc.util.NcUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRecipe
implements Recipe<IgnoredIInventory> {
    private final ResourceLocation id;
    public final String codeId;
    protected double timeModifier = 1.0;
    protected double powerModifier = 1.0;
    protected double radiationModifier = 1.0;
    protected FluidStackIngredient[] inputFluids = new FluidStackIngredient[0];
    protected FluidStackIngredient[] outputFluids = new FluidStackIngredient[0];
    protected ItemStackIngredient[] inputItems = new ItemStackIngredient[0];
    protected ItemStackIngredient[] outputItems = new ItemStackIngredient[0];
    protected List<ItemStack> cachedOutputItems;
    protected List<FluidStack> cachedOutputFluids;

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public FluidStackIngredient[] getInputFluids() {
        return this.inputFluids;
    }

    public List<FluidStack> getOutputFluids() {
        if (this.cachedOutputFluids == null) {
            this.cachedOutputFluids = new ArrayList<FluidStack>();
            block0: for (FluidStackIngredient outputFluid : this.outputFluids) {
                if (outputFluid.getRepresentations().size() == 1) {
                    this.cachedOutputFluids.add((FluidStack)outputFluid.getRepresentations().get(0));
                    continue;
                }
                for (String mod : (List)MaterialsConfig.MATERIAL_PRODUCTS.MODS_PRIORITY.get()) {
                    FluidStack flowing = null;
                    for (FluidStack fluid : outputFluid.getRepresentations()) {
                        if (!NcUtils.getModId(fluid).equals(mod) && !NcUtils.getModId(fluid).equals("minecraft")) continue;
                        if (ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid()).m_135815_().contains("_flowing")) {
                            flowing = fluid;
                            continue;
                        }
                        this.cachedOutputFluids.add(new FluidStack(fluid.getRawFluid(), fluid.getAmount()));
                        continue block0;
                    }
                    if (flowing == null) continue;
                    this.cachedOutputFluids.add(new FluidStack(flowing, flowing.getAmount()));
                }
            }
        }
        return this.cachedOutputFluids;
    }

    protected AbstractRecipe(ResourceLocation id) {
        this.id = Objects.requireNonNull(id, "Recipe name cannot be null.");
        this.codeId = this.getCodeId();
    }

    public String getCodeId() {
        return this.id.m_135815_().split("/")[0];
    }

    public NonNullList<Ingredient> getItemIngredients() {
        NonNullList ingredients = NonNullList.m_122779_();
        for (ItemStackIngredient inputItem : this.inputItems) {
            if (inputItem == null) {
                ingredients.add((Object)Ingredient.f_43901_);
                continue;
            }
            ingredients.add((Object)Ingredient.m_43927_((ItemStack[])inputItem.getRepresentations().toArray(new ItemStack[inputItem.getRepresentations().size()])));
        }
        return ingredients;
    }

    public ItemStack getFirstItemStackIngredient(int id) {
        ItemStack[] items = this.getInputIngredient(0).m_43908_();
        return items.length > id ? items[id] : ItemStack.f_41583_;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)NcRecipeSerializers.SERIALIZERS.get(this.codeId).get();
    }

    @NotNull
    public String m_6076_() {
        return this.codeId;
    }

    @NotNull
    public ItemStack m_8042_() {
        Block proc = Blocks.f_50016_;
        if (NCProcessors.PROCESSORS.containsKey(this.codeId)) {
            proc = (Block)NCProcessors.PROCESSORS.get(this.codeId).get();
        }
        return new ItemStack((ItemLike)proc);
    }

    @NotNull
    public RecipeType<? extends AbstractRecipe> m_6671_() {
        return (RecipeType)NcRecipeType.ALL_RECIPES.get(this.codeId).get();
    }

    public abstract void write(FriendlyByteBuf var1);

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean matches(@NotNull IgnoredIInventory inv, @NotNull Level world) {
        return !this.m_142505_();
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_142505_() {
        boolean empty;
        boolean bl = empty = this.inputFluids.length == 0 && this.inputItems.length == 0 || this.outputFluids.length == 0 && this.outputItems.length == 0;
        if (empty) {
            return true;
        }
        for (ItemStackIngredient itemStackIngredient : this.inputItems) {
            if (itemStackIngredient != null && !itemStackIngredient.getRepresentations().isEmpty() && !((ItemStack)itemStackIngredient.getRepresentations().get(0)).m_150930_(Items.f_42127_)) continue;
            return true;
        }
        for (ItemStackIngredient itemStackIngredient : this.outputItems) {
            if (itemStackIngredient != null && !itemStackIngredient.getRepresentations().isEmpty() && !((ItemStack)itemStackIngredient.getRepresentations().get(0)).m_150930_(Items.f_42127_)) continue;
            return true;
        }
        for (InputIngredient<ItemStack> inputIngredient : this.inputFluids) {
            if (inputIngredient != null && !inputIngredient.getRepresentations().isEmpty()) continue;
            return true;
        }
        for (InputIngredient<ItemStack> inputIngredient : this.outputFluids) {
            if (inputIngredient != null && !inputIngredient.getRepresentations().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull IgnoredIInventory inv, RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public List<ItemStack> getResultItems() {
        if (this.cachedOutputItems == null) {
            this.cachedOutputItems = new ArrayList<ItemStack>();
            block0: for (ItemStackIngredient outputItem : this.outputItems) {
                if (outputItem == null) continue;
                List items = outputItem.getRepresentations();
                if (items.size() == 1) {
                    this.cachedOutputItems.add((ItemStack)items.get(0));
                    continue;
                }
                block1: for (String mod : (List)MaterialsConfig.MATERIAL_PRODUCTS.MODS_PRIORITY.get()) {
                    for (ItemStack item : items) {
                        if (!NcUtils.getModId(item).equals(mod)) continue;
                        this.cachedOutputItems.add(item);
                        break block1;
                    }
                }
                if (!this.cachedOutputItems.isEmpty()) continue;
                for (ItemStack item : items) {
                    if (item.m_41619_() || item.m_150930_(Items.f_42127_)) continue;
                    this.cachedOutputItems.add(item);
                    continue block0;
                }
            }
        }
        return this.cachedOutputItems;
    }

    public List<FluidStack> getInputFluids(int id) {
        if (this.inputFluids.length > id) {
            return this.inputFluids[id].getRepresentations();
        }
        return List.of(FluidStack.EMPTY);
    }

    public List<FluidStack> getOutputFluids(int id) {
        if (this.getOutputFluids().size() > id) {
            return List.of(this.getOutputFluids().get(id));
        }
        return List.of(FluidStack.EMPTY);
    }

    public double getTimeModifier() {
        return this.timeModifier;
    }

    public double getEnergy() {
        return this.powerModifier;
    }

    public double getRadiation() {
        return this.radiationModifier;
    }

    public boolean handleOutputs(SidedContentHandler contentHandler) {
        int i = contentHandler.inputItemSlots;
        for (ItemStack outputItem : this.getResultItems()) {
            if (!contentHandler.itemHandler.insertItemInternal(i, outputItem, true).m_41619_() && !contentHandler.itemHandler.canPushExcessItems(i, outputItem)) {
                return false;
            }
            ++i;
        }
        i = contentHandler.inputFluidSlots;
        for (FluidStack outputFluid : this.getOutputFluids()) {
            if (!contentHandler.fluidHandler.isValidForOutputSlot(i, outputFluid) && !contentHandler.fluidHandler.canPushExcessFluid(i, outputFluid)) {
                return false;
            }
            ++i;
        }
        i = contentHandler.inputFluidSlots;
        for (FluidStack outputFluid : this.getOutputFluids()) {
            if (!contentHandler.fluidHandler.insertFluidInternal(i, outputFluid, true).isEmpty() && !contentHandler.fluidHandler.pushExcessFluid(i, outputFluid).isEmpty()) {
                return false;
            }
            ++i;
        }
        i = contentHandler.inputItemSlots;
        for (ItemStack outputItem : this.getResultItems()) {
            ItemStack toOutput = outputItem.m_41777_();
            if (!contentHandler.itemHandler.insertItemInternal(i, toOutput, false).m_41619_() && !contentHandler.itemHandler.pushExcessItems(i, toOutput).m_41619_()) {
                return false;
            }
            ++i;
        }
        contentHandler.clearHolded();
        return true;
    }

    public boolean hasEnoughToConsume(SidedContentHandler contentHandler, int parallelProcessing) {
        InputIngredient<FluidStack> toConsume;
        if (contentHandler.hasFluidCapability(null)) {
            for (InputIngredient<FluidStack> inputIngredient : this.inputFluids) {
                toConsume = ((FluidStackIngredient)inputIngredient).copy();
                ((FluidStackIngredient)toConsume).setAmount(((FluidStackIngredient)inputIngredient).getAmount() * parallelProcessing);
                int i = 0;
                assert (contentHandler.fluidHandler != null);
                boolean found = false;
                for (FluidTank tank : contentHandler.fluidHandler.tanks) {
                    if (contentHandler.inputFluidSlots <= i) break;
                    FluidStack fluidStack = tank.getFluid();
                    if (toConsume.test(fluidStack)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) continue;
                return false;
            }
        }
        if (contentHandler.hasItemCapability(null)) {
            for (InputIngredient<FluidStack> inputIngredient : this.inputItems) {
                toConsume = ((ItemStackIngredient)inputIngredient).copy();
                ((ItemStackIngredient)toConsume).setAmount(inputIngredient.getAmount() * parallelProcessing);
                assert (contentHandler.itemHandler != null);
                boolean found = false;
                for (int i = 0; i < this.inputItems.length; ++i) {
                    if (!toConsume.test(contentHandler.itemHandler.getStackInSlot(i))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public boolean consumeInputs(SidedContentHandler contentHandler, int parallelProcessing) {
        int i;
        InputIngredient<FluidStack> toConsume;
        if (!this.hasEnoughToConsume(contentHandler, parallelProcessing)) {
            return false;
        }
        if (contentHandler.hasFluidCapability(null)) {
            block0: for (InputIngredient<FluidStack> inputIngredient : this.inputFluids) {
                toConsume = ((FluidStackIngredient)inputIngredient).copy();
                ((FluidStackIngredient)toConsume).setAmount(((FluidStackIngredient)inputIngredient).getAmount() * parallelProcessing);
                i = 0;
                assert (contentHandler.fluidHandler != null);
                for (FluidTank tank : contentHandler.fluidHandler.tanks) {
                    if (contentHandler.inputFluidSlots <= i) continue block0;
                    FluidStack fluidStack = tank.getFluid();
                    if (toConsume.test(fluidStack)) {
                        FluidStack holded = fluidStack.copy();
                        holded.setAmount(((FluidStackIngredient)toConsume).getAmount());
                        contentHandler.fluidHandler.holdedInputs.add(holded);
                        ((NcFluidTank)((Object)contentHandler.fluidHandler.tanks.get(i))).drain(holded.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        if (contentHandler.hasItemCapability(null)) {
            block2: for (InputIngredient<FluidStack> inputIngredient : this.inputItems) {
                assert (contentHandler.itemHandler != null);
                toConsume = ((ItemStackIngredient)inputIngredient).copy();
                ((ItemStackIngredient)toConsume).setAmount(inputIngredient.getAmount() * parallelProcessing);
                for (i = 0; i < this.inputItems.length; ++i) {
                    ItemStack extracted;
                    if (!toConsume.test(contentHandler.itemHandler.getStackInSlot(i)) || (extracted = contentHandler.itemHandler.extractItemInternal(i, toConsume.getAmount(), false)).m_41619_()) continue;
                    contentHandler.itemHandler.holdedInputs.add(extracted);
                    continue block2;
                }
            }
        }
        return true;
    }

    public boolean test(SidedContentHandler contentHandler) {
        if (this.inputItems.length > 0 && this.inputFluids.length == 0) {
            return this.testItems(contentHandler.itemHandler);
        }
        if (this.inputFluids.length > 0 && this.inputItems.length == 0) {
            return this.testFluids(contentHandler.fluidHandler);
        }
        return this.testFluids(contentHandler.fluidHandler) && this.testItems(contentHandler.itemHandler);
    }

    private boolean testFluids(FluidCapabilityHandler fluidHandler) {
        for (int i = 0; i < this.inputFluids.length; ++i) {
            if (this.hasFluidInSlots(fluidHandler, this.inputFluids[i])) continue;
            return false;
        }
        return true;
    }

    private boolean hasFluidInSlots(FluidCapabilityHandler fluidHandler, FluidStackIngredient fluid) {
        for (int i = 0; i < fluidHandler.inputSlots; ++i) {
            if (!fluid.test(fluidHandler.getFluidInSlot(i))) continue;
            return true;
        }
        return false;
    }

    private boolean testItems(ItemCapabilityHandler itemHandler) {
        for (int i = 0; i < this.inputItems.length; ++i) {
            if (this.hasItemInSlots(itemHandler, this.inputItems[i])) continue;
            return false;
        }
        return true;
    }

    private boolean hasItemInSlots(ItemCapabilityHandler itemHandler, ItemStackIngredient item) {
        for (int i = 0; i < itemHandler.inputSlots; ++i) {
            if (!item.test(itemHandler.getStackInSlot(i))) continue;
            return true;
        }
        return false;
    }

    public ItemStack getOutputItem(int id) {
        if (this.getResultItems().size() > id) {
            return this.getResultItems().get(id);
        }
        return ItemStack.f_41583_;
    }

    public Ingredient getInputIngredient(int inputCounter) {
        if (this.getItemIngredients().size() > inputCounter) {
            return (Ingredient)this.getItemIngredients().get(inputCounter);
        }
        return Ingredient.f_43901_;
    }

    @NotNull
    public ItemStack getResultItem() {
        if (this.outputItems.length == 0) {
            return ItemStack.f_41583_;
        }
        return !this.getResultItems().isEmpty() ? this.getResultItems().get(0) : ItemStack.f_41583_;
    }

    public ItemStackIngredient[] getInputItems() {
        return this.inputItems;
    }

    public boolean handleOutputs(SidedContentHandler contentHandler, ItemStack outputItem) {
        int i = contentHandler.inputItemSlots;
        if (!contentHandler.itemHandler.insertItemInternal(i, outputItem, true).m_41619_() && !contentHandler.itemHandler.canPushExcessItems(i, outputItem)) {
            return false;
        }
        ItemStack toOutput = outputItem.m_41777_();
        if (!contentHandler.itemHandler.insertItemInternal(i, toOutput, false).m_41619_() && !contentHandler.itemHandler.pushExcessItems(i, toOutput).m_41619_()) {
            return false;
        }
        contentHandler.clearHolded();
        return true;
    }
}

