/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes;

import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.block.fusion.entity.FusionCoreBE;
import igentuman.nc.block.kugelblitz.entity.ChamberTerminalBE;
import igentuman.nc.block.target_chamber.entity.TargetChamberControllerBE;
import igentuman.nc.block.turbine.entity.TurbineControllerBE;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.recipes.serializers.BoilingRecipeSerializer;
import igentuman.nc.recipes.serializers.CoolantRecipeSerializer;
import igentuman.nc.recipes.serializers.FusionRecipeSerializer;
import igentuman.nc.recipes.serializers.NcRecipeSerializer;
import igentuman.nc.recipes.serializers.OreVeinRecipeSerializer;
import igentuman.nc.recipes.serializers.TargetChamberSerializer;
import igentuman.nc.recipes.serializers.TurbineRecipeSerializer;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.recipes.type.OreVeinRecipe;
import igentuman.nc.recipes.type.RadShieldingRecipe;
import igentuman.nc.recipes.type.ResetNbtRecipe;
import igentuman.nc.registry.RecipeSerializerRegistryObject;
import igentuman.nc.setup.registration.Registries;
import java.util.HashMap;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;

public class NcRecipeSerializers {
    public static final RecipeSerializerRegistryObject<RadShieldingRecipe> SHIELDING = Registries.RECIPE_SERIALIZERS.register("shielding", () -> new SimpleCraftingRecipeSerializer(RadShieldingRecipe::new));
    public static final RecipeSerializerRegistryObject<ResetNbtRecipe> RESET_NBT = Registries.RECIPE_SERIALIZERS.register("reset_nbt", () -> new SimpleCraftingRecipeSerializer(ResetNbtRecipe::new));
    public static final HashMap<String, RecipeSerializerRegistryObject<? extends NcRecipe>> SERIALIZERS = NcRecipeSerializers.initSerializers();

    private NcRecipeSerializers() {
    }

    private static HashMap<String, RecipeSerializerRegistryObject<? extends NcRecipe>> initSerializers() {
        HashMap<String, RecipeSerializerRegistryObject<? extends NcRecipe>> map = new HashMap<String, RecipeSerializerRegistryObject<? extends NcRecipe>>();
        map.put("fusion_core", Registries.RECIPE_SERIALIZERS.register("fusion_core", () -> new FusionRecipeSerializer(FusionCoreBE.Recipe::new)));
        map.put("fission_reactor_controller", Registries.RECIPE_SERIALIZERS.register("fission_reactor_controller", () -> new NcRecipeSerializer<FissionControllerBE.Recipe>(FissionControllerBE.Recipe::new)));
        map.put("kugelblitz_chamber", Registries.RECIPE_SERIALIZERS.register("kugelblitz_chamber", () -> new NcRecipeSerializer<ChamberTerminalBE.Recipe>(ChamberTerminalBE.Recipe::new)));
        map.put("nc_ore_veins", Registries.RECIPE_SERIALIZERS.register("nc_ore_veins", () -> new OreVeinRecipeSerializer(OreVeinRecipe::new)));
        map.put("accelerator_coolant", Registries.RECIPE_SERIALIZERS.register("accelerator_coolant", () -> new CoolantRecipeSerializer(LinearAcceleratorControllerBE.CoolantRecipe::new)));
        map.put("fusion_coolant", Registries.RECIPE_SERIALIZERS.register("fusion_coolant", () -> new CoolantRecipeSerializer(FusionCoreBE.FusionCoolantRecipe::new)));
        map.put("fission_boiling", Registries.RECIPE_SERIALIZERS.register("fission_boiling", () -> new BoilingRecipeSerializer(FissionControllerBE.FissionBoilingRecipe::new)));
        map.put("target_chamber", Registries.RECIPE_SERIALIZERS.register("target_chamber", () -> new TargetChamberSerializer<TargetChamberControllerBE.Recipe>(TargetChamberControllerBE.Recipe::new)));
        map.put(TurbineControllerBE.NAME, Registries.RECIPE_SERIALIZERS.register(TurbineControllerBE.NAME, () -> new TurbineRecipeSerializer(TurbineControllerBE.Recipe::new)));
        for (String key : Processors.all().keySet()) {
            if (Processors.all().get(key).getRecipeSerializer() == null) continue;
            map.put(key, Registries.RECIPE_SERIALIZERS.register(key, Processors.all().get(key).getRecipeSerializer()));
        }
        return map;
    }

    public static void init() {
    }
}

