/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import igentuman.nc.NuclearCraft;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.loading.FMLPaths;

public class FileExtractor {
    public static HashMap<String, Boolean> registrationConfig = new HashMap();

    public static void preFetchProcessorsConfig() {
        FileExtractor.preloadRegistrations("processors");
    }

    public static void preloadRegistrations(String name) {
        Path configDir = FMLPaths.CONFIGDIR.get();
        File configFile = new File(configDir.toFile(), "NuclearCraft/" + name + ".toml");
        if (!configFile.exists()) {
            registrationConfig.put(name, null);
        }
        try (FileConfig config = FileConfig.of((File)configFile);){
            config.load();
            for (String key : config.valueMap().keySet()) {
                CommentedConfig child;
                Object object = config.get(key);
                if (!(object instanceof CommentedConfig) || !(child = (CommentedConfig)object).contains("register")) continue;
                registrationConfig.put(key, (Boolean)child.get("register"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void unpackFilesFromFolderToConfig(String sourceFolderPath, String targetFolderName) {
        block23: {
            Path configDir = FMLPaths.CONFIGDIR.get();
            boolean currentVersion = true;
            File targetFolder = new File(configDir.toFile(), targetFolderName);
            if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                System.err.println("Failed to create target folder: " + targetFolderName);
                return;
            }
            String jarPath = FileExtractor.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            jarPath = jarPath.replace("file:", "").replace("!/", "");
            jarPath = jarPath.replaceAll("(.+\\.jar|/)(%23\\d+)?$", "$1");
            jarPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8);
            try {
                File jarFile = new File(jarPath);
                NuclearCraft.LOGGER.info("JAR file path: " + jarFile.getAbsolutePath());
                try (ZipFile zipFile = new ZipFile(jarFile);){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    File version = new File(targetFolder, "version.txt");
                    int versionId = 0;
                    if (version.exists()) {
                        versionId = Integer.parseInt(Files.readString(version.toPath()));
                    }
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.startsWith(sourceFolderPath) || entry.isDirectory()) continue;
                        String relativeFileName = entryName.substring(sourceFolderPath.length() + 1);
                        File targetFile = new File(targetFolder, relativeFileName);
                        if (!targetFile.getParentFile().exists()) {
                            targetFile.getParentFile().mkdirs();
                        }
                        try {
                            InputStream inputStream = zipFile.getInputStream(entry);
                            try {
                                if (targetFile.exists()) continue;
                                Files.copy(inputStream, targetFile.toPath(), new CopyOption[0]);
                                NuclearCraft.LOGGER.info("Extracted file " + relativeFileName + " to config folder.");
                            }
                            finally {
                                if (inputStream == null) continue;
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            if (targetFolder.listFiles().length != 0) continue;
                            System.err.println("Failed to extract files to " + targetFolder.getPath());
                        }
                    }
                }
            }
            catch (IOException e) {
                if (new File(jarPath).isDirectory()) {
                    try {
                        File[] files;
                        File version = new File(targetFolder, "version.txt");
                        int versionId = 0;
                        if (version.exists()) {
                            versionId = Integer.parseInt(Files.readString(version.toPath()));
                        }
                        File sourceFolder = new File(jarPath + sourceFolderPath);
                        for (File file : files = sourceFolder.listFiles()) {
                            File targetFile = new File(targetFolder, file.getName());
                            if (targetFile.exists()) continue;
                            Files.copy(file.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            NuclearCraft.LOGGER.info("Extracted file " + file.getName() + " to config folder.");
                        }
                    }
                    catch (IOException ex) {
                        NuclearCraft.LOGGER.error(ex.toString());
                        break block23;
                    }
                }
                NuclearCraft.LOGGER.error(e.toString());
            }
        }
    }
}

