/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import igentuman.nc.NuclearCraft;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.setup.registration.NCBlocks;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ReactorDesignParser {
    public static String resolvePath(String input) throws Exception {
        if (input.startsWith("file://")) {
            return Paths.get(new URI(input)).toAbsolutePath().toString();
        }
        return Paths.get(input, new String[0]).toAbsolutePath().toString();
    }

    public static HashMap<BlockPos, Block> parseStructure(String input) {
        HashMap<BlockPos, Block> blockMap = new HashMap<BlockPos, Block>();
        JsonElement jsonElement = null;
        String resolvedPath = input;
        try {
            resolvedPath = ReactorDesignParser.resolvePath(input);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            jsonElement = JsonParser.parseReader((Reader)new FileReader(resolvedPath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            if (jsonElement == null) {
                jsonElement = JsonParser.parseString((String)input);
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonObject compressedReactor = jsonObject.getAsJsonObject("CompressedReactor");
            for (Map.Entry entry : compressedReactor.entrySet()) {
                String componentType = (String)entry.getKey();
                JsonElement positionsElement = (JsonElement)entry.getValue();
                if (!positionsElement.isJsonArray()) continue;
                positionsElement.getAsJsonArray().forEach(posObj -> {
                    JsonObject positionObject = posObj.getAsJsonObject();
                    int x = positionObject.get("X").getAsInt();
                    int y = positionObject.get("Y").getAsInt();
                    int z = positionObject.get("Z").getAsInt();
                    BlockPos pos = new BlockPos(x, y, z);
                    blockMap.put(pos, ReactorDesignParser.getBlock(componentType.toLowerCase()));
                });
            }
        }
        catch (JsonSyntaxException e) {
            NuclearCraft.debugLog("Invalid JSON syntax in input: " + e.getMessage());
        }
        return blockMap;
    }

    private static Block getBlock(String componentType) {
        if (componentType.equals("fuelcell")) {
            return (Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_solid_fuel_cell").get();
        }
        if (FissionReactorRegistration.FISSION_BLOCKS.containsKey(componentType + "_heat_sink")) {
            return (Block)FissionReactorRegistration.FISSION_BLOCKS.get(componentType + "_heat_sink").get();
        }
        if (FissionReactorRegistration.FISSION_BLOCKS.containsKey("liquid_" + componentType + "_heat_sink")) {
            return (Block)FissionReactorRegistration.FISSION_BLOCKS.get("liquid_" + componentType + "_heat_sink").get();
        }
        if (NCBlocks.NC_BLOCKS.containsKey(componentType + "_block")) {
            return (Block)NCBlocks.NC_BLOCKS.get(componentType + "_block").get();
        }
        if (NCBlocks.NC_MATERIAL_BLOCKS.containsKey(componentType)) {
            return (Block)NCBlocks.NC_MATERIAL_BLOCKS.get(componentType).get();
        }
        return Blocks.f_50016_;
    }
}

