/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util.insitu_leaching;

import igentuman.nc.recipes.type.OreVeinRecipe;
import igentuman.nc.util.insitu_leaching.IWorldVeinCapability;
import igentuman.nc.util.insitu_leaching.OreVeinProvider;
import igentuman.nc.util.insitu_leaching.WorldVeinsManager;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class WorldVeinOres
implements IWorldVeinCapability {
    public ServerLevel level;
    public HashMap<Long, Integer> blocksInVein = new HashMap();

    public WorldVeinOres() {
    }

    public WorldVeinOres(Level level) {
        this.level = (ServerLevel)level;
    }

    public static WorldVeinOres deserialize(CompoundTag veins) {
        WorldVeinOres worldVeins = new WorldVeinOres();
        worldVeins.deserializeNBT(veins);
        return worldVeins;
    }

    @Override
    public OreVeinRecipe getVeinForChunk(int chunkX, int chunkZ) {
        return OreVeinProvider.get(this.level).getVeinForChunk(chunkX, chunkZ);
    }

    @Override
    public boolean chunkContainsVein(int chunkX, int chunkZ) {
        return OreVeinProvider.get(this.level).chunkContainsVein(chunkX, chunkZ);
    }

    @Override
    public int getBlocksLeft(int chunkX, int chunkZ) {
        long id = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        if (this.blocksInVein.containsKey(id)) {
            return this.blocksInVein.get(id);
        }
        return OreVeinProvider.get(this.level).getVeinSize(chunkX, chunkZ);
    }

    @Override
    public void mineBlock(int chunkX, int chunkZ) {
        if (!this.chunkContainsVein(chunkX, chunkZ)) {
            return;
        }
        long id = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        if (this.blocksInVein.containsKey(id)) {
            this.blocksInVein.replace(id, this.blocksInVein.get(id) - 1);
        } else {
            this.blocksInVein.put(id, OreVeinProvider.get(this.level).getVeinSize(chunkX, chunkZ) - 1);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag veinsTag = new CompoundTag();
        for (long key : this.blocksInVein.keySet()) {
            veinsTag.m_128405_(String.valueOf(key), this.blocksInVein.get(key).intValue());
        }
        tag.m_128365_("depletion", (Tag)veinsTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag veinsTag = nbt.m_128469_("depletion");
        for (String key : veinsTag.m_128431_()) {
            this.blocksInVein.put(Long.parseLong(key), veinsTag.m_128451_(key));
        }
    }

    public ItemStack gatherRandomOre(int x, int z) {
        if (this.getBlocksLeft(x, z) == 0) {
            return ItemStack.f_41583_;
        }
        OreVeinRecipe vein = this.getVeinForChunk(x, z);
        if (vein == null) {
            return ItemStack.f_41583_;
        }
        ItemStack ore = vein.getRandomOre(this.level, x, z, this.getBlocksLeft(x, z));
        if (!ore.m_41619_()) {
            this.mineBlock(x, z);
            WorldVeinsManager.get((Level)this.level).m_77762_();
        }
        return ore;
    }
}

