/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.blocks;

import com.shiftthedev.alexandria.Alexandria;
import dev.architectury.hooks.block.BlockEntityHooks;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ContainerBlockEntity
extends BlockEntity
implements WorldlyContainer,
ExtendedMenuProvider {
    protected int[] SLOTS_FOR_UP = new int[0];
    protected int[] SLOTS_FOR_DOWN = new int[0];
    protected NonNullList<ItemStack> items;
    protected NonNullList<Item> validInputs;
    protected MutableComponent displayName;

    public ContainerBlockEntity(BlockEntityType<? extends BlockEntity> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    public boolean isInputEmpty() {
        return Arrays.stream(this.SLOTS_FOR_UP).anyMatch(value -> ((ItemStack)this.items.get(value)).isEmpty());
    }

    public boolean isOutputFull() {
        return Arrays.stream(this.SLOTS_FOR_DOWN).allMatch(value -> !((ItemStack)this.items.get(value)).isEmpty());
    }

    protected void resetIfNeed() {
    }

    protected boolean isValidInput(int slotIndex, ItemStack itemStack) {
        return true;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getItem(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack removeItem(int i, int j) {
        ItemStack itemStack = ContainerHelper.removeItem(this.items, (int)i, (int)j);
        if (Arrays.stream(this.SLOTS_FOR_UP).anyMatch(value -> value == i) && ((ItemStack)this.items.get(i)).isEmpty()) {
            this.resetIfNeed();
            this.markUpdated();
        }
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int i) {
        ItemStack itemStack = ContainerHelper.takeItem(this.items, (int)i);
        if (Arrays.stream(this.SLOTS_FOR_UP).anyMatch(value -> value == i) && ((ItemStack)this.items.get(i)).isEmpty()) {
            this.resetIfNeed();
            this.markUpdated();
        }
        return itemStack;
    }

    public void setItem(int i, ItemStack itemStack) {
        this.items.set(i, (Object)itemStack);
        if (itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        if (Arrays.stream(this.SLOTS_FOR_UP).anyMatch(value -> value == i) && ((ItemStack)this.items.get(i)).isEmpty()) {
            this.resetIfNeed();
        }
        this.markUpdated();
    }

    protected ItemStack insert(int slot, ItemStack stackToInsert, boolean simulate) {
        boolean reachedLimit;
        if (stackToInsert.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = (ItemStack)this.items.get(slot);
        int limit = existing.getMaxStackSize();
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stackToInsert, (ItemStack)existing)) {
                return stackToInsert;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stackToInsert;
        }
        boolean bl = reachedLimit = stackToInsert.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.items.set(slot, (Object)(reachedLimit ? stackToInsert.copyWithCount(limit) : stackToInsert));
            } else {
                existing.grow(reachedLimit ? limit : stackToInsert.getCount());
            }
        }
        return reachedLimit ? stackToInsert.copyWithCount(stackToInsert.getCount() - limit) : ItemStack.EMPTY;
    }

    public void clearContent() {
        this.items.clear();
    }

    public boolean stillValid(Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator var1 = this.items.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)var1.next()).isEmpty());
        return false;
    }

    public int[] getSlotsForFace(Direction direction) {
        return direction == Direction.UP ? this.SLOTS_FOR_UP : this.SLOTS_FOR_DOWN;
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return direction == Direction.UP && Arrays.stream(this.SLOTS_FOR_UP).anyMatch(value -> value == i) && this.isValidInput(i, itemStack);
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return direction == Direction.DOWN && Arrays.stream(this.SLOTS_FOR_DOWN).anyMatch(value -> value == i);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        if (compoundTag == null) {
            return;
        }
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (compoundTag.contains("Items")) {
            ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt("version", Alexandria.VERSION);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    protected void markUpdated() {
        this.setChanged();
        assert (this.level != null);
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        if (this.level.isClientSide) {
            return;
        }
        BlockEntityHooks.syncData((BlockEntity)this);
        this.level.getProfiler().pop();
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.getBlockPos());
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return null;
    }
}

