/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.client;

import com.shiftthedev.alexandria.client.ItemRendererRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ItemRendererRegistryImpl
implements ItemRendererRegistry {
    private static final Map<Item, ItemRendererRegistry.DynamicItemRenderer> RENDERERS = new HashMap<Item, ItemRendererRegistry.DynamicItemRenderer>();

    @Override
    public void register(ItemLike item, ItemRendererRegistry.DynamicItemRenderer renderer) {
        Objects.requireNonNull(item, "item is null");
        Objects.requireNonNull(item.asItem(), "item is null");
        Objects.requireNonNull(renderer, "renderer is null");
        if (RENDERERS.putIfAbsent(item.asItem(), renderer) != null) {
            throw new IllegalArgumentException("Item " + Item.getId((Item)item.asItem()) + " already has a renderer!");
        }
    }

    @Override
    @Nullable
    public ItemRendererRegistry.DynamicItemRenderer get(ItemLike item) {
        Objects.requireNonNull(item.asItem(), "item is null");
        return RENDERERS.get(item.asItem());
    }
}

