/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.data;

import com.shiftthedev.alexandria.Alexandria;
import com.shiftthedev.alexandria.data.EntityDataComponent;
import com.shiftthedev.alexandria.data.EntityInfo;
import com.shiftthedev.alexandria.items.LivingEntityItem;
import com.shiftthedev.alexandria.network.ClientUpdatePacket;
import com.shiftthedev.alexandria.network.RequestUpdatePacket;
import com.shiftthedev.alexandria.registry.CommonRegistry;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CachedEntities<L extends LivingEntity, E extends EntityInfo<L>> {
    private static final Map<String, CachedEntities<?, ?>> CACHES = new HashMap();
    protected TreeMap<UUID, E> cachedEntities = new TreeMap();
    protected Function<L, E> entityInfoFactory;
    protected static Level overworldLevel;

    public CachedEntities(Function<L, E> factory) {
        this.entityInfoFactory = factory;
    }

    public String getKey() {
        return "";
    }

    protected void loadExtraData(L entity, CompoundTag tag) {
    }

    protected ItemStack fixIfNeeded(ItemStack stack, Level level) {
        return stack;
    }

    public void updateOldStack(ItemStack stack, Level level) {
    }

    public void save(Path path) {
    }

    public void load(Path path, MinecraftServer server) {
    }

    public void cache(L entity) {
        UUID entityID = entity.getUUID();
        if (this.cachedEntities.containsKey(entityID)) {
            ((EntityInfo)this.cachedEntities.get(entityID)).updateEntity(entity);
        } else {
            this.cachedEntities.put(entityID, this.createEntityInfo(entity));
        }
    }

    public void uncache(UUID entityID, @Nullable Level level) {
        if (!this.cachedEntities.containsKey(entityID)) {
            return;
        }
        this.cachedEntities.remove(entityID);
        this.sendRemoveEntity(level, entityID);
    }

    public E createEntityInfo(L entity) {
        return (E)((EntityInfo)this.entityInfoFactory.apply(entity));
    }

    public E getEntityInfo(UUID entityID) {
        if (!this.cachedEntities.containsKey(entityID)) {
            return null;
        }
        return (E)((EntityInfo)this.cachedEntities.get(entityID));
    }

    public E getEntityInfo(ItemStack stack, Level level) {
        if (level == null) {
            if (overworldLevel == null) {
                return null;
            }
            level = overworldLevel;
        }
        if (stack.isEmpty()) {
            return null;
        }
        EntityDataComponent data = this.getData(stack = this.fixIfNeeded(stack, level), level);
        if (data == null) {
            return null;
        }
        CompoundTag tag = data.getTag();
        if (!tag.hasUUID("UUID")) {
            return null;
        }
        UUID entityID = tag.getUUID("UUID");
        if (!this.cachedEntities.containsKey(entityID)) {
            return this.createEntity(stack, tag, entityID, level);
        }
        this.cleanup(entityID);
        return (E)((EntityInfo)this.cachedEntities.get(entityID));
    }

    public L getEntity(ItemStack stack, Level level) {
        E entityInfo = this.getEntityInfo(stack, level);
        if (entityInfo == null) {
            return null;
        }
        return (L)((EntityInfo)entityInfo).getEntity();
    }

    public Component getEntityName(UUID entityID) {
        if (!this.cachedEntities.containsKey(entityID)) {
            return Component.empty();
        }
        if (Platform.getEnvironment().toPlatform() == Dist.CLIENT) {
            ((EntityInfo)this.cachedEntities.get(entityID)).updateTime();
        }
        return ((EntityInfo)this.cachedEntities.get(entityID)).getName();
    }

    public void setEntityName(UUID entityID, String entityName) {
        if (!this.cachedEntities.containsKey(entityID)) {
            return;
        }
        ((EntityInfo)this.cachedEntities.get(entityID)).setName(entityName);
    }

    protected void cleanup(UUID entityID) {
        ((EntityInfo)this.cachedEntities.get(entityID)).updateTime();
        Set clear = this.cachedEntities.entrySet().stream().filter(entrySet -> !((EntityInfo)entrySet.getValue()).shouldKeep()).map(Map.Entry::getKey).collect(Collectors.toSet());
        this.cachedEntities.keySet().removeAll(clear);
    }

    public E createEntity(ItemStack stack, CompoundTag tag, UUID entityID, Level level) {
        if (level == null) {
            if (overworldLevel == null) {
                return null;
            }
            level = overworldLevel;
        }
        if (!(level instanceof ServerLevel)) {
            this.requestUpdate(entityID);
            return null;
        }
        L entity = this.createEntity(entityID, tag, level);
        if (entity == null) {
            return null;
        }
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            entity.setCustomName(stack.getHoverName());
        }
        this.cache(entity);
        level.getProfiler().pop();
        return (E)((EntityInfo)this.cachedEntities.get(entityID));
    }

    public L createEntity(UUID entityID, CompoundTag tag, Level level) {
        if (level == null) {
            if (overworldLevel == null) {
                return null;
            }
            level = overworldLevel;
        }
        if (tag.contains("removing")) {
            return null;
        }
        Optional entityType = EntityType.byString((String)tag.getString("entity_type"));
        if (entityType.isEmpty()) {
            return null;
        }
        LivingEntity entity = (LivingEntity)((EntityType)entityType.get()).create(level);
        if (entity == null) {
            return null;
        }
        if (!this.extraChecks(entity)) {
            return null;
        }
        entity.load(tag);
        entity.readAdditionalSaveData(tag);
        entity.setUUID(entityID);
        this.loadExtraData(entity, tag);
        return (L)entity;
    }

    protected boolean extraChecks(L entity) {
        return true;
    }

    protected void requestUpdate(UUID entityID) {
        RequestUpdatePacket.sendToServer(entityID, this.getKey());
    }

    public EntityDataComponent getData(ItemStack stack, @Nullable Level level) {
        if (level == null) {
            if (overworldLevel == null) {
                return null;
            }
            level = overworldLevel;
        }
        stack = this.fixIfNeeded(stack, level);
        return EntityDataComponent.get(stack, level);
    }

    public ItemStack createItemStack(L entity, ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        entity.saveWithoutId(tag);
        EntityDataComponent data = new EntityDataComponent(tag, Alexandria.VERSION);
        stack.set((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)data);
        if (entity.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)entity.getCustomName());
        }
        return stack;
    }

    public ItemStack recreateItemStack(CompoundTag tag, HolderLookup.Provider provider, @Nullable Level level) {
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
        if (stack.isEmpty()) {
            return stack;
        }
        if (!(stack.getItem() instanceof LivingEntityItem)) {
            return stack;
        }
        if (level == null) {
            if (overworldLevel == null) {
                return stack;
            }
            level = overworldLevel;
        }
        stack = this.fixIfNeeded(stack, level);
        EntityDataComponent.get(stack, level).update(stack, level);
        return stack;
    }

    public void sendToAll(Level level, UUID entityID) {
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (level.isClientSide || !this.cachedEntities.containsKey(entityID)) {
            return;
        }
        level.players().forEach(player -> this.sendCachedEntity((ServerPlayer)player, entityID));
    }

    public void sendCachedEntity(ServerPlayer player, UUID entityID) {
        if (!this.cachedEntities.containsKey(entityID)) {
            return;
        }
        ClientUpdatePacket.sendToPlayer(entityID, ((EntityInfo)this.cachedEntities.get(entityID)).save(new CompoundTag()), this.getKey(), player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean receiveCachedEntity(UUID entityID, CompoundTag tag, Level level) {
        if (tag == null) {
            this.cachedEntities.remove(entityID);
            return false;
        }
        EntityInfo info = (EntityInfo)this.entityInfoFactory.apply(null);
        info.load(entityID, tag, level);
        if (info.getEntity() == null) {
            this.cachedEntities.remove(entityID);
            return false;
        }
        this.cachedEntities.put(entityID, info);
        return true;
    }

    public void sendRemoveEntity(Level level, UUID entityID) {
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (level.isClientSide) {
            return;
        }
        level.players().forEach(player -> ClientUpdatePacket.sendToPlayer(entityID, new CompoundTag(), this.getKey(), (ServerPlayer)player));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void receiveRemoveEntity(UUID entityID) {
        this.cachedEntities.remove(entityID);
    }

    public boolean hasEntity(UUID uuid) {
        return this.cachedEntities.containsKey(uuid);
    }

    public static <L extends LivingEntity, E extends EntityInfo<L>> CachedEntities<L, E> registerCache(String cacheKey, CachedEntities<L, E> cache) {
        CACHES.put(cacheKey, cache);
        return cache;
    }

    public static void clearData() {
        CACHES.forEach((type, cache) -> {
            cache.cachedEntities.clear();
            cache.cachedEntities = new TreeMap();
        });
        overworldLevel = null;
    }

    public static <L extends LivingEntity, E extends EntityInfo<L>> CachedEntities<L, E> getCache(String cacheKey) {
        return CACHES.get(cacheKey);
    }

    public static void saveAll(Path path) {
        CACHES.forEach((type, cache) -> cache.save(path));
    }

    public static void loadAll(Path path, MinecraftServer server) {
        overworldLevel = server.overworld();
        CACHES.forEach((type, cache) -> cache.load(path, server));
    }
}

