/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.data;

import com.mojang.serialization.Codec;
import com.shiftthedev.alexandria.Alexandria;
import com.shiftthedev.alexandria.items.LivingEntityItem;
import com.shiftthedev.alexandria.registry.CommonRegistry;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EntityDataComponent {
    public static final Codec<EntityDataComponent> CODEC = CompoundTag.CODEC.xmap(EntityDataComponent::fromTag, data -> data.tag);
    public static final StreamCodec<RegistryFriendlyByteBuf, EntityDataComponent> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, EntityDataComponent>(){

        public EntityDataComponent decode(RegistryFriendlyByteBuf buf) {
            return new EntityDataComponent(buf.readNbt(), buf.readInt());
        }

        public void encode(RegistryFriendlyByteBuf buf, EntityDataComponent data) {
            buf.writeNbt((Tag)data.tag);
            buf.writeInt(data.version);
        }
    };
    private final CompoundTag tag;
    private final int version;

    public EntityDataComponent(CompoundTag tag, int version) {
        this.tag = tag;
        this.version = version;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public static EntityDataComponent get(ItemStack stack, Level level) {
        if (!(stack.getItem() instanceof LivingEntityItem)) {
            return null;
        }
        EntityDataComponent data = (EntityDataComponent)stack.get((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get());
        if (data == null) {
            data = new EntityDataComponent(new CompoundTag(), Alexandria.VERSION);
            stack.set((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get(), (Object)data);
        }
        return data;
    }

    public static EntityDataComponent fromTag(CompoundTag tag) {
        if (!tag.contains("VERSION")) {
            return new EntityDataComponent(tag, Alexandria.VERSION);
        }
        return new EntityDataComponent(tag, tag.getInt("VERSION"));
    }

    public void update(ItemStack stack, Level level) {
        if (level.isClientSide) {
            return;
        }
        EntityDataComponent data = (EntityDataComponent)stack.get((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get());
        if (data.version == Alexandria.VERSION) {
            return;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntityDataComponent other = (EntityDataComponent)obj;
        return Objects.equals(this.tag, other.tag) && this.version == other.version;
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.version);
    }
}

