/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.data;

import com.shiftthedev.alexandria.mixins.WalkAnimationStateAccessor;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntityInfo<T extends LivingEntity> {
    private long time;
    protected T entity;

    public EntityInfo(T entity) {
        if (entity != null) {
            this.entity = entity;
            this.setupPose();
            this.updateTime();
        }
    }

    public T getEntity() {
        return this.entity;
    }

    public void updateEntity(T newEntity) {
        this.entity = newEntity;
    }

    public Component getName() {
        if (this.entity == null) {
            return Component.empty();
        }
        return this.entity.getDisplayName();
    }

    public void setName(String name) {
        if (StringUtil.isBlank((String)name)) {
            this.entity.setCustomName(null);
            return;
        }
        this.entity.setCustomName((Component)Component.literal((String)name));
    }

    public boolean shouldKeep() {
        return this.time > System.currentTimeMillis();
    }

    public void updateTime() {
        this.time = System.currentTimeMillis() + 60000L;
    }

    protected void setupPose() {
        if (this.entity == null) {
            return;
        }
        ((LivingEntity)this.entity).yBodyRot = 0.0f;
        ((LivingEntity)this.entity).yBodyRotO = 0.0f;
        ((LivingEntity)this.entity).yRotO = 0.0f;
        ((LivingEntity)this.entity).xRotO = 0.0f;
        this.entity.setYRot(0.0f);
        this.entity.setXRot(0.0f);
        ((LivingEntity)this.entity).yHeadRot = 0.0f;
        ((LivingEntity)this.entity).yHeadRotO = 0.0f;
        ((LivingEntity)this.entity).deathTime = 0;
        ((WalkAnimationStateAccessor)((LivingEntity)this.entity).walkAnimation).setSpeedOld(0.0f);
        this.entity.setSpeed(0.0f);
        ((WalkAnimationStateAccessor)((LivingEntity)this.entity).walkAnimation).setPosition(0.0f);
        ((LivingEntity)this.entity).xo = 0.0;
        ((LivingEntity)this.entity).zo = 0.0;
        ((LivingEntity)this.entity).attackAnim = 0.0f;
        this.entity.level().getProfiler().pop();
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.entity == null) {
            return tag;
        }
        tag = this.entity.saveWithoutId(tag);
        tag.putString("entity_type", EntityType.getKey((EntityType)this.entity.getType()).toString());
        return tag;
    }

    public void load(UUID entityID, CompoundTag tag, Level level) {
        if (!tag.contains("entity_type")) {
            return;
        }
        Optional entityType = EntityType.byString((String)tag.getString("entity_type"));
        if (entityType.isEmpty()) {
            return;
        }
        this.entity = (LivingEntity)((EntityType)entityType.get()).create(level);
        if (this.entity == null) {
            return;
        }
        this.entity.load(tag);
        this.entity.setUUID(entityID);
        this.updateTime();
        this.setupPose();
        level.getProfiler().pop();
    }
}

