/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.items;

import com.shiftthedev.alexandria.blocks.EntityContainer;
import com.shiftthedev.alexandria.data.CachedEntities;
import com.shiftthedev.alexandria.data.EntityDataComponent;
import com.shiftthedev.alexandria.mixins.EntityAccessor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LivingEntityItem<T extends LivingEntity>
extends Item {
    public LivingEntityItem(Item.Properties properties) {
        super(properties);
    }

    public String getKey() {
        return "";
    }

    public InteractionResult useOn(UseOnContext ctx) {
        EntityContainer container;
        Player player = ctx.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (ctx.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = ctx.getItemInHand();
        ServerLevel level = (ServerLevel)player2.level();
        Object entity = CachedEntities.getCache(this.getKey()).getEntity(stack, (Level)level);
        if (entity == null) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = ctx.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        Direction direction = ctx.getClickedFace();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof EntityContainer && (container = (EntityContainer)blockEntity).isValidEntity((LivingEntity)entity)) {
            EntityContainer entityContainer = container;
            return entityContainer.addEntity(entity, stack, player2, level);
        }
        return this.place(entity, stack, blockPos, blockState, direction, player2, level);
    }

    protected InteractionResult place(T entity, ItemStack stack, BlockPos blockPos, BlockState blockState, Direction direction, ServerPlayer player, ServerLevel level) {
        if (entity == null) {
            return InteractionResult.FAIL;
        }
        if (!blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty()) {
            blockPos = direction == Direction.DOWN ? blockPos.relative(direction, 2) : blockPos.relative(direction);
        }
        BlockPos finalBlockPos = blockPos;
        level.getServer().execute(() -> {
            ((EntityAccessor)entity).invokeSetLevel((Level)level);
            entity.setPos(Vec3.atCenterOf((Vec3i)finalBlockPos));
            ((EntityAccessor)entity).setRemovalReason(null);
            if (!level.addFreshEntity((Entity)entity)) {
                return;
            }
            player.getInventory().removeItem(stack);
            CachedEntities.getCache(this.getKey()).uncache(entity.getUUID(), (Level)level);
        });
        level.getProfiler().pop();
        return InteractionResult.SUCCESS;
    }

    public void onDestroyed(ItemEntity itemEntity) {
        super.onDestroyed(itemEntity);
        if (itemEntity.level().isClientSide) {
            return;
        }
        ServerLevel level = (ServerLevel)itemEntity.level();
        EntityDataComponent data = CachedEntities.getCache(this.getKey()).getData(itemEntity.getItem(), (Level)level);
        if (data == null) {
            return;
        }
        CompoundTag tag = data.getTag();
        if (tag.hasUUID("UUID")) {
            CachedEntities.getCache(this.getKey()).uncache(tag.getUUID("UUID"), (Level)level);
        }
    }

    public Component getName(ItemStack itemStack) {
        if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            return itemStack.getHoverName();
        }
        EntityDataComponent data = EntityDataComponent.get(itemStack, null);
        if (data == null) {
            return super.getName(itemStack);
        }
        return CachedEntities.getCache(this.getKey()).getEntityName(data.getTag().getUUID("UUID"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        if (Minecraft.getInstance().level == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        EntityDataComponent data = CachedEntities.getCache(this.getKey()).getData(itemStack, (Level)level);
        if (data == null) {
            list.add((Component)Component.translatable((String)"tooltip.alexandria.old"));
            list.add((Component)Component.translatable((String)"tooltip.alexandria.report"));
            return;
        }
        CompoundTag tag = data.getTag();
        if (tag.isEmpty()) {
            list.add((Component)Component.translatable((String)"tooltip.alexandria.old"));
            list.add((Component)Component.translatable((String)"tooltip.alexandria.report"));
            return;
        }
        if (tag.hasUUID("UUID") && !CachedEntities.getCache(this.getKey()).hasEntity(tag.getUUID("UUID"))) {
            list.add((Component)Component.translatable((String)"tooltip.alexandria.borked"));
            list.add((Component)Component.translatable((String)"tooltip.alexandria.report"));
            return;
        }
        this.appendExtraText(list, data, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void appendExtraText(List<Component> list, EntityDataComponent data, ItemStack itemStack) {
    }
}

