/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.alexandria.mixins;

import com.shiftthedev.alexandria.data.CachedEntities;
import com.shiftthedev.alexandria.data.EntityDataComponent;
import com.shiftthedev.alexandria.items.LivingEntityItem;
import com.shiftthedev.alexandria.registry.CommonRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    public AnvilMenuMixin(@Nullable MenuType<?> menuType, int i, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super(menuType, i, inventory, containerLevelAccess);
    }

    @Inject(method={"setItemName(Ljava/lang/String;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;remove(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;")})
    private void setItemName_reset_alexandria(String string, CallbackInfoReturnable<Boolean> cir) {
        Item item;
        if (!this.player.level().isClientSide && this.getSlot(2).hasItem() && (item = this.getSlot(2).getItem().getItem()) instanceof LivingEntityItem) {
            EntityDataComponent data;
            LivingEntityItem livingEntityItem = (LivingEntityItem)item;
            ItemStack stack = this.getSlot(2).getItem();
            if (stack.has((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get()) && (data = (EntityDataComponent)stack.get((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get())) != null && data.getTag().hasUUID("UUID")) {
                CachedEntities.getCache(livingEntityItem.getKey()).setEntityName(data.getTag().getUUID("UUID"), "");
            }
        }
    }

    @Inject(method={"setItemName(Ljava/lang/String;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;")})
    private void setItemName_set_alexandria(String string, CallbackInfoReturnable<Boolean> cir) {
        Item item;
        if (!this.player.level().isClientSide && this.getSlot(2).hasItem() && (item = this.getSlot(2).getItem().getItem()) instanceof LivingEntityItem) {
            EntityDataComponent data;
            LivingEntityItem livingEntityItem = (LivingEntityItem)item;
            ItemStack stack = this.getSlot(2).getItem();
            if (stack.has((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get()) && (data = (EntityDataComponent)stack.get((DataComponentType)CommonRegistry.ENTITY_DATA_COMPONENT.get())) != null && data.getTag().hasUUID("UUID")) {
                String validName = AnvilMenuMixin.validate(string);
                CachedEntities.getCache(livingEntityItem.getKey()).setEntityName(data.getTag().getUUID("UUID"), validName);
            }
        }
    }

    private static String validate(String string) {
        String string2 = StringUtil.filterText((String)string);
        return string2.length() <= 50 ? string2 : "";
    }
}

